/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.actions;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.framework.actions.ActionContext;
import java.security.Key;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SecurityHook;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.communications.base.ActiveSurvey;
import org.aspcfs.modules.communications.base.ScheduledRecipient;
import org.aspcfs.modules.communications.base.SurveyBase;
import org.aspcfs.modules.communications.base.SurveyResponse;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.login.base.AuthenticationItem;
import org.aspcfs.modules.system.base.Site;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.PrivateString;
import org.aspcfs.utils.web.CountrySelect;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.StateSelect;

public final class ProcessAddressSurvey
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDefault(ActionContext context) {
        ActiveSurvey thisSurvey = null;
        Connection db = null;
        int addressSurveyId = -1;
        int contactId = -1;
        int campaignId = -1;
        int addressNoChangeId = -1;
        Contact thisContact = null;
        String codedId = context.getRequest().getParameter("id");
        if (codedId != null && codedId.startsWith("${surveyId")) {
            return "InvalidRequestError";
        }
        try {
            ScheduledRecipient recipient;
            AuthenticationItem auth = new AuthenticationItem();
            db = auth.getConnection(context, false);
            String dbName = auth.getConnectionElement(context).getDbName();
            String filename = this.getPath(context) + dbName + fs + "keys" + fs + "survey2.key";
            Key key = PrivateString.loadEncodedKey(filename);
            String uncodedId = PrivateString.decrypt(key, codedId);
            StringTokenizer st = new StringTokenizer(uncodedId, ",");
            while (st.hasMoreTokens()) {
                String pair = st.nextToken();
                StringTokenizer stPair = new StringTokenizer(pair, "=");
                String param = stPair.nextToken();
                String value = stPair.nextToken();
                if ("addressSurveyId".equals(param)) {
                    addressSurveyId = Integer.parseInt(value);
                }
                if ("cid".equals(param)) {
                    contactId = Integer.parseInt(value);
                }
                if ("campaignId".equals(param)) {
                    campaignId = Integer.parseInt(value);
                }
                if (!"addressNoChangeId".equals(param)) continue;
                addressNoChangeId = Integer.parseInt(value);
            }
            if (campaignId != -1) {
                if (addressSurveyId != -1) {
                    thisSurvey = new ActiveSurvey(db, addressSurveyId);
                } else if (addressNoChangeId != -1) {
                    thisSurvey = new ActiveSurvey(db, addressNoChangeId);
                }
            }
            if (contactId != -1 && campaignId != -1 && (recipient = new ScheduledRecipient(db, campaignId, contactId)).getReplyDate() == null) {
                recipient.setReplyDate(DateUtils.roundUpToNextFive(System.currentTimeMillis()));
                recipient.update(db);
            }
            thisContact = new Contact(db, contactId);
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            context.getRequest().setAttribute("id", (Object)codedId);
            this.prepareFormElements(context, db);
            ConnectionElement ce = auth.getConnectionElement(context);
            SystemStatus systemStatus = this.getSystemStatus(context, ce);
            if (systemStatus == null) {
                Site thisSite = SecurityHook.retrieveSite(context.getServletContext(), context.getRequest());
                systemStatus = SecurityHook.retrieveSystemStatus(context.getServletContext(), db, ce, thisSite.getLanguage());
            }
            StateSelect stateSelect = (StateSelect)context.getRequest().getAttribute("StateSelect");
            ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
            if (stateSelect == null) {
                stateSelect = systemStatus != null ? new StateSelect(systemStatus, thisContact.getAddressList().getCountries() + "," + prefs.get("SYSTEM.COUNTRY")) : new StateSelect(thisContact.getAddressList().getCountries() + "," + prefs.get("SYSTEM.COUNTRY"));
            }
            stateSelect.setPreviousStates(thisContact.getAddressList().getSelectedStatesHashMap());
            CountrySelect countrySelect = new CountrySelect(systemStatus);
            context.getRequest().setAttribute("StateSelect", (Object)stateSelect);
            context.getRequest().setAttribute("CountrySelect", (Object)countrySelect);
            context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "NotFoundError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        if (addressNoChangeId != -1) {
            return "PrepareAddressCurrentOK";
        }
        return "PrepareOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        Connection db = null;
        SurveyBase thisSurvey = null;
        int addressSurveyId = -1;
        int contactId = -1;
        int campaignId = -1;
        int addressNoChangeId = -1;
        try {
            AuthenticationItem auth = new AuthenticationItem();
            db = auth.getConnection(context, false);
            String dbName = auth.getConnectionElement(context).getDbName();
            String filename = this.getPath(context) + dbName + fs + "keys" + fs + "survey2.key";
            String codedId = context.getRequest().getParameter("id");
            Key key = PrivateString.loadEncodedKey(filename);
            String uncodedId = PrivateString.decrypt(key, codedId);
            StringTokenizer st = new StringTokenizer(uncodedId, ",");
            while (st.hasMoreTokens()) {
                String pair = st.nextToken();
                StringTokenizer stPair = new StringTokenizer(pair, "=");
                String param = stPair.nextToken();
                String value = stPair.nextToken();
                if ("addressSurveyId".equals(param)) {
                    addressSurveyId = Integer.parseInt(value);
                    continue;
                }
                if ("cid".equals(param)) {
                    contactId = Integer.parseInt(value);
                    continue;
                }
                if ("campaignId".equals(param)) {
                    campaignId = Integer.parseInt(value);
                    continue;
                }
                if (!"addressNoChangeId".equals(param)) continue;
                addressNoChangeId = Integer.parseInt(value);
            }
            if (addressSurveyId != -1) {
                Contact thisContact = (Contact)((Object)context.getFormBean());
                thisContact.setId(contactId);
                thisContact.setRequestItems(context);
                thisContact.updateNameandAddress(db);
            }
            if (campaignId != -1) {
                SurveyResponse thisResponse = new SurveyResponse();
                thisResponse.setContactId(contactId);
                thisResponse.setUniqueCode(codedId);
                thisResponse.setIpAddress(context.getIpAddress());
                if (addressSurveyId != -1) {
                    thisResponse.setActiveSurveyId(addressSurveyId);
                    thisResponse.setAddressUpdated(SurveyResponse.ADDRESS_UPDATED);
                    thisResponse.insert(db);
                    thisSurvey = new ActiveSurvey(db, addressSurveyId);
                }
                if (addressNoChangeId != -1) {
                    thisResponse.setActiveSurveyId(addressNoChangeId);
                    thisResponse.setAddressUpdated(SurveyResponse.ADDRESS_VALID);
                    thisResponse.insert(db);
                    thisSurvey = new ActiveSurvey(db, addressNoChangeId);
                }
                context.getRequest().setAttribute("ThankYouText", (Object)thisSurvey.getOutro());
            }
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return "UpdateOK";
    }

    private void prepareFormElements(ActionContext context, Connection db) throws SQLException {
        LookupList phoneTypeList = new LookupList(db, "lookup_contactphone_types");
        context.getRequest().setAttribute("ContactPhoneTypeList", (Object)phoneTypeList);
        LookupList emailTypeList = new LookupList(db, "lookup_contactemail_types");
        context.getRequest().setAttribute("ContactEmailTypeList", (Object)emailTypeList);
        LookupList addressTypeList = new LookupList(db, "lookup_contactaddress_types");
        context.getRequest().setAttribute("ContactAddressTypeList", (Object)addressTypeList);
        LookupList instantMessageAddressTypeList = new LookupList(db, "lookup_im_types");
        context.getRequest().setAttribute("ContactInstantMessageAddressTypeList", (Object)instantMessageAddressTypeList);
        LookupList instantMessageAddressServiceList = new LookupList(db, "lookup_im_services");
        context.getRequest().setAttribute("ContactInstantMessageAddressServiceList", (Object)instantMessageAddressServiceList);
        LookupList textMessageAddressTypeList = new LookupList(db, "lookup_textmessage_types");
        context.getRequest().setAttribute("ContactTextMessageAddressTypeList", (Object)textMessageAddressTypeList);
    }
}

