/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.actions;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemVersion;
import com.zeroio.webutils.FileDownload;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.servlet.http.HttpSession;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.login.base.AuthenticationItem;
import org.aspcfs.utils.DatabaseUtils;

public final class ProcessFileItemImage
extends CFSModule {
    public static final String PROCESS_FILE_ITEM_NAME = "processFileItemImages";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String executeCommandDefault(ActionContext context) {
        String id = context.getRequest().getParameter("id");
        String path = context.getRequest().getParameter("path");
        String version = context.getRequest().getParameter("version");
        String thumbnail = context.getRequest().getParameter("thumbnail");
        Object thisItem = null;
        Connection db = null;
        try {
            ArrayList allowedImages = (ArrayList)context.getSession().getAttribute(PROCESS_FILE_ITEM_NAME);
            if (allowedImages == null || !allowedImages.contains(id + (version != null ? "-" + version : "") + (thumbnail != null ? "TH" : ""))) {
                String string = "-none-";
                return string;
            }
            AuthenticationItem auth = new AuthenticationItem();
            db = auth.getConnection(context, false);
            FileItem fileItem = new FileItem(db, Integer.parseInt(id));
            String filePath = null;
            Timestamp lastModified = null;
            if (version != null) {
                fileItem.buildVersionList(db);
                FileItemVersion thisVersion = fileItem.getVersion(Double.parseDouble(version));
                filePath = this.getPath(context, path) + ProcessFileItemImage.getDatePath(thisVersion.getModified()) + thisVersion.getFilename();
                lastModified = thisVersion.getModificationDate();
            } else {
                filePath = this.getPath(context, path) + ProcessFileItemImage.getDatePath(fileItem.getModified()) + fileItem.getFilename();
                lastModified = fileItem.getModificationDate();
            }
            if (thumbnail != null) {
                filePath = filePath + "TH";
            }
            this.freeConnection(context, db);
            db = null;
            FileDownload fileDownload = new FileDownload();
            fileDownload.setFullPath(filePath);
            fileDownload.setDisplayName(fileItem.getClientFilename());
            if (fileDownload.fileExists()) {
                if (lastModified != null) {
                    fileDownload.setFileTimestamp(lastModified.getTime());
                }
                fileDownload.streamContent(context);
            } else {
                System.err.println("ProcessFileItemImage-> Trying to send a file that does not exist: " + filePath + fileItem.getClientFilename());
            }
            if (db == null) return "-none-";
        }
        catch (SocketException se) {
            return "-none-";
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return "-none-";
        }
        finally {
            if (db != null) {
                this.freeConnection(context, db);
            }
        }
        this.freeConnection(context, db);
        return "-none-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String executeCommandStreamImage(ActionContext context) {
        String string;
        String id = context.getRequest().getParameter("id");
        String path = context.getRequest().getParameter("path");
        String version = context.getRequest().getParameter("version");
        String thumbnail = context.getRequest().getParameter("thumbnail");
        String rowIdString = context.getRequest().getParameter("row");
        Object thisItem = null;
        Connection db = null;
        ConnectionElement ce = null;
        if (!"website".equals(path)) {
            return "-none-";
        }
        try {
            AuthenticationItem auth = new AuthenticationItem();
            db = auth.getConnection(context, false);
            ce = auth.getConnectionElement(context);
            this.streamImage(context, ce, db, id, path, version, thumbnail);
            string = "-none-";
            if (db == null) return string;
        }
        catch (SocketException se) {
            if (db == null) return "-none-";
            this.freeConnection(context, db);
            return "-none-";
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            if (db == null) return "-none-";
            {
                catch (Throwable throwable) {
                    if (db == null) throw throwable;
                    this.freeConnection(context, db);
                    throw throwable;
                }
            }
            this.freeConnection(context, db);
            return "-none-";
        }
        this.freeConnection(context, db);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void addImageToAllowedImages(ActionContext context, String imageId, String version, String thumbnail) {
        HttpSession httpSession = context.getSession();
        synchronized (httpSession) {
            ArrayList<String> allowedImages = (ArrayList<String>)context.getSession().getAttribute(PROCESS_FILE_ITEM_NAME);
            if (allowedImages == null) {
                allowedImages = new ArrayList<String>();
                context.getSession().setAttribute(PROCESS_FILE_ITEM_NAME, allowedImages);
            }
            allowedImages.add(imageId + (version != null ? "-" + version : "") + (DatabaseUtils.parseBoolean(thumbnail) ? "TH" : ""));
        }
    }

    private void streamImage(ActionContext context, ConnectionElement ce, Connection db, String imageId, String path, String version, String thumbnail) throws Exception {
        FileItem fileItem = new FileItem(db, Integer.parseInt(imageId));
        String filePath = null;
        Timestamp lastModified = null;
        if (version != null) {
            fileItem.buildVersionList(db);
            FileItemVersion thisVersion = fileItem.getVersion(Double.parseDouble(version));
            filePath = this.getPath(context, ce, path) + ProcessFileItemImage.getDatePath(thisVersion.getModified()) + thisVersion.getFilename();
            lastModified = thisVersion.getModificationDate();
        } else {
            filePath = this.getPath(context, ce, path) + ProcessFileItemImage.getDatePath(fileItem.getModified()) + fileItem.getFilename();
            lastModified = fileItem.getModificationDate();
        }
        if (thumbnail != null) {
            filePath = filePath + "TH";
        }
        FileDownload fileDownload = new FileDownload();
        fileDownload.setFullPath(filePath);
        fileDownload.setDisplayName(fileItem.getClientFilename());
        if (fileDownload.fileExists()) {
            if (lastModified != null) {
                fileDownload.setFileTimestamp(lastModified.getTime());
            }
            fileDownload.streamContent(context);
        } else {
            System.err.println("ProcessFileItemImage-> Trying to send a file that does not exist: " + filePath + fileItem.getClientFilename());
        }
    }
}

