/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.communications.base.Message;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.login.base.AuthenticationItem;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.Template;

public final class ProcessMessage
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String executeCommandDefault(ActionContext context) {
        Connection db = null;
        String code = context.getRequest().getParameter("code");
        String messageId = context.getRequest().getParameter("messageId");
        String contactId = context.getRequest().getParameter("contactId");
        try {
            AuthenticationItem auth = new AuthenticationItem();
            auth.setId(context.getRequest().getServerName());
            auth.setCode(code);
            db = auth.getConnection(context);
            Message thisMessage = new Message(db, messageId);
            if (contactId != null && !"".equals(contactId)) {
                Contact thisContact = new Contact(db, Integer.parseInt(contactId));
                Template template = new Template();
                template.setText(thisMessage.getMessageText());
                String value = template.getValue("surveyId");
                if (value != null) {
                    template.addParseElement("${surveyId=" + value + "}", "- Survey not available by fax -");
                }
                template.addParseElement("${name}", StringUtils.toHtml(thisContact.getNameFirstLast()));
                template.addParseElement("${firstname}", StringUtils.toHtml(thisContact.getNameFirst()));
                template.addParseElement("${lastname}", StringUtils.toHtml(thisContact.getNameLast()));
                template.addParseElement("${company}", StringUtils.toHtml(thisContact.getCompany()));
                template.addParseElement("${department}", StringUtils.toHtml(thisContact.getDepartmentName()));
                thisMessage.setMessageText(template.getParsedText());
            }
            context.getRequest().setAttribute("Message", (Object)thisMessage);
            if (db == null) return "PreviewOK";
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            String string = "SystemError";
            return string;
        }
        finally {
            if (db != null) {
                this.freeConnection(context, db);
            }
        }
        this.freeConnection(context, db);
        return "PreviewOK";
    }
}

