/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.security.Key;
import java.sql.Connection;
import java.util.StringTokenizer;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.communications.base.ActiveSurvey;
import org.aspcfs.modules.communications.base.ScheduledRecipient;
import org.aspcfs.modules.communications.base.SurveyResponse;
import org.aspcfs.modules.login.base.AuthenticationItem;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.PrivateString;

public final class ProcessSurvey
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDefault(ActionContext context) {
        ActiveSurvey thisSurvey = null;
        Connection db = null;
        String codedId = context.getRequest().getParameter("id");
        if (codedId != null && codedId.startsWith("${surveyId")) {
            return "InvalidRequestError";
        }
        try {
            ScheduledRecipient recipient;
            AuthenticationItem auth = new AuthenticationItem();
            db = auth.getConnection(context, false);
            String dbName = auth.getConnectionElement(context).getDbName();
            String filename = this.getPath(context) + dbName + fs + "keys" + fs + "survey2.key";
            Key key = PrivateString.loadEncodedKey(filename);
            String uncodedId = PrivateString.decrypt(key, codedId);
            int surveyId = -1;
            int contactId = -1;
            StringTokenizer st = new StringTokenizer(uncodedId, ",");
            while (st.hasMoreTokens()) {
                String pair = st.nextToken();
                StringTokenizer stPair = new StringTokenizer(pair, "=");
                String param = stPair.nextToken();
                String value = stPair.nextToken();
                if ("id".equals(param)) {
                    surveyId = Integer.parseInt(value);
                    continue;
                }
                if (!"cid".equals(param)) continue;
                contactId = Integer.parseInt(value);
            }
            thisSurvey = new ActiveSurvey(db, surveyId);
            if (contactId != -1 && (recipient = new ScheduledRecipient(db, thisSurvey.getCampaignId(), contactId)).getReplyDate() == null) {
                recipient.setReplyDate(DateUtils.roundUpToNextFive(System.currentTimeMillis()));
                recipient.update(db);
            }
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "NotFoundError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        if (thisSurvey != null) {
            context.getRequest().setAttribute("ActiveSurvey", (Object)thisSurvey);
            return "ViewOK";
        }
        context.getRequest().setAttribute("Error", (Object)"No Survey Found.");
        return "NotFoundError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsert(ActionContext context) {
        Connection db = null;
        ActiveSurvey thisSurvey = null;
        try {
            AuthenticationItem auth = new AuthenticationItem();
            db = auth.getConnection(context, false);
            String dbName = auth.getConnectionElement(context).getDbName();
            String filename = this.getPath(context) + dbName + fs + "keys" + fs + "survey2.key";
            String codedId = context.getRequest().getParameter("id");
            Key key = PrivateString.loadEncodedKey(filename);
            String uncodedId = PrivateString.decrypt(key, codedId);
            int surveyId = -1;
            int contactId = -1;
            StringTokenizer st = new StringTokenizer(uncodedId, ",");
            while (st.hasMoreTokens()) {
                String pair = st.nextToken();
                StringTokenizer stPair = new StringTokenizer(pair, "=");
                String param = stPair.nextToken();
                String value = stPair.nextToken();
                if ("id".equals(param)) {
                    surveyId = Integer.parseInt(value);
                    continue;
                }
                if (!"cid".equals(param)) continue;
                contactId = Integer.parseInt(value);
            }
            SurveyResponse thisResponse = new SurveyResponse(context);
            thisResponse.setActiveSurveyId(surveyId);
            thisResponse.setContactId(contactId);
            thisResponse.setUniqueCode(codedId);
            thisResponse.insert(db);
            thisSurvey = new ActiveSurvey(db, surveyId);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        context.getRequest().setAttribute("ThankYouText", (Object)thisSurvey.getOutro());
        return "InsertOK";
    }
}

