/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.communications.base.ActiveSurveyQuestion;
import org.aspcfs.modules.communications.base.ActiveSurveyQuestionList;
import org.aspcfs.modules.communications.base.Survey;
import org.aspcfs.modules.communications.base.SurveyAnswerList;
import org.aspcfs.modules.communications.base.SurveyBase;
import org.aspcfs.modules.communications.base.SurveyQuestionList;
import org.aspcfs.utils.DatabaseUtils;

public class ActiveSurvey
extends SurveyBase {
    protected int id = -1;
    private int campaignId = -1;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private Timestamp modified = null;
    private Timestamp entered = null;
    private boolean enabled = true;
    private ActiveSurveyQuestionList questions = new ActiveSurveyQuestionList();
    private SurveyAnswerList answers = new SurveyAnswerList();

    public void setCampaignId(String tmp) {
        this.campaignId = Integer.parseInt(tmp);
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public ActiveSurvey() {
    }

    public ActiveSurvey(Survey is) {
        this.setName(is.getName());
        this.setDescription(is.getDescription());
        this.setIntro(is.getIntro());
        this.setOutro(is.getOutro());
        this.setItemLength(is.getItemLength());
        this.setType(is.getType());
        this.setQuestions(is.getQuestions());
    }

    public ActiveSurvey(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public ActiveSurvey(Connection db, int surveyId) throws SQLException {
        if (surveyId < 1) {
            throw new SQLException("ActiveSurvey ID not specified.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT s.* FROM active_survey s WHERE s.active_survey_id = ?");
        pst.setInt(1, surveyId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("ActiveSurvey record not found.");
        }
        this.questions.setActiveSurveyId(this.getId());
        this.questions.buildList(db);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setCampaignId(int tmp) {
        this.campaignId = tmp;
    }

    public int getCampaignId() {
        return this.campaignId;
    }

    public int getId() {
        return this.id;
    }

    public static int getId(Connection db, int activeCampaignId, int surveyType) throws SQLException {
        int surveyId = -1;
        PreparedStatement pst = db.prepareStatement("SELECT active_survey_id FROM active_survey WHERE campaign_id = ? AND " + DatabaseUtils.addQuotes(db, "type") + " = ? ");
        pst.setInt(1, activeCampaignId);
        pst.setInt(2, surveyType);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            surveyId = rs.getInt("active_survey_id");
        }
        rs.close();
        pst.close();
        return surveyId;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public String getModifiedString() {
        try {
            return DateFormat.getDateInstance(3).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getModifiedDateTimeString() {
        try {
            return DateFormat.getDateTimeInstance(3, 3).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public String getEnteredString() {
        try {
            return DateFormat.getDateInstance(3).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getEnteredDateTimeString() {
        try {
            return DateFormat.getDateTimeInstance(3, 3).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public SurveyAnswerList getAnswers() {
        return this.answers;
    }

    public void setAnswers(SurveyAnswerList answers) {
        this.answers = answers;
    }

    public void setQuestions(SurveyQuestionList inactiveQuestions) {
        this.questions = new ActiveSurveyQuestionList(inactiveQuestions);
        this.questions.setActiveSurveyId(this.id);
    }

    public void setAnswerItems(HttpServletRequest request) {
        this.answers = new SurveyAnswerList(request);
    }

    public ActiveSurveyQuestionList getQuestions() {
        return this.questions;
    }

    public void setQuestions(ActiveSurveyQuestionList items) {
        this.questions = items;
    }

    public boolean insert(Connection db) throws SQLException {
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            int i = 0;
            this.id = DatabaseUtils.getNextSeq(db, "active_survey_active_survey_seq");
            PreparedStatement pst = db.prepareStatement("INSERT INTO active_survey (" + (this.id > -1 ? "active_survey_id, " : "") + "campaign_id, name, description, intro, outro, itemLength, " + DatabaseUtils.addQuotes(db, "type") + ", " + "enteredBy, modifiedBy) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?,?,?, ?, ?, ?, ?, ?) ");
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.campaignId);
            pst.setString(++i, this.name);
            pst.setString(++i, this.description);
            pst.setString(++i, this.intro);
            pst.setString(++i, this.outro);
            pst.setInt(++i, this.itemLength);
            pst.setInt(++i, this.type);
            pst.setInt(++i, this.enteredBy);
            pst.setInt(++i, this.modifiedBy);
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "active_survey_active_survey_seq", this.id);
            for (ActiveSurveyQuestion thisQuestion : this.questions) {
                thisQuestion.insert(db, this.getId());
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean commit = true;
        Statement st = null;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            st = db.createStatement();
            st.executeUpdate("DELETE FROM active_survey_answer_items WHERE answer_id IN (SELECT answer_id FROM active_survey_answers sa, active_survey_responses sr WHERE active_survey_id = " + this.getId() + " AND sa.response_id = sr.response_id)");
            st.executeUpdate("DELETE FROM active_survey_answers WHERE response_id IN (SELECT response_id FROM active_survey_responses WHERE active_survey_id = " + this.getId() + ")");
            st.executeUpdate("DELETE FROM active_survey_responses WHERE active_survey_id = " + this.getId());
            st.executeUpdate("DELETE FROM active_survey_answer_avg WHERE question_id IN (SELECT question_id FROM active_survey_questions WHERE active_survey_id = " + this.getId() + ")");
            st.executeUpdate("DELETE FROM active_survey_items WHERE question_id IN (SELECT question_id FROM active_survey_questions WHERE active_survey_id = " + this.getId() + ")");
            st.executeUpdate("DELETE FROM active_survey_questions WHERE active_survey_id = " + this.getId());
            st.executeUpdate("DELETE FROM active_survey WHERE active_survey_id = " + this.getId());
            st.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.toString());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        try {
            db.setAutoCommit(false);
            resultCount = this.update(db, false);
            db.commit();
        }
        catch (Exception e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return resultCount;
    }

    protected int update(Connection db, boolean override) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            throw new SQLException("ActiveSurvey ID was not specified");
        }
        int i = 0;
        PreparedStatement pst = db.prepareStatement("UPDATE active_survey SET campaign_id = ?, name = ?, description = ?, intro = ?, outro = ?, itemlength = ?, " + DatabaseUtils.addQuotes(db, "type") + " = ?, " + "enabled = ?, " + "modified = CURRENT_TIMESTAMP, modifiedby = ? " + "WHERE active_survey_id = ? ");
        pst.setInt(++i, this.campaignId);
        pst.setString(++i, this.getName());
        pst.setString(++i, this.getDescription());
        pst.setString(++i, this.getIntro());
        pst.setString(++i, this.getOutro());
        pst.setInt(++i, this.getItemLength());
        pst.setInt(++i, this.getType());
        pst.setBoolean(++i, this.getEnabled());
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("active_survey_id"));
        this.campaignId = rs.getInt("campaign_id");
        this.name = rs.getString("name");
        this.description = rs.getString("description");
        this.intro = rs.getString("intro");
        this.outro = rs.getString("outro");
        this.itemLength = rs.getInt("itemlength");
        this.type = rs.getInt("type");
        this.enabled = rs.getBoolean("enabled");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
    }
}

