/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.communications.base.ActiveSurveyQuestionItem;
import org.aspcfs.modules.communications.base.SurveyAnswerItem;
import org.aspcfs.utils.web.PagedListInfo;

public class ActiveSurveyAnswerItemList
extends ArrayList {
    public static final String tableName = "active_survey_answer_items";
    public static final String uniqueField = "id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private int itemId = -1;
    private int contactId = -1;
    private int answerId = -1;
    protected PagedListInfo pagedListInfo = null;
    private ActiveSurveyQuestionItem item = null;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void setPagedListInfo(PagedListInfo pagedListInfo) {
        this.pagedListInfo = pagedListInfo;
    }

    public void setItemId(int itemId) {
        this.itemId = itemId;
    }

    public void setContactId(int contactId) {
        this.contactId = contactId;
    }

    public void setAnswerId(int answerId) {
        this.answerId = answerId;
    }

    public int getContactId() {
        return this.contactId;
    }

    public int getAnswerId() {
        return this.answerId;
    }

    public ActiveSurveyQuestionItem getItem() {
        return this.item;
    }

    public int getItemId() {
        return this.itemId;
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            SurveyAnswerItem thisItem = new SurveyAnswerItem();
            thisItem.buildDetailedRecord(rs);
            this.add(thisItem);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
        if (this.itemId != -1) {
            this.item = new ActiveSurveyQuestionItem(db, this.itemId);
        }
        for (SurveyAnswerItem thisItem : this) {
            thisItem.buildContactDetails(db);
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM active_survey_responses asr, active_survey_answers asa, active_survey_answer_items asi WHERE asr.response_id = asa.response_id AND asa.answer_id = asi.answer_id ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            if (this.pagedListInfo != null) {
                this.pagedListInfo.doManualOffset(db, pst);
            }
            if ((rs = pst.executeQuery()).next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                if (this.pagedListInfo != null) {
                    this.pagedListInfo.doManualOffset(db, pst);
                }
                if ((rs = pst.executeQuery()).next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("asr.entered", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY asr.entered ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("asi.item_id, asi.answer_id, asi.comments, asr.contact_id, asr.entered  FROM active_survey_responses asr, active_survey_answers asa, active_survey_answer_items asi WHERE asr.response_id = asa.response_id AND asa.answer_id = asi.answer_id ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        return rs;
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.itemId != -1) {
            sqlFilter.append("AND asi.item_id = ? ");
        }
        if (this.contactId != -1) {
            sqlFilter.append("AND asr.contact_id = ? ");
        }
        if (this.answerId != -1) {
            sqlFilter.append("AND asa.answer_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.itemId != -1) {
            pst.setInt(++i, this.itemId);
        }
        if (this.contactId != -1) {
            pst.setInt(++i, this.contactId);
        }
        if (this.answerId != -1) {
            pst.setInt(++i, this.answerId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public static int getItemCount(Connection db, int itemId) throws SQLException {
        int recordCount = 0;
        PreparedStatement pst = db.prepareStatement("SELECT count(*) AS thecount FROM active_survey_answer_items WHERE item_id = ? ");
        pst.setInt(1, itemId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            recordCount = rs.getInt("thecount");
        }
        rs.close();
        pst.close();
        return recordCount;
    }

    public boolean hasItem(int id) {
        for (SurveyAnswerItem thisItem : this) {
            if (thisItem.getId() != id) continue;
            return true;
        }
        return false;
    }
}

