/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.aspcfs.modules.communications.base.ActiveSurveyQuestionItem;
import org.aspcfs.modules.communications.base.ActiveSurveyQuestionItemList;
import org.aspcfs.modules.communications.base.SurveyAnswer;
import org.aspcfs.modules.communications.base.SurveyAnswerItem;
import org.aspcfs.modules.communications.base.SurveyAnswerList;
import org.aspcfs.modules.communications.base.SurveyQuestion;
import org.aspcfs.utils.DatabaseUtils;

public class ActiveSurveyQuestion {
    private int id = -1;
    private String description = null;
    private int activeSurveyId = -1;
    private int type = -1;
    private int position = 0;
    private double average = 0.0;
    private boolean required = false;
    private ActiveSurveyQuestionItemList itemList = null;
    private SurveyAnswerList answerList = null;
    private ArrayList responseTotals = new ArrayList();
    LinkedHashMap comments = null;
    private boolean recordItems = true;

    public boolean getRecordItems() {
        return this.recordItems;
    }

    public void setRecordItems(boolean tmp) {
        this.recordItems = tmp;
    }

    public void setRecordItems(String tmp) {
        this.recordItems = DatabaseUtils.parseBoolean(tmp);
    }

    public void setPosition(String tmp) {
        this.position = Integer.parseInt(tmp);
    }

    public void setAverage(String tmp) {
        this.average = Double.parseDouble(tmp);
    }

    public void setRequired(String tmp) {
        this.required = DatabaseUtils.parseBoolean(tmp);
    }

    public ActiveSurveyQuestion() {
    }

    public ActiveSurveyQuestion(SurveyQuestion question) {
        this.description = question.getDescription();
        this.type = question.getType();
        this.required = question.getRequired();
        this.position = question.getPosition();
        this.itemList = new ActiveSurveyQuestionItemList(question.getItemList());
    }

    public ActiveSurveyQuestion(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setComments(LinkedHashMap comments) {
        this.comments = comments;
    }

    public LinkedHashMap getComments() {
        return this.comments;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setActiveSurveyId(int tmp) {
        this.activeSurveyId = tmp;
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setItemList(ActiveSurveyQuestionItemList itemList) {
        this.itemList = itemList;
    }

    public void setAnswerList(SurveyAnswerList answerList) {
        this.answerList = answerList;
    }

    public SurveyAnswerList getAnswerList() {
        return this.answerList;
    }

    public ActiveSurveyQuestionItemList getItemList() {
        return this.itemList;
    }

    public boolean getRequired() {
        return this.required;
    }

    public int getActiveSurveyId() {
        return this.activeSurveyId;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        if (this.type == 1) {
            return "Open Ended";
        }
        if (this.type == 2) {
            return "Quantitative";
        }
        if (this.type == 3) {
            return "Quantitative with Comments";
        }
        if (this.type == 4) {
            return "Item List";
        }
        return "-";
    }

    public void setActiveSurveyId(String tmp) {
        this.activeSurveyId = Integer.parseInt(tmp);
    }

    public void setType(String tmp) {
        this.type = Integer.parseInt(tmp);
    }

    public ArrayList getResponseTotals() {
        return this.responseTotals;
    }

    public void setResponseTotals(ArrayList responseTotals) {
        this.responseTotals = responseTotals;
    }

    public double getAverage() {
        return this.average;
    }

    public void setAverage(double average) {
        this.average = average;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public String getAverageValue() {
        double value_2dp = (double)Math.round(this.average * 100.0) / 100.0;
        String toReturn = "" + value_2dp;
        if (toReturn.endsWith(".0")) {
            return toReturn.substring(0, toReturn.length() - 2);
        }
        return toReturn;
    }

    public HashMap getItemListResponse(SurveyAnswerList answerList) {
        HashMap<ActiveSurveyQuestionItem, Integer> itemListResponse = new HashMap<ActiveSurveyQuestionItem, Integer>();
        for (SurveyAnswer thisAnswer : answerList) {
            if (thisAnswer.getItemList() == null) continue;
            Iterator itemList = thisAnswer.getItemList().iterator();
            while (itemList.hasNext()) {
                ActiveSurveyQuestionItem thisItem = ((SurveyAnswerItem)itemList.next()).getItem();
                if (itemListResponse.containsKey(thisItem)) {
                    Integer count = (Integer)itemListResponse.get(thisItem);
                    itemListResponse.remove(thisItem);
                    itemListResponse.put(thisItem, new Integer(count + 1));
                    continue;
                }
                itemListResponse.put(thisItem, new Integer(1));
            }
        }
        return itemListResponse;
    }

    public void insert(Connection db) throws SQLException {
        this.insert(db, this.activeSurveyId);
    }

    public void insert(Connection db, int activeSurveyId) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "active_survey_q_question_id_seq");
        PreparedStatement pst = null;
        int i = 0;
        pst = db.prepareStatement("INSERT INTO active_survey_questions (" + (this.id > -1 ? "question_id, " : "") + "active_survey_id, " + DatabaseUtils.addQuotes(db, "type") + ", description, required, " + DatabaseUtils.addQuotes(db, "position") + ") " + "VALUES " + "(" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?) ");
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, activeSurveyId);
        pst.setInt(++i, this.getType());
        pst.setString(++i, this.description);
        pst.setBoolean(++i, this.required);
        pst.setInt(++i, this.getPosition());
        pst.execute();
        pst.close();
        this.setId(DatabaseUtils.getCurrVal(db, "active_survey_q_question_id_seq", this.id));
        if (this.recordItems && this.getType() == 4) {
            for (ActiveSurveyQuestionItem thisItem : this.getItemList()) {
                thisItem.insert(db, this.getId());
            }
        }
    }

    public void update(Connection db, int activeSurveyId, int surveyType) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE active_survey_questions SET active_survey_id = ?, " + DatabaseUtils.addQuotes(db, "type") + " = ?, description = ?, required = ?, " + DatabaseUtils.addQuotes(db, "position") + " = ? " + "WHERE question_id = ? ");
        int i = 0;
        pst.setInt(++i, activeSurveyId);
        pst.setInt(++i, surveyType);
        pst.setString(++i, this.description);
        pst.setBoolean(++i, this.required);
        pst.setInt(++i, this.position);
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
        if (this.getType() == 4 && ActiveSurveyQuestionItemList.delete(db, this.getId())) {
            for (ActiveSurveyQuestionItem thisItem : this.getItemList()) {
                thisItem.insert(db, this.getId());
            }
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("question_id");
        this.activeSurveyId = rs.getInt("active_survey_id");
        this.type = rs.getInt("type");
        this.description = rs.getString("description");
        this.required = rs.getBoolean("required");
        this.position = rs.getInt("position");
        this.average = rs.getDouble("average");
        this.responseTotals.add(0, new Integer(rs.getInt("total1")));
        this.responseTotals.add(1, new Integer(rs.getInt("total2")));
        this.responseTotals.add(2, new Integer(rs.getInt("total3")));
        this.responseTotals.add(3, new Integer(rs.getInt("total4")));
        this.responseTotals.add(4, new Integer(rs.getInt("total5")));
        this.responseTotals.add(5, new Integer(rs.getInt("total6")));
        this.responseTotals.add(6, new Integer(rs.getInt("total7")));
    }
}

