/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.modules.communications.base.Item;
import org.aspcfs.utils.DatabaseUtils;

public class ActiveSurveyQuestionItem {
    private int id = -1;
    private String description = null;
    private int questionId = -1;
    private int type = -1;
    private int totalResponse = 0;
    private boolean populateAvg = true;

    public boolean getPopulateAvg() {
        return this.populateAvg;
    }

    public void setPopulateAvg(boolean tmp) {
        this.populateAvg = tmp;
    }

    public void setPopulateAvg(String tmp) {
        this.populateAvg = DatabaseUtils.parseBoolean(tmp);
    }

    public ActiveSurveyQuestionItem() {
    }

    public ActiveSurveyQuestionItem(Item thisItem) {
        this.id = thisItem.getId();
        this.description = thisItem.getDescription();
        this.questionId = thisItem.getQuestionId();
        this.type = thisItem.getType();
    }

    public ActiveSurveyQuestionItem(Connection db, int itemId) throws SQLException {
        if (itemId == -1) {
            throw new SQLException("Item ID not specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT si.item_id, si.question_id, si." + DatabaseUtils.addQuotes(db, "type") + ", si.description " + "FROM active_survey_items si " + "WHERE item_id = ? ");
        int i = 0;
        pst.setInt(++i, itemId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
    }

    public ActiveSurveyQuestionItem(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setQuestionId(int tmp) {
        this.questionId = tmp;
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public void setTotalResponse(int totalResponse) {
        this.totalResponse = totalResponse;
    }

    public int getTotalResponse() {
        return this.totalResponse;
    }

    public int getQuestionId() {
        return this.questionId;
    }

    public int getType() {
        return this.type;
    }

    public void setQuestionId(String tmp) {
        this.questionId = Integer.parseInt(tmp);
    }

    public void setType(String tmp) {
        this.type = Integer.parseInt(tmp);
    }

    public void insert(Connection db) throws SQLException {
        this.insert(db, this.questionId);
    }

    public void insert(Connection db, int qid) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            int i = 0;
            this.id = DatabaseUtils.getNextSeq(db, "active_survey_items_item_id_seq");
            PreparedStatement pst = db.prepareStatement("INSERT INTO active_survey_items (" + (this.id > -1 ? "item_id, " : "") + "question_id, " + DatabaseUtils.addQuotes(db, "type") + ", description ) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?) ");
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, qid);
            pst.setInt(++i, this.getType());
            pst.setString(++i, this.getDescription());
            pst.execute();
            pst.close();
            this.setId(DatabaseUtils.getCurrVal(db, "active_survey_items_item_id_seq", this.id));
            if (this.populateAvg) {
                i = 0;
                int seqId = DatabaseUtils.getNextSeq(db, "active_survey_answer_avg_id_seq");
                pst = db.prepareStatement("INSERT INTO active_survey_answer_avg (" + (seqId > -1 ? "id, " : "") + "question_id, item_id, total ) " + "VALUES (" + (seqId > -1 ? "?, " : "") + "?, ?, ?) ");
                if (seqId > -1) {
                    pst.setInt(++i, seqId);
                }
                pst.setInt(++i, qid);
                pst.setInt(++i, this.getId());
                pst.setInt(++i, 0);
                pst.execute();
                pst.close();
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
    }

    public int update(Connection db, int qId) throws SQLException {
        int count = 0;
        PreparedStatement pst = db.prepareStatement("UPDATE active_survey_items SET description = ? WHERE question_id = ? ");
        int i = 0;
        pst.setString(++i, this.description);
        pst.setInt(++i, qId);
        count = pst.executeUpdate();
        pst.close();
        return count;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("item_id");
        this.questionId = rs.getInt("question_id");
        this.type = rs.getInt("type");
        this.description = rs.getString("description");
    }
}

