/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import org.aspcfs.modules.communications.base.ActiveSurveyQuestionItem;
import org.aspcfs.modules.communications.base.Item;
import org.aspcfs.modules.communications.base.ItemList;

public class ActiveSurveyQuestionItemList
extends ArrayList {
    public static final String tableName = "active_survey_items";
    public static final String uniqueField = "item_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private int questionId = -1;

    public ActiveSurveyQuestionItemList() {
    }

    public ActiveSurveyQuestionItemList(ItemList items) {
        if (items != null) {
            for (Item inactiveItem : items) {
                ActiveSurveyQuestionItem thisItem = new ActiveSurveyQuestionItem(inactiveItem);
                this.add(thisItem);
            }
        }
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public int getQuestionId() {
        return this.questionId;
    }

    public ActiveSurveyQuestionItem getObject(ResultSet rs) throws SQLException {
        ActiveSurveyQuestionItem thisItem = new ActiveSurveyQuestionItem(rs);
        return thisItem;
    }

    public void setQuestionId(int questionId) {
        this.questionId = questionId;
    }

    public void setQuestionId(String questionId) {
        this.questionId = Integer.parseInt(questionId);
    }

    public ActiveSurveyQuestionItem getItem(int itemId) {
        Iterator thisList = this.iterator();
        ActiveSurveyQuestionItem item = null;
        while (thisList.hasNext()) {
            ActiveSurveyQuestionItem thisItem = (ActiveSurveyQuestionItem)thisList.next();
            if (thisItem.getId() != itemId) continue;
            item = thisItem;
        }
        return item;
    }

    public boolean updateResponse(Connection db, int questionId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            pst = db.prepareStatement("SELECT item_id,total FROM active_survey_answer_avg WHERE question_id = ? ");
            int i = 0;
            pst.setInt(++i, questionId);
            rs = pst.executeQuery();
            while (rs.next()) {
                ActiveSurveyQuestionItem thisItem = this.getItem(rs.getInt(uniqueField));
                if (thisItem == null) continue;
                thisItem.setTotalResponse(rs.getInt("total"));
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.toString());
        }
        return true;
    }

    public static boolean delete(Connection db, int questionId) throws SQLException {
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = db.prepareStatement("DELETE FROM active_survey_items WHERE question_id = ?");
            pst.setInt(1, questionId);
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.toString());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            ActiveSurveyQuestionItem thisItem = this.getObject(rs);
            this.add(thisItem);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        String sql = "SELECT sq.* FROM active_survey_items sq " + (this.questionId > -1 ? "WHERE question_id = ? " : "");
        pst = db.prepareStatement(sql);
        int i = 0;
        if (this.questionId > -1) {
            pst.setInt(++i, this.questionId);
        }
        ResultSet rs = pst.executeQuery();
        return rs;
    }
}

