/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.communications.base.ActiveSurveyQuestion;
import org.aspcfs.modules.communications.base.ActiveSurveyQuestionItemList;
import org.aspcfs.modules.communications.base.SurveyAnswerList;
import org.aspcfs.modules.communications.base.SurveyQuestion;
import org.aspcfs.modules.communications.base.SurveyQuestionList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class ActiveSurveyQuestionList
extends ArrayList {
    public static final String tableName = "action_item";
    public static final String uniqueField = "item_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private int id = -1;
    private int activeSurveyId = -1;
    protected PagedListInfo pagedListInfo = null;
    private boolean buildResults = false;

    public ActiveSurveyQuestionList() {
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public ActiveSurveyQuestionList(SurveyQuestionList inactiveQuestions) {
        for (SurveyQuestion inactiveQuestion : inactiveQuestions) {
            ActiveSurveyQuestion thisQuestion = new ActiveSurveyQuestion(inactiveQuestion);
            thisQuestion.setActiveSurveyId(this.activeSurveyId);
            this.add(thisQuestion);
        }
    }

    public ActiveSurveyQuestion getObject(ResultSet rs) throws SQLException {
        ActiveSurveyQuestion thisQuestion = new ActiveSurveyQuestion(rs);
        return thisQuestion;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setId(String id) {
        this.id = Integer.parseInt(id);
    }

    public void setPagedListInfo(PagedListInfo pagedListInfo) {
        this.pagedListInfo = pagedListInfo;
    }

    public void setBuildResults(boolean buildResults) {
        this.buildResults = buildResults;
    }

    public boolean getBuildResults() {
        return this.buildResults;
    }

    public int getActiveSurveyId() {
        return this.activeSurveyId;
    }

    public void setActiveSurveyId(int surveyId) {
        this.activeSurveyId = surveyId;
    }

    public void setActiveSurveyId(String surveyId) {
        this.activeSurveyId = Integer.parseInt(surveyId);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM active_survey_questions sq WHERE sq.active_survey_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("sq.position", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY sq." + DatabaseUtils.addQuotes(db, "position") + " ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("sq.* FROM active_survey_questions sq WHERE sq.active_survey_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            ActiveSurveyQuestion thisQuestion = this.getObject(rs);
            this.add(thisQuestion);
            if (System.getProperty("DEBUG") == null) continue;
            System.out.println("ActiveSurveyQuestionList -- > Added Question " + thisQuestion.getDescription());
        }
        rs.close();
        pst.close();
        for (ActiveSurveyQuestion thisQuestion : this) {
            int type = thisQuestion.getType();
            if (type == 4) {
                ActiveSurveyQuestionItemList itemList = new ActiveSurveyQuestionItemList();
                itemList.setQuestionId(thisQuestion.getId());
                itemList.buildList(db);
                thisQuestion.setItemList(itemList);
                continue;
            }
            if (!this.buildResults || type != 3 && type != 1) continue;
            SurveyAnswerList answerList = new SurveyAnswerList();
            answerList.setQuestionId(thisQuestion.getId());
            answerList.setHasComments(1);
            answerList.setItemsPerPage(5);
            answerList.setLastAnswers(true);
            answerList.buildList(db);
            thisQuestion.setAnswerList(answerList);
        }
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.activeSurveyId != -1) {
            sqlFilter.append("AND sq.active_survey_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.activeSurveyId != -1) {
            pst.setInt(++i, this.activeSurveyId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public void buildResponse(Connection db, int contactId, int responseId) throws SQLException {
        for (ActiveSurveyQuestion thisQuestion : this) {
            SurveyAnswerList answers = new SurveyAnswerList();
            answers.setQuestionId(thisQuestion.getId());
            answers.setContactId(contactId);
            answers.setResponseId(responseId);
            answers.buildList(db);
            thisQuestion.setAnswerList(answers);
        }
    }
}

