/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import com.darkhorseventures.framework.beans.GenericBean;
import com.zeroio.iteam.base.FileItemList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.actionlist.base.ActionItemLog;
import org.aspcfs.modules.actionplans.base.ActionStepList;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.base.Constants;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.communications.base.ActiveSurvey;
import org.aspcfs.modules.communications.base.CampaignRun;
import org.aspcfs.modules.communications.base.CampaignUserGroupMap;
import org.aspcfs.modules.communications.base.CampaignUserGroupMapList;
import org.aspcfs.modules.communications.base.Message;
import org.aspcfs.modules.communications.base.MessageAttachmentList;
import org.aspcfs.modules.communications.base.Recipient;
import org.aspcfs.modules.communications.base.SearchCriteriaList;
import org.aspcfs.modules.communications.base.SearchCriteriaListList;
import org.aspcfs.modules.communications.base.Survey;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactHistory;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.PasswordHash;
import org.aspcfs.utils.Template;

public class Campaign
extends GenericBean {
    public static final int IDLE = 1;
    public static final int QUEUE = 2;
    public static final int STARTED = 3;
    public static final int FINISHED = 4;
    public static final int ERROR = 5;
    public static final int CANCELED = 6;
    public static final String IDLE_TEXT = "Idle";
    public static final String QUEUE_TEXT = "In Queue";
    public static final String STARTED_TEXT = "Sending Messages";
    public static final String FINISHED_TEXT = "Messages Sent";
    public static final String ERROR_TEXT = "Error in Campaign";
    public static final String CANCELED_TEXT = "Canceled";
    public static final int GENERAL = 1;
    public static final int INSTANT = 2;
    private int id = -1;
    private String name = null;
    private String description = null;
    private int messageId = -1;
    private int groupId = -1;
    private int runId = -1;
    private int statusId = -1;
    private int owner = -1;
    private int modifiedBy = -1;
    private int enteredBy = -1;
    private Timestamp activeDate = null;
    private Timestamp inactiveDate = null;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private boolean enabled = true;
    private String status = null;
    private boolean active = false;
    private String replyTo = null;
    private String subject = null;
    private String message = null;
    private int sendMethodId = -1;
    private int type = 1;
    private String activeDateTimeZone = null;
    private Timestamp trashedDate = null;
    private boolean partComplete = false;
    private boolean buildGroupMaps = false;
    private CampaignUserGroupMapList userGroupMaps = new CampaignUserGroupMapList();
    private int files = 0;
    private String deliveryName = null;
    private int deliveryType = -1;
    private ContactList contactList = null;
    private int recipientCount = -1;
    private int responseCount = -1;
    private int sentCount = -1;
    private String messageName = "";
    private int surveyId = -1;
    private String serverName = "";
    private String groupList = "";
    private int groupCount = -1;
    private int approvedBy = -1;
    private Timestamp approvalDate = null;
    private LinkedHashMap groups = null;
    private MessageAttachmentList messageAttachments = new MessageAttachmentList();
    private Timestamp lastResponse = null;
    private String messageSubject = null;
    private boolean hasAddressRequest = false;
    private int addressSurveyId = -1;
    private int addressResponseCount = -1;
    private Timestamp lastAddressResponse = null;
    private boolean hasSurvey = false;
    protected String bcc = null;
    protected String cc = null;

    public Campaign() {
    }

    public Campaign(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setActiveDateTimeZone(String tmp) {
        this.activeDateTimeZone = tmp;
    }

    public String getActiveDateTimeZone() {
        return this.activeDateTimeZone;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public int getSurveyId() {
        return this.surveyId;
    }

    public int getActiveSurveyId() {
        if (this.active) {
            return this.surveyId;
        }
        return -1;
    }

    public void setSurveyId(int surveyId) {
        this.surveyId = surveyId;
    }

    public void setSurveyId(String surveyId) {
        this.surveyId = Integer.parseInt(surveyId);
    }

    public void setGroups(LinkedHashMap groups) {
        this.groups = groups;
    }

    public void setResponseCount(int responseCount) {
        this.responseCount = responseCount;
    }

    public void setLastResponse(Timestamp lastResponse) {
        this.lastResponse = lastResponse;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setType(String type) {
        this.type = Integer.parseInt(type);
    }

    public void setMessageSubject(String tmp) {
        this.messageSubject = tmp;
    }

    public void setHasAddressRequest(boolean tmp) {
        this.hasAddressRequest = tmp;
    }

    public void setHasAddressRequest(String tmp) {
        this.hasAddressRequest = DatabaseUtils.parseBoolean(tmp);
    }

    public void setAddressSurveyId(int tmp) {
        this.addressSurveyId = tmp;
    }

    public void setAddressSurveyId(String tmp) {
        this.addressSurveyId = Integer.parseInt(tmp);
    }

    public void setAddressResponseCount(int tmp) {
        this.addressResponseCount = tmp;
    }

    public void setAddressResponseCount(String tmp) {
        this.addressResponseCount = Integer.parseInt(tmp);
    }

    public void setLastAddressResponse(Timestamp tmp) {
        this.lastAddressResponse = tmp;
    }

    public void setLastAddressResponse(String tmp) {
        this.lastAddressResponse = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setHasSurvey(boolean tmp) {
        this.hasSurvey = tmp;
    }

    public void setHasSurvey(String tmp) {
        this.hasSurvey = DatabaseUtils.parseBoolean(tmp);
    }

    public String getMessageSubject() {
        return this.messageSubject;
    }

    public boolean getHasAddressRequest() {
        return this.hasAddressRequest;
    }

    public int getAddressSurveyId() {
        return this.addressSurveyId;
    }

    public int getAddressResponseCount() {
        return this.addressResponseCount;
    }

    public Timestamp getLastAddressResponse() {
        return this.lastAddressResponse;
    }

    public boolean getHasSurvey() {
        return this.hasSurvey;
    }

    public int getType() {
        return this.type;
    }

    public Timestamp getLastResponse() {
        return this.lastResponse;
    }

    public String getLastResponseString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.lastResponse);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getLastAddressResponseString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.lastAddressResponse);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public int getResponseCount() {
        return this.responseCount;
    }

    public LinkedHashMap getGroups() {
        return this.groups;
    }

    public String getBcc() {
        return this.bcc;
    }

    public void setBcc(String tmp) {
        this.bcc = tmp;
    }

    public String getCc() {
        return this.cc;
    }

    public void setCc(String tmp) {
        this.cc = tmp;
    }

    public MessageAttachmentList getMessageAttachments() {
        return this.messageAttachments;
    }

    public void setMessageAttachments(MessageAttachmentList messageAttachments) {
        this.messageAttachments = messageAttachments;
    }

    public Campaign(Connection db, String campaignId) throws SQLException {
        this.queryRecord(db, Integer.parseInt(campaignId));
    }

    public Campaign(Connection db, int campaignId) throws SQLException {
        this.queryRecord(db, campaignId);
    }

    public void queryRecord(Connection db, int campaignId) throws SQLException {
        if (campaignId <= 0) {
            throw new SQLException("Invalid ID specified.");
        }
        PreparedStatement pst = null;
        ResultSet rs = null;
        String sql = "SELECT c.*, msg.name AS messageName, msg.subject AS messageSubject, dt.code AS deliveryType, dt.description AS deliveryTypeName FROM campaign c LEFT JOIN " + DatabaseUtils.addQuotes(db, "message") + " msg ON (c.message_id = msg.id) " + "LEFT JOIN lookup_delivery_options dt ON (c.send_method_id = dt.code) " + "WHERE c.campaign_id = ? ";
        pst = db.prepareStatement(sql);
        pst.setInt(1, campaignId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
        this.buildRecipientCount(db);
        this.buildResponseCount(db);
        this.buildAddressResponseCount(db);
        this.buildLastResponse(db);
        this.buildLastAddressResponse(db);
        this.buildSurveyId(db);
        this.buildHasAddressRequest(db);
        this.buildHasSurvey(db);
        this.setGroupList(db);
        this.buildFileCount(db);
        this.buildGroups(db);
        this.buildUserGroupMaps(db);
        this.buildMessageAttachments(db);
    }

    public void buildUserGroupMaps(Connection db) throws SQLException {
        if (this.getBuildGroupMaps()) {
            if (this.userGroupMaps == null) {
                this.userGroupMaps = new CampaignUserGroupMapList();
            }
            this.userGroupMaps.setCampaignId(this.getId());
            this.userGroupMaps.buildList(db);
        }
    }

    public void setContactList(ContactList contactList) {
        this.contactList = contactList;
    }

    public void setRecipientCount(int recipientCount) {
        this.recipientCount = recipientCount;
    }

    public void setRecipientCount(String recipientCount) {
        this.recipientCount = Integer.parseInt(recipientCount);
    }

    public void setSentCount(int tmp) {
        this.sentCount = tmp;
    }

    public void setMessageName(String messageName) {
        this.messageName = messageName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setGroupList(String groupList) {
        this.groupList = groupList;
    }

    public int getApprovedBy() {
        return this.approvedBy;
    }

    public void setApprovedBy(int approvedBy) {
        this.approvedBy = approvedBy;
    }

    public void setApprovedBy(String approvedBy) {
        this.approvedBy = Integer.parseInt(approvedBy);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.setId(Integer.parseInt(tmp));
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setActive(String tmp) {
        this.active = DatabaseUtils.parseBoolean(tmp);
    }

    public void setReplyTo(String tmp) {
        this.replyTo = tmp;
    }

    public void setSubject(String tmp) {
        this.subject = tmp;
    }

    public void setMessage(String tmp) {
        this.message = tmp;
    }

    public void setSendMethodId(int tmp) {
        this.sendMethodId = tmp;
    }

    public void setSendMethodId(String tmp) {
        this.sendMethodId = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setMessageId(int tmp) {
        this.messageId = tmp;
    }

    public void setMessageId(String tmp) {
        this.messageId = Integer.parseInt(tmp);
    }

    public void setGroupId(int tmp) {
        this.groupId = tmp;
    }

    public void setGroupId(String tmp) {
        this.groupId = Integer.parseInt(tmp);
    }

    public void setRunId(int tmp) {
        this.runId = tmp;
    }

    public void setRunId(String tmp) {
        this.runId = Integer.parseInt(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
        switch (this.statusId) {
            case 1: {
                this.status = IDLE_TEXT;
                break;
            }
            case 2: {
                this.status = QUEUE_TEXT;
                break;
            }
            case 3: {
                this.status = STARTED_TEXT;
                break;
            }
            case 5: {
                this.status = "Unspecified error";
                break;
            }
            case 4: {
                this.status = FINISHED_TEXT;
                break;
            }
        }
    }

    public void setStatusId(String tmp) {
        this.setStatusId(Integer.parseInt(tmp));
    }

    public void setOwner(int tmp) {
        this.owner = tmp;
    }

    public void setOwner(String tmp) {
        this.owner = Integer.parseInt(tmp);
    }

    public void setActiveDate(Timestamp tmp) {
        this.activeDate = tmp;
    }

    public void setActiveDate(String tmp) {
        this.activeDate = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setInactiveDate(Timestamp tmp) {
        this.inactiveDate = tmp;
    }

    public void setInactiveDate(String tmp) {
        this.inactiveDate = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public void setModified(String tmp) {
        this.modified = DateUtils.parseTimestampString(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setDeliveryName(String deliveryName) {
        this.deliveryName = deliveryName;
    }

    public void setDeliveryType(int tmp) {
        this.deliveryType = tmp;
    }

    public void setDeliveryType(String tmp) {
        this.deliveryType = Integer.parseInt(tmp);
    }

    public void setGroups(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer();
        int selectCount = 0;
        String item = null;
        while ((item = request.getParameter("select" + ++selectCount)) != null) {
            if (!DatabaseUtils.parseBoolean(request.getParameter("select" + selectCount + "check"))) continue;
            if (sb.length() > 0) {
                sb.append("*");
            }
            sb.append(item);
        }
        this.groupList = sb.toString();
    }

    public void setGroupList(Connection db) throws SQLException {
        this.groupCount = 0;
        StringBuffer groups = new StringBuffer();
        boolean b = false;
        PreparedStatement pst = db.prepareStatement("SELECT group_id FROM campaign_list_groups WHERE campaign_id = ? ");
        pst.setInt(1, this.getId());
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            ++this.groupCount;
            if (b) {
                groups.append(", ");
            } else {
                b = true;
            }
            groups.append(rs.getInt("group_id"));
        }
        this.setGroupList(groups.toString());
        rs.close();
        pst.close();
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getSendMethodId() {
        return this.sendMethodId;
    }

    public String getDeliveryName() {
        return this.deliveryName;
    }

    public int getDeliveryType() {
        return this.deliveryType;
    }

    public int getRecipientCount() {
        return this.recipientCount;
    }

    public int getSentCount() {
        return this.sentCount;
    }

    public ContactList getContactList() {
        if (this.contactList == null) {
            this.contactList = new ContactList();
        }
        return this.contactList;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public boolean getActive() {
        return this.active;
    }

    public String getActiveYesNo() {
        if (this.active) {
            return "Yes";
        }
        return "No";
    }

    public String getActive(String tmp) {
        if (this.active) {
            return tmp;
        }
        return "";
    }

    public Timestamp getActiveDate() {
        return this.activeDate;
    }

    public String getActiveDateString() {
        String tmp = "";
        try {
            return DateFormat.getDateInstance(3).format(this.activeDate);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getStatus() {
        return this.status;
    }

    public String getGroupList() {
        return this.groupList;
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSubject() {
        return this.subject;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public int getRunId() {
        return this.runId;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public int getOwner() {
        return this.owner;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public String getModifiedString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public String getEnteredString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean getPartComplete() {
        return this.partComplete;
    }

    public void setPartComplete(boolean tmp) {
        this.partComplete = tmp;
    }

    public void setPartComplete(String tmp) {
        this.partComplete = DatabaseUtils.parseBoolean(tmp);
    }

    public CampaignUserGroupMapList getUserGroupMaps() {
        return this.userGroupMaps;
    }

    public void setUserGroupMaps(CampaignUserGroupMapList tmp) {
        this.userGroupMaps = tmp;
    }

    public boolean getBuildGroupMaps() {
        return this.buildGroupMaps;
    }

    public void setBuildGroupMaps(boolean tmp) {
        this.buildGroupMaps = tmp;
    }

    public void setBuildGroupMaps(String tmp) {
        this.buildGroupMaps = DatabaseUtils.parseBoolean(tmp);
    }

    public String getRange() {
        StringTokenizer strt = new StringTokenizer(this.getGroupList(), "*");
        String range = "";
        boolean b = true;
        while (strt.hasMoreTokens()) {
            String tmpString = strt.nextToken();
            if (b) {
                range = range + tmpString;
                b = false;
                continue;
            }
            range = range + ", " + tmpString;
        }
        return range;
    }

    public String getMessageChecked(int tmp) {
        if (this.messageId == tmp) {
            return "checked";
        }
        return "";
    }

    public String getGroupChecked(int tmp) {
        if (this.groupList != null || this.groupList.length() > 0) {
            StringTokenizer st = new StringTokenizer(this.groupList, "*");
            while (st.hasMoreTokens()) {
                String tmpString = st.nextToken();
                if (!tmpString.equals(String.valueOf(tmp))) continue;
                return "checked";
            }
        }
        return "";
    }

    public boolean isReadyToActivate() {
        return this.hasGroups() && this.hasMessage() && this.hasDetails();
    }

    public boolean hasGroups() {
        return this.groupList != null && !this.groupList.equals("");
    }

    public boolean hasMessage() {
        return this.messageId > 0;
    }

    public boolean hasSurvey() {
        return this.surveyId > 0;
    }

    public boolean hasDetails() {
        return this.activeDate != null;
    }

    public boolean hasRun() {
        return this.statusId == 4;
    }

    public boolean hasFiles() {
        return this.files > 0;
    }

    public void buildRecipientCount(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT count(id) FROM scheduled_recipient sr WHERE campaign_id = ? ");
        pst.setInt(1, this.id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.setRecipientCount(rs.getInt(1));
        }
        rs.close();
        pst.close();
    }

    public void buildResponseCount(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT count(sr.contact_id) AS reccount FROM active_survey_responses sr, active_survey sa WHERE campaign_id = ? AND (sr.active_survey_id = sa.active_survey_id) AND sa." + DatabaseUtils.addQuotes(db, "type") + " = ? ");
        pst.setInt(1, this.id);
        pst.setInt(2, 1);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.setResponseCount(rs.getInt("reccount"));
        }
        rs.close();
        pst.close();
    }

    public void buildAddressResponseCount(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT count(sr.contact_id) AS reccount FROM active_survey_responses sr, active_survey sa WHERE campaign_id = ? AND (sr.active_survey_id = sa.active_survey_id) AND sa." + DatabaseUtils.addQuotes(db, "type") + " = ? ");
        pst.setInt(1, this.id);
        pst.setInt(2, 2);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.setAddressResponseCount(rs.getInt("reccount"));
        }
        rs.close();
        pst.close();
    }

    public void buildLastResponse(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT max(sr.entered) AS lastresponse FROM active_survey_responses sr, active_survey sa WHERE campaign_id = ? AND (sr.active_survey_id = sa.active_survey_id) AND sa." + DatabaseUtils.addQuotes(db, "type") + " = ? ");
        pst.setInt(1, this.id);
        pst.setInt(2, 1);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.setLastResponse(rs.getTimestamp("lastresponse"));
        }
        rs.close();
        pst.close();
    }

    public void buildLastAddressResponse(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT max(sr.entered) AS lastresponse FROM active_survey_responses sr, active_survey sa WHERE campaign_id = ? AND (sr.active_survey_id = sa.active_survey_id) AND sa." + DatabaseUtils.addQuotes(db, "type") + " = ? ");
        pst.setInt(1, this.id);
        pst.setInt(2, 2);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.setLastAddressResponse(rs.getTimestamp("lastresponse"));
        }
        rs.close();
        pst.close();
    }

    public void buildFileCount(Connection db) throws SQLException {
        this.files = FileItemList.retrieveRecordCount((Connection)db, (int)17, (int)this.id);
    }

    public void buildGroups(Connection db) throws SQLException {
        ArrayList criteriaList = null;
        this.groups = new LinkedHashMap();
        PreparedStatement pst = db.prepareStatement("SELECT groupname, groupcriteria FROM active_campaign_groups WHERE campaign_id = ? ");
        pst.setInt(1, this.id);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            String groupName = rs.getString("groupName");
            if (this.groups.containsKey(groupName)) {
                criteriaList = (ArrayList)this.groups.get(groupName);
            } else {
                criteriaList = new ArrayList();
                this.groups.put(groupName, criteriaList);
            }
            criteriaList.add(rs.getString("groupcriteria"));
        }
        rs.close();
        pst.close();
    }

    public void buildSurveyId(Connection db) throws SQLException {
        this.surveyId = this.active ? ActiveSurvey.getId(db, this.id, 1) : Survey.getId(db, this.id, 1);
    }

    public void buildHasAddressRequest(Connection db) throws SQLException {
        if (Survey.getId(db, this.id, 2) != -1) {
            this.setHasAddressRequest(true);
        } else if (ActiveSurvey.getId(db, this.id, 2) != -1) {
            this.setHasAddressRequest(true);
        } else {
            this.setHasAddressRequest(false);
        }
    }

    public void buildHasSurvey(Connection db) throws SQLException {
        if (Survey.getId(db, this.id, 1) != -1) {
            this.setHasSurvey(true);
        } else if (ActiveSurvey.getId(db, this.id, 1) != -1) {
            this.setHasSurvey(true);
        } else {
            this.setHasSurvey(false);
        }
    }

    public void insertContactList(Connection db) throws SQLException {
        for (Contact thisContact : this.contactList) {
            Recipient thisRecipient = new Recipient();
            thisRecipient.setCampaignId(this.getId());
            thisRecipient.setContactId(thisContact.getId());
            thisRecipient.insert(db);
        }
    }

    public void insertRecipients(Connection db, int userId, String userRangeId) throws SQLException {
        ContactList dummyList = this.getContactList();
        boolean addContacts = dummyList.size() == 0;
        SearchCriteriaListList groupData = new SearchCriteriaListList();
        groupData.setCampaignId(this.id);
        groupData.setBuildCriteria(true);
        groupData.buildList(db);
        for (SearchCriteriaList thisGroup : groupData) {
            ContactList groupContacts = new ContactList();
            groupContacts.setScl(thisGroup, userId, userRangeId);
            groupContacts.setBuildDetails(false);
            groupContacts.setBuildTypes(false);
            groupContacts.setCheckExcludedFromCampaign(this.getId());
            AccessTypeList gcAccessTypes = new AccessTypeList();
            gcAccessTypes.setLinkModuleId(626030330);
            gcAccessTypes.buildList(db);
            groupContacts.setGeneralContactAccessTypes(gcAccessTypes);
            groupContacts.buildList(db);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Campaign-> GroupContacts has " + groupContacts.size() + " items");
            }
            for (Contact thisContact : groupContacts) {
                if (thisContact.excludedFromCampaign()) continue;
                Recipient thisRecipient = new Recipient();
                thisRecipient.setCampaignId(this.getId());
                thisRecipient.setContactId(thisContact.getId());
                thisRecipient.insert(db);
                if (!addContacts) continue;
                this.contactList.add(thisContact);
            }
        }
    }

    public void setContacts(Connection db, int userId, String userRangeId) throws SQLException {
        boolean addContacts;
        ContactList dummyList = this.getContactList();
        boolean bl = addContacts = dummyList.size() == 0;
        if (!addContacts) {
            return;
        }
        SearchCriteriaListList groupData = new SearchCriteriaListList();
        groupData.setCampaignId(this.id);
        groupData.setBuildCriteria(true);
        groupData.buildList(db);
        for (SearchCriteriaList thisGroup : groupData) {
            ContactList groupContacts = new ContactList();
            groupContacts.setScl(thisGroup, userId, userRangeId);
            groupContacts.setBuildDetails(false);
            groupContacts.setBuildTypes(false);
            groupContacts.setCheckExcludedFromCampaign(this.getId());
            AccessTypeList gcAccessTypes = new AccessTypeList();
            gcAccessTypes.setLinkModuleId(626030330);
            gcAccessTypes.buildList(db);
            groupContacts.setGeneralContactAccessTypes(gcAccessTypes);
            groupContacts.buildList(db);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Campaign-> GroupContacts has " + groupContacts.size() + " items");
            }
            for (Contact thisContact : groupContacts) {
                if (thisContact.excludedFromCampaign()) continue;
                this.contactList.add(thisContact);
            }
        }
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "campaign_campaign_id_seq");
            sql.append("INSERT INTO campaign (enteredby, modifiedby, name, message_id, reply_addr, subject, " + DatabaseUtils.addQuotes(db, "message") + ", send_method_id, " + "inactive_date, approval_date, " + DatabaseUtils.addQuotes(db, "type") + ", ");
            if (this.id > -1) {
                sql.append("campaign_id, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            sql.append("approvedby ) ");
            sql.append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            sql.append("?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.setString(++i, this.getName());
            pst.setInt(++i, this.getMessageId());
            pst.setString(++i, this.replyTo);
            pst.setString(++i, this.subject);
            pst.setString(++i, this.message);
            pst.setInt(++i, this.sendMethodId);
            pst.setTimestamp(++i, this.inactiveDate);
            pst.setTimestamp(++i, this.approvalDate);
            pst.setInt(++i, this.type);
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            DatabaseUtils.setInt(pst, ++i, this.getApprovedBy());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "campaign_campaign_id_seq", this.id);
            this.update(db, true);
            if (this.getGroupList() != null && !this.getGroupList().equals("")) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Campaign-> GroupList: " + this.getGroupList());
                }
                StringBuffer groupSql = new StringBuffer();
                StringTokenizer strt = new StringTokenizer(this.getGroupList(), "*");
                PreparedStatement pstx = null;
                while (strt.hasMoreTokens()) {
                    String tmpString = strt.nextToken();
                    groupSql.append("INSERT INTO campaign_list_groups (campaign_id, group_id ) VALUES (?, ?) ");
                    int j = 0;
                    pstx = db.prepareStatement(groupSql.toString());
                    pstx.setInt(++j, this.getId());
                    pstx.setInt(++j, Integer.parseInt(tmpString));
                    pstx.execute();
                    pstx.close();
                }
            }
            this.parseUserGroups(db);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public boolean parseUserGroups(Connection db) throws SQLException {
        CampaignUserGroupMapList oldList = new CampaignUserGroupMapList();
        oldList.setCampaignId(this.getId());
        oldList.buildList(db);
        if (oldList.size() > 0) {
            HashMap oldMap = oldList.createMapOfElements();
            HashMap mapOfElements = oldList.createMapOfElements();
            Iterator<Object> iter = null;
            if (this.userGroupMaps != null) {
                iter = this.userGroupMaps.iterator();
                while (iter.hasNext()) {
                    CampaignUserGroupMap groupMap = (CampaignUserGroupMap)((Object)iter.next());
                    if (mapOfElements.get(new Integer(groupMap.getUserGroupId())) == null) continue;
                    iter.remove();
                    Object tmp = oldMap.remove(new Integer(groupMap.getUserGroupId()));
                }
            }
            iter = oldMap.keySet().iterator();
            while (iter.hasNext()) {
                CampaignUserGroupMap toRemove = (CampaignUserGroupMap)((Object)oldMap.get((Integer)iter.next()));
                toRemove.delete(db);
            }
        }
        if (this.userGroupMaps != null) {
            this.userGroupMaps.setCampaignId(this.getId());
            this.userGroupMaps.insert(db);
        }
        this.userGroupMaps = new CampaignUserGroupMapList();
        this.userGroupMaps.setCampaignId(this.getId());
        this.userGroupMaps.buildList(db);
        return true;
    }

    public boolean insertGroups(Connection db) throws SQLException {
        try {
            db.setAutoCommit(false);
            this.deleteAllGroups(db);
            if (this.getGroupList() != null && !this.getGroupList().equals("")) {
                StringTokenizer strt = new StringTokenizer(this.getGroupList(), "*");
                while (strt.hasMoreTokens()) {
                    String tmpString = strt.nextToken();
                    PreparedStatement pstx = null;
                    String groupSql = "INSERT INTO campaign_list_groups (campaign_id, group_id ) VALUES (?, ?) ";
                    int j = 0;
                    pstx = db.prepareStatement(groupSql);
                    pstx.setInt(++j, this.getId());
                    pstx.setInt(++j, Integer.parseInt(tmpString));
                    pstx.execute();
                    pstx.close();
                }
            }
            Statement st = db.createStatement();
            st.executeUpdate("UPDATE campaign SET modified = CURRENT_TIMESTAMP WHERE campaign_id = " + this.id);
            st.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public boolean deleteAllGroups(Connection db) throws SQLException {
        PreparedStatement pstx = null;
        String groupSql = "DELETE FROM campaign_list_groups WHERE campaign_id = ? ";
        int j = 0;
        pstx = db.prepareStatement(groupSql);
        pstx.setInt(++j, this.getId());
        pstx.execute();
        pstx.close();
        return true;
    }

    public boolean deleteGroups(Connection db) throws SQLException {
        try {
            db.setAutoCommit(false);
            if (this.getGroupList() != null && !this.getGroupList().equals("")) {
                StringTokenizer strt = new StringTokenizer(this.getGroupList(), "*");
                while (strt.hasMoreTokens()) {
                    String tmpString = strt.nextToken();
                    PreparedStatement pstx = null;
                    StringBuffer groupSql = new StringBuffer();
                    groupSql.append("DELETE FROM campaign_list_groups WHERE campaign_id = ? AND group_id = ? ");
                    int j = 0;
                    pstx = db.prepareStatement(groupSql.toString());
                    pstx.setInt(++j, this.getId());
                    pstx.setInt(++j, Integer.parseInt(tmpString));
                    pstx.execute();
                    pstx.close();
                }
                Statement st = db.createStatement();
                st.executeUpdate("UPDATE campaign SET modified = CURRENT_TIMESTAMP WHERE campaign_id = " + this.id);
                st.close();
            }
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        try {
            db.setAutoCommit(false);
            resultCount = this.update(db, false);
            db.commit();
        }
        catch (Exception e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return resultCount;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        int addressSurveyId;
        DependencyList dependencyList = new DependencyList();
        int activeSurveyId = ActiveSurvey.getId(db, this.id, 1);
        if (activeSurveyId > -1) {
            Dependency dependency = new Dependency();
            dependency.setName("activeSurvey");
            dependency.setCount(1);
            dependency.setCanDelete(false);
            dependencyList.add(dependency);
        }
        if ((addressSurveyId = ActiveSurvey.getId(db, this.id, 2)) > -1) {
            Dependency dependency = new Dependency();
            dependency.setName("addressRequest");
            dependency.setCount(1);
            dependency.setCanDelete(false);
            dependencyList.add(dependency);
        }
        return dependencyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Connection db, String baseFilePath) throws SQLException {
        PreparedStatement pst = null;
        SQLException message = null;
        boolean commit = db.getAutoCommit();
        try {
            int addSurveyId;
            if (commit) {
                db.setAutoCommit(false);
            }
            ActionItemLog.deleteLink(db, this.getId(), 51320031);
            this.setBuildGroupMaps(true);
            this.buildUserGroupMaps(db);
            this.getUserGroupMaps().delete(db);
            pst = db.prepareStatement("DELETE FROM campaign_list_groups WHERE campaign_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM scheduled_recipient WHERE campaign_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM campaign_run WHERE campaign_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM excluded_recipient WHERE campaign_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM campaign_survey_link WHERE campaign_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            int activeSurveyId = ActiveSurvey.getId(db, this.id, 1);
            if (activeSurveyId > -1) {
                ActiveSurvey thisSurvey = new ActiveSurvey(db, activeSurveyId);
                thisSurvey.delete(db);
            }
            if ((addSurveyId = ActiveSurvey.getId(db, this.id, 2)) > -1) {
                ActiveSurvey thisSurvey = new ActiveSurvey(db, addSurveyId);
                thisSurvey.delete(db);
            }
            FileItemList fileList = new FileItemList();
            fileList.setLinkModuleId(16);
            fileList.setLinkItemId(this.id);
            fileList.buildList(db);
            fileList.delete(db, baseFilePath + "communications" + Constants.fs);
            fileList = null;
            FileItemList docList = new FileItemList();
            docList.setLinkModuleId(17);
            docList.setLinkItemId(this.id);
            docList.buildList(db);
            docList.delete(db, baseFilePath + "campaign" + Constants.fs);
            docList = null;
            ActionStepList stepList = new ActionStepList();
            stepList.setCampaignId(this.getId());
            stepList.buildList(db);
            stepList.resetCampaignInformation(db);
            ContactHistory.deleteObject(db, 15, this.getId());
            pst = db.prepareStatement("DELETE FROM active_campaign_groups WHERE campaign_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            MessageAttachmentList attachmentList = new MessageAttachmentList();
            attachmentList.delete(db, 508200600, this.getId());
            pst = db.prepareStatement("DELETE FROM campaign WHERE campaign_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            message = e;
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        if (message != null) {
            throw new SQLException(message.getMessage());
        }
        return true;
    }

    public int cancel(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Campaign ID was not specified");
        }
        boolean commit = true;
        int resultCount = 0;
        int activeRecipients = 0;
        Statement pst = null;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            pst = db.prepareStatement("SELECT count(*) AS activecount FROM scheduled_recipient WHERE campaign_id = ? AND sent_date IS NOT NULL ");
            pst.setInt(1, this.getId());
            ResultSet rs = pst.executeQuery();
            if (rs.next()) {
                activeRecipients = rs.getInt("activecount");
            }
            rs.close();
            pst.close();
            if (activeRecipients <= 0) {
                pst = db.prepareStatement("UPDATE campaign SET status_id = ?, status = ?, " + DatabaseUtils.addQuotes(db, "active") + " = ?, " + "modifiedby = ?, " + "modified = CURRENT_TIMESTAMP " + "WHERE campaign_id = ? " + "AND status_id IN (" + 2 + ", " + 5 + ") ");
                int i = 0;
                pst.setInt(++i, 6);
                pst.setString(++i, CANCELED_TEXT);
                pst.setBoolean(++i, false);
                pst.setInt(++i, this.modifiedBy);
                pst.setInt(++i, this.id);
                resultCount = pst.executeUpdate();
                pst.close();
            }
            if (resultCount == 1) {
                int addSurveyId;
                pst = db.prepareStatement("DELETE FROM scheduled_recipient WHERE campaign_id = ? AND sent_date IS NULL ");
                pst.setInt(1, this.id);
                pst.execute();
                pst.close();
                pst = db.prepareStatement("DELETE FROM active_campaign_groups WHERE campaign_id = ? ");
                pst.setInt(1, this.id);
                pst.execute();
                pst.close();
                int activeSurveyId = ActiveSurvey.getId(db, this.id, 1);
                if (activeSurveyId > -1) {
                    ActiveSurvey activeSurvey = new ActiveSurvey(db, activeSurveyId);
                    activeSurvey.delete(db);
                }
                if ((addSurveyId = ActiveSurvey.getId(db, this.id, 2)) > -1) {
                    ActiveSurvey activeSurvey = new ActiveSurvey(db, addSurveyId);
                    activeSurvey.delete(db);
                }
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.toString());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
            pst.close();
        }
        return resultCount;
    }

    public int activate(Connection db, int userId, String userRangeId) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            throw new SQLException("Campaign ID was not specified");
        }
        boolean commit = false;
        PreparedStatement pst = null;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            StringBuffer sql = new StringBuffer("UPDATE campaign SET status_id = ?, status = ?, ");
            if (this.cc != null && !"".equals(this.cc)) {
                sql.append("cc = ?, ");
            }
            if (this.bcc != null && !"".equals(this.bcc)) {
                sql.append("bcc = ?, ");
            }
            sql.append("modifiedby = ?, modified = CURRENT_TIMESTAMP WHERE campaign_id = ? AND modified " + (this.getModified() == null ? "IS NULL " : "= ? ") + "AND " + DatabaseUtils.addQuotes(db, "active") + " = ? ");
            pst = db.prepareStatement(sql.toString());
            int i = 0;
            pst.setInt(++i, 2);
            pst.setString(++i, QUEUE_TEXT);
            if (this.cc != null && !"".equals(this.cc)) {
                pst.setString(++i, this.cc);
            }
            if (this.bcc != null && !"".equals(this.bcc)) {
                pst.setString(++i, this.bcc);
            }
            pst.setInt(++i, this.modifiedBy);
            pst.setInt(++i, this.id);
            if (this.getModified() != null) {
                pst.setTimestamp(++i, this.modified);
            }
            pst.setBoolean(++i, false);
            resultCount = pst.executeUpdate();
            pst.close();
            if (resultCount == 1) {
                ActiveSurvey activeSurvey;
                Survey thisSurvey;
                this.active = true;
                this.insertRecipients(db, userId, userRangeId);
                if (this.surveyId > -1) {
                    thisSurvey = new Survey(db, this.surveyId);
                    activeSurvey = new ActiveSurvey(thisSurvey);
                    activeSurvey.setEnteredBy(userId);
                    activeSurvey.setModifiedBy(userId);
                    activeSurvey.setCampaignId(this.id);
                    activeSurvey.insert(db);
                    this.surveyId = activeSurvey.getId();
                }
                if (this.hasAddressRequest) {
                    thisSurvey = new Survey(db, Survey.getAddressSurveyId(db));
                    activeSurvey = new ActiveSurvey(thisSurvey);
                    activeSurvey.setEnteredBy(userId);
                    activeSurvey.setModifiedBy(userId);
                    activeSurvey.setCampaignId(this.id);
                    activeSurvey.insert(db);
                    this.addressSurveyId = activeSurvey.getId();
                }
                Message thisMessage = new Message(db, this.getMessageId());
                SearchCriteriaListList thisList = new SearchCriteriaListList();
                thisList.setCampaignId(this.id);
                thisList.setBuildCriteria(true);
                thisList.buildList(db);
                this.lockGroupCriteria(thisList, db);
                Template template = new Template();
                if (this.surveyId > -1) {
                    template.addParseElement("${survey_url}", "<a href=\"http://" + this.getServerName() + "/ProcessSurvey.do?id=${surveyId=" + this.getActiveSurveyId() + "}\">http://" + this.getServerName() + "/ProcessSurvey.do?id=${surveyId=" + this.getActiveSurveyId() + "}</a>");
                    if (thisMessage.getMessageText().indexOf("${survey_url}") == -1) {
                        template.setText(thisMessage.getMessageText() + "<br><br>You can take the survey at the following web-site:<br />${survey_url}");
                        thisMessage.setMessageText(thisMessage.getMessageText() + "<br><br>You can take the survey at the following web-site:<br />${survey_url}");
                    } else {
                        template.setText(thisMessage.getMessageText());
                    }
                }
                if (this.hasAddressRequest) {
                    thisMessage.setMessageText(thisMessage.getMessageText() + "<br />" + "${server_name=" + this.serverName + "}" + "<br />" + "${contact_address=" + this.addressSurveyId + "}" + "<br />" + "${survey_url_address=" + this.addressSurveyId + "}");
                    template.setText(thisMessage.getMessageText());
                }
                if (this.surveyId == -1 && !this.hasAddressRequest) {
                    template.addParseElement("${received_confirmation_url}", "<a href=\"http://" + this.getServerName() + "/ProcessCampaignConfirmation.do?id=${campaignId=" + this.getId() + "}\">here</a>");
                    thisMessage.setMessageText(thisMessage.getMessageText() + "<br><br>Please click ${received_confirmation_url} to confirm that you have received the message!");
                    template.setText(thisMessage.getMessageText());
                }
                pst = db.prepareStatement("UPDATE campaign SET " + DatabaseUtils.addQuotes(db, "active") + " = ?, " + "reply_addr = ?, " + "subject = ?, " + "" + DatabaseUtils.addQuotes(db, "message") + " = ?, " + "modifiedby = ?, " + "modified = CURRENT_TIMESTAMP " + "WHERE campaign_id = ? ");
                i = 0;
                pst.setBoolean(++i, true);
                pst.setString(++i, thisMessage.getReplyTo());
                pst.setString(++i, thisMessage.getMessageSubject());
                pst.setString(++i, template.getParsedText());
                pst.setInt(++i, this.modifiedBy);
                pst.setInt(++i, this.id);
                resultCount = pst.executeUpdate();
                pst.close();
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        catch (Exception ee) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(ee.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return resultCount;
    }

    public void lockGroupCriteria(SearchCriteriaListList groups, Connection db) throws SQLException {
        for (SearchCriteriaList thisList : groups) {
            LinkedHashMap thisArray = thisList.getCriteriaTextArray();
            Iterator j = ((HashMap)thisArray).keySet().iterator();
            while (j.hasNext()) {
                String criteria = (String)((HashMap)thisArray).get(j.next());
                int k = 0;
                int seqId = DatabaseUtils.getNextSeq(db, "active_campaign_groups_id_seq");
                PreparedStatement pst = db.prepareStatement("INSERT INTO active_campaign_groups (" + (seqId > -1 ? "id, " : "") + "campaign_id, groupname, groupcriteria )" + "VALUES (" + (seqId > -1 ? "?, " : "") + "?, ?, ?) ");
                if (seqId > -1) {
                    pst.setInt(++k, seqId);
                }
                pst.setInt(++k, this.id);
                pst.setString(++k, thisList.getGroupName());
                pst.setString(++k, criteria);
                pst.execute();
                pst.close();
            }
        }
    }

    public int insertRun(Connection db) throws SQLException {
        CampaignRun thisRun = new CampaignRun();
        thisRun.setCampaignId(this.getId());
        thisRun.setTotalContacts(this.getRecipientCount());
        thisRun.setTotalSent(this.getSentCount());
        thisRun.insert(db);
        return thisRun.getId();
    }

    public int updateDetails(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Campaign ID was not specified");
        }
        int resultCount = 0;
        PreparedStatement pst = null;
        pst = db.prepareStatement("UPDATE campaign SET name = ?, description = ?, modifiedby = ?, modified = CURRENT_TIMESTAMP WHERE campaign_id = " + this.id);
        int i = 0;
        pst.setString(++i, this.name);
        pst.setString(++i, this.description);
        pst.setInt(++i, this.modifiedBy);
        resultCount = pst.executeUpdate();
        pst.close();
        this.parseUserGroups(db);
        return resultCount;
    }

    public int updateMessage(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Campaign ID was not specified");
        }
        int resultCount = 0;
        PreparedStatement pst = null;
        int i = 0;
        pst = db.prepareStatement("UPDATE campaign SET message_id = ?, reply_addr = null, subject = null, " + DatabaseUtils.addQuotes(db, "message") + " = null, " + "modifiedby = ?, " + "modified = CURRENT_TIMESTAMP " + "WHERE campaign_id = ? ");
        pst.setInt(++i, this.messageId);
        pst.setInt(++i, this.modifiedBy);
        pst.setInt(++i, this.id);
        resultCount = pst.executeUpdate();
        pst.close();
        MessageAttachmentList attachmentList = new MessageAttachmentList(db, 100120070, this.messageId);
        attachmentList.copyTo(db, 508200600, this.getId(), true);
        return resultCount;
    }

    public int updateSurvey(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Campaign ID was not specified");
        }
        int resultCount = 0;
        PreparedStatement pst = null;
        try {
            db.setAutoCommit(false);
            pst = db.prepareStatement("UPDATE campaign SET modifiedby = ?, modified = CURRENT_TIMESTAMP WHERE campaign_id = ? ");
            pst.setInt(1, this.modifiedBy);
            pst.setInt(2, this.id);
            resultCount = pst.executeUpdate();
            pst.close();
            int tmpSurveyId = Survey.getId(db, this.id, 1);
            pst = db.prepareStatement("DELETE FROM campaign_survey_link WHERE campaign_id = ? AND survey_id = ? ");
            pst.setInt(1, this.id);
            pst.setInt(2, tmpSurveyId);
            pst.execute();
            pst.close();
            if (this.surveyId > -1) {
                pst = db.prepareStatement("INSERT INTO campaign_survey_link (campaign_id, survey_id) VALUES (?, ?) ");
                pst.setInt(1, this.id);
                pst.setInt(2, this.surveyId);
                pst.execute();
                pst.close();
            }
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return resultCount;
    }

    public int updateAddressRequest(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Campaign ID was not specified");
        }
        int resultCount = 0;
        PreparedStatement pst = null;
        try {
            db.setAutoCommit(false);
            pst = db.prepareStatement("UPDATE campaign SET modifiedby = ?, modified = CURRENT_TIMESTAMP WHERE campaign_id = ? ");
            pst.setInt(1, this.modifiedBy);
            pst.setInt(2, this.id);
            resultCount = pst.executeUpdate();
            pst.close();
            int tmpSurveyId = Survey.getId(db, this.id, 2);
            pst = db.prepareStatement("DELETE FROM campaign_survey_link WHERE campaign_id = ? AND survey_id = ? ");
            pst.setInt(1, this.id);
            pst.setInt(2, tmpSurveyId);
            pst.execute();
            pst.close();
            if (this.hasAddressRequest && this.surveyId > -1) {
                pst = db.prepareStatement("INSERT INTO campaign_survey_link (campaign_id, survey_id) VALUES (?, ?) ");
                pst.setInt(1, this.id);
                pst.setInt(2, this.surveyId);
                pst.execute();
                pst.close();
            }
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return resultCount;
    }

    public int updateSchedule(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            throw new SQLException("Campaign ID was not specified");
        }
        PreparedStatement pst = null;
        int i = 0;
        pst = db.prepareStatement("UPDATE campaign SET message_id = ?, active_date = ?, active_date_timezone = ?, send_method_id = ?, modified = CURRENT_TIMESTAMP WHERE campaign_id = " + this.id);
        pst.setInt(++i, this.messageId);
        pst.setTimestamp(++i, this.activeDate);
        pst.setString(++i, this.activeDateTimeZone);
        pst.setInt(++i, this.sendMethodId);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    protected int update(Connection db, boolean override) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            throw new SQLException("Campaign ID was not specified");
        }
        if (this.status == null) {
            if (this.active) {
                this.setStatusId(2);
            } else {
                this.setStatusId(1);
            }
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE campaign SET description = ?, active_date = ?, active_date_timezone = ?, enabled = ?, trashed_date = ?, ");
        if (this.cc != null && !"".equals(this.cc)) {
            sql.append("cc = ?, ");
        }
        if (this.bcc != null && !"".equals(this.bcc)) {
            sql.append("bcc = ?, ");
        }
        if (override && this.modified != null) {
            sql.append("modified = ?, ");
        } else {
            sql.append("modified = CURRENT_TIMESTAMP, ");
        }
        sql.append("modifiedby = ?, " + DatabaseUtils.addQuotes(db, "active") + " = ?, status_id = ?, status = ?, message_id = ? " + "WHERE campaign_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.getDescription());
        DatabaseUtils.setTimestamp(pst, ++i, this.getActiveDate());
        pst.setString(++i, this.getActiveDateTimeZone());
        pst.setBoolean(++i, this.getEnabled());
        DatabaseUtils.setTimestamp(pst, ++i, this.getTrashedDate());
        if (this.cc != null && !"".equals(this.cc)) {
            pst.setString(++i, this.cc);
        }
        if (this.bcc != null && !"".equals(this.bcc)) {
            pst.setString(++i, this.bcc);
        }
        if (override && this.modified != null) {
            pst.setTimestamp(++i, this.modified);
        }
        pst.setInt(++i, this.getModifiedBy());
        pst.setBoolean(++i, this.getActive());
        pst.setInt(++i, this.getStatusId());
        pst.setString(++i, this.getStatus());
        pst.setInt(++i, this.getMessageId());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        if (this.statusId == 4) {
            Survey.removeLink(db, this.id);
        }
        this.parseUserGroups(db);
        return resultCount;
    }

    public boolean updateStatus(Connection db, boolean toTrash, int tmpUserId) throws SQLException {
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE campaign SET trashed_date = ? , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , " + "modifiedby = ? " + "WHERE campaign_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        if (toTrash) {
            DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(System.currentTimeMillis()));
        } else {
            DatabaseUtils.setTimestamp(pst, ++i, null);
        }
        DatabaseUtils.setInt(pst, ++i, tmpUserId);
        pst.setInt(++i, this.getId());
        pst.executeUpdate();
        pst.close();
        this.setBuildGroupMaps(true);
        this.buildUserGroupMaps(db);
        this.getUserGroupMaps().delete(db);
        ActionStepList stepList = new ActionStepList();
        stepList.setCampaignId(this.getId());
        stepList.buildList(db);
        stepList.resetCampaignInformation(db);
        ActionItemLog.deleteLink(db, this.getId(), 51320031);
        ContactHistory.deleteObject(db, 15, this.getId());
        ActiveSurvey activeSurvey = new ActiveSurvey();
        if (this.getHasSurvey()) {
            activeSurvey.setId(this.getActiveSurveyId());
            activeSurvey.delete(db);
        }
        if (this.getHasAddressRequest()) {
            activeSurvey.setId(ActiveSurvey.getId(db, this.getId(), 2));
            activeSurvey.delete(db);
        }
        return true;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("campaign_id"));
        this.name = rs.getString("name");
        this.description = rs.getString("description");
        this.groupId = rs.getInt("list_id");
        this.messageId = rs.getInt("message_id");
        this.replyTo = rs.getString("reply_addr");
        this.subject = rs.getString("subject");
        this.message = rs.getString("message");
        this.statusId = rs.getInt("status_id");
        this.status = rs.getString("status");
        this.active = rs.getBoolean("active");
        this.activeDate = rs.getTimestamp("active_date");
        this.sendMethodId = rs.getInt("send_method_id");
        this.inactiveDate = rs.getTimestamp("inactive_date");
        this.approvalDate = rs.getTimestamp("approval_date");
        this.approvedBy = DatabaseUtils.getInt(rs, "approvedBy");
        this.enabled = rs.getBoolean("enabled");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.type = rs.getInt("type");
        this.activeDateTimeZone = rs.getString("active_date_timezone");
        this.cc = rs.getString("cc");
        this.bcc = rs.getString("bcc");
        this.trashedDate = rs.getTimestamp("trashed_date");
        this.messageName = rs.getString("messageName");
        this.messageSubject = rs.getString("messageSubject");
        this.deliveryType = rs.getInt("deliveryType");
        this.deliveryName = rs.getString("deliveryTypeName");
    }

    public int lockProcess(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE campaign SET status_id = ? WHERE campaign_id = ? AND status_id = ? ");
        pst.setInt(1, this.statusId);
        pst.setInt(2, this.id);
        pst.setInt(3, 2);
        int count = pst.executeUpdate();
        pst.close();
        return count;
    }

    public static final int queryEnteredBy(Connection db, int campaignId) throws SQLException {
        int enteredBy = -1;
        PreparedStatement pst = db.prepareStatement("SELECT enteredby FROM campaign WHERE campaign_id = ? ");
        pst.setInt(1, campaignId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            enteredBy = rs.getInt("enteredby");
        }
        rs.close();
        pst.close();
        return enteredBy;
    }

    public static ArrayList getUserIdParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("enteredBy");
        thisList.add("modifiedBy");
        thisList.add("owner");
        return thisList;
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("activeDate");
        thisList.add("inactiveDate");
        return thisList;
    }

    public static boolean authenticateForBroadcast(Connection db, int tmpUserId, String password) throws SQLException {
        String pw = "";
        String encryptedPassword = PasswordHash.encrypt(password);
        PreparedStatement pst = db.prepareStatement("SELECT a.password FROM " + DatabaseUtils.addQuotes(db, "access") + " a " + "WHERE user_id = ? " + "AND a.enabled = ? ");
        pst.setInt(1, tmpUserId);
        pst.setBoolean(2, true);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            pw = rs.getString("password");
        }
        rs.close();
        pst.close();
        return pw != null && !pw.trim().equals("") && pw.equals(encryptedPassword);
    }

    public boolean restartCampaign(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Campaign ID required to restart the campaign");
        }
        String currentTimestamp = DatabaseUtils.getCurrentTimestamp(db);
        PreparedStatement pst = db.prepareStatement("UPDATE campaign SET status_id = ?, status = ?, active_date = " + currentTimestamp + " " + "WHERE campaign_id = ? ");
        pst.setInt(1, 2);
        pst.setString(2, QUEUE_TEXT);
        pst.setInt(3, this.getId());
        pst.executeUpdate();
        pst.close();
        return true;
    }

    public void buildMessageAttachments(Connection db) throws SQLException {
        this.messageAttachments = new MessageAttachmentList(db, 508200600, this.id);
    }
}

