/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import org.aspcfs.modules.communications.base.Campaign;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class CampaignList
extends Vector {
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    private PagedListInfo pagedListInfo = null;
    private String name = "";
    private String description = "";
    private Timestamp activeDate = null;
    private int enabled = -1;
    private int active = -1;
    private boolean incompleteOnly = false;
    private boolean completeOnly = false;
    private int owner = -1;
    private int type = -1;
    private String ownerIdRange = null;
    private String idRange = null;
    private int ready = -1;
    private int contactId = -1;
    private Timestamp trashedDate = null;
    private boolean includeOnlyTrashed = false;
    private int userGroupUserId = -1;
    private int siteId = -1;
    private boolean includeAllSites = true;
    private boolean exclusiveToSite = false;
    private Timestamp activeRangeStart = null;
    private Timestamp activeRangeEnd = null;
    private Timestamp runRangeStart = null;
    private Timestamp runRangeEnd = null;
    public static final String tableName = "campaign";
    public static final String uniqueField = "id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setActiveDate(Timestamp tmp) {
        this.activeDate = tmp;
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setActive(int tmp) {
        this.active = tmp;
    }

    public void setReady(int tmp) {
        this.ready = tmp;
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setIncludeOnlyTrashed(boolean tmp) {
        this.includeOnlyTrashed = tmp;
    }

    public void setIncludeOnlyTrashed(String tmp) {
        this.includeOnlyTrashed = DatabaseUtils.parseBoolean(tmp);
    }

    public void setIncompleteOnly(boolean tmp) {
        this.incompleteOnly = tmp;
    }

    public void setCompleteOnly(boolean tmp) {
        this.completeOnly = tmp;
    }

    public void setOwner(int tmp) {
        this.owner = tmp;
    }

    public void setOwnerIdRange(String tmp) {
        this.ownerIdRange = tmp;
    }

    public void setIdRange(String idRange) {
        this.idRange = idRange;
    }

    public void setActiveRangeStart(Timestamp tmp) {
        this.activeRangeStart = tmp;
    }

    public void setActiveRangeEnd(Timestamp tmp) {
        this.activeRangeEnd = tmp;
    }

    public void setRunRangeStart(Timestamp tmp) {
        this.runRangeStart = tmp;
    }

    public void setRunRangeEnd(Timestamp tmp) {
        this.runRangeEnd = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public String getIdRange() {
        return this.idRange;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHtmlSelect(String selectName) {
        return this.getHtmlSelect(selectName, -1);
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect campaignListSelect = new HtmlSelect();
        for (Campaign thisCampaign : this) {
            campaignListSelect.addItem(thisCampaign.getId(), thisCampaign.getName());
        }
        return campaignListSelect.getHtml(selectName, defaultKey);
    }

    public Timestamp getActiveDate() {
        return this.activeDate;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public int getActive() {
        return this.active;
    }

    public boolean getIncompleteOnly() {
        return this.incompleteOnly;
    }

    public boolean getCompleteOnly() {
        return this.completeOnly;
    }

    public int getUserGroupUserId() {
        return this.userGroupUserId;
    }

    public void setUserGroupUserId(int tmp) {
        this.userGroupUserId = tmp;
    }

    public void setUserGroupUserId(String tmp) {
        this.userGroupUserId = Integer.parseInt(tmp);
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public boolean getIncludeAllSites() {
        return this.includeAllSites;
    }

    public void setIncludeAllSites(boolean tmp) {
        this.includeAllSites = tmp;
    }

    public void setIncludeAllSites(String tmp) {
        this.includeAllSites = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getExclusiveToSite() {
        return this.exclusiveToSite;
    }

    public void setExclusiveToSite(boolean tmp) {
        this.exclusiveToSite = tmp;
    }

    public void setExclusiveToSite(String tmp) {
        this.exclusiveToSite = DatabaseUtils.parseBoolean(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM campaign c WHERE c.campaign_id > -1 ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(c.name) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
                this.pagedListInfo.setDefaultSort("c.name", null);
            } else if (this.completeOnly) {
                this.pagedListInfo.setDefaultSort("c.active_date", "desc");
            } else {
                this.pagedListInfo.setDefaultSort("c.active_date", null);
            }
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY c.modified desc ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("c.*, msg.name AS messageName, msg.subject AS messageSubject, dt.code AS deliveryType, dt.description AS deliveryTypeName FROM campaign c LEFT JOIN " + DatabaseUtils.addQuotes(db, "message") + " msg ON (c.message_id = msg.id) " + "LEFT JOIN lookup_delivery_options dt ON (c.send_method_id = dt.code) " + "WHERE c.campaign_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            Campaign thisCamp = new Campaign(rs);
            this.add(thisCamp);
        }
        rs.close();
        pst.close();
        this.buildResources(db);
    }

    private void createFilter(Connection db, StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.activeDate != null) {
            sqlFilter.append("AND c.active_date = ? ");
        }
        if (this.enabled == 0 || this.enabled == 1) {
            sqlFilter.append("AND c.enabled = ? ");
        }
        if (this.active == 0 || this.active == 1) {
            sqlFilter.append("AND c." + DatabaseUtils.addQuotes(db, "active") + " = ? ");
        }
        if (this.incompleteOnly) {
            sqlFilter.append("AND (active_date IS NULL OR " + DatabaseUtils.addQuotes(db, "active") + " = ?) ");
        }
        if (this.completeOnly) {
            sqlFilter.append("AND active_date IS NOT NULL AND " + DatabaseUtils.addQuotes(db, "active") + " = ? ");
        }
        if (this.owner > -1) {
            sqlFilter.append("AND c.enteredby = ? ");
        }
        if (!this.includeAllSites) {
            if (this.siteId > -1) {
                sqlFilter.append("AND (c.enteredby IN (SELECT user_id FROM " + DatabaseUtils.addQuotes(db, "access") + " WHERE site_id = ?) ");
                if (!this.exclusiveToSite) {
                    sqlFilter.append("OR c.enteredby IN (SELECT user_id FROM " + DatabaseUtils.addQuotes(db, "access") + " WHERE site_id IS NULL) ");
                }
                sqlFilter.append(") ");
            } else {
                sqlFilter.append("AND c.enteredby IN (SELECT user_id FROM " + DatabaseUtils.addQuotes(db, "access") + " WHERE site_id IS NULL) ");
            }
        }
        if (this.type > -1) {
            sqlFilter.append("AND c." + DatabaseUtils.addQuotes(db, "type") + " = ? ");
        }
        if (this.userGroupUserId > -1) {
            sqlFilter.append("AND (c.campaign_id IN ( SELECT campaign_id FROM campaign_group_map WHERE user_group_id IN ( SELECT group_id FROM user_group_map where user_id = ? )) ");
            if (this.ownerIdRange != null) {
                sqlFilter.append(" OR c.enteredBy IN (" + this.ownerIdRange + ") ");
            }
            sqlFilter.append(") ");
        } else if (this.ownerIdRange != null) {
            sqlFilter.append("AND c.enteredBy IN (" + this.ownerIdRange + ") ");
        }
        if (this.idRange != null) {
            sqlFilter.append("AND c.campaign_id IN (" + this.idRange + ") ");
        }
        if (this.ready == 1) {
            sqlFilter.append("AND c.status_id IN (2, 3) ");
        }
        if (this.contactId > -1) {
            sqlFilter.append("AND c.campaign_id IN (SELECT campaign_id FROM scheduled_recipient WHERE contact_id = ?) ");
        }
        if (this.activeRangeStart != null) {
            sqlFilter.append("AND active_date >= ? ");
        }
        if (this.activeRangeEnd != null) {
            sqlFilter.append("AND active_date <= ? ");
        }
        if (this.runRangeStart != null) {
            sqlFilter.append("AND c.campaign_id IN (SELECT campaign_id FROM campaign_run WHERE run_date >= ?) ");
        }
        if (this.runRangeEnd != null) {
            sqlFilter.append("AND c.campaign_id IN (SELECT campaign_id FROM campaign_run WHERE run_date <= ?) ");
        }
        if (this.includeOnlyTrashed) {
            sqlFilter.append("AND c.trashed_date IS NOT NULL ");
        } else if (this.trashedDate != null) {
            sqlFilter.append("AND c.trashed_date = ? ");
        } else {
            sqlFilter.append("AND c.trashed_date IS NULL ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.activeDate != null) {
            pst.setTimestamp(++i, this.activeDate);
        }
        if (this.enabled == 0) {
            pst.setBoolean(++i, false);
        } else if (this.enabled == 1) {
            pst.setBoolean(++i, true);
        }
        if (this.active == 0) {
            pst.setBoolean(++i, false);
        } else if (this.active == 1) {
            pst.setBoolean(++i, true);
        }
        if (this.incompleteOnly) {
            pst.setBoolean(++i, false);
        }
        if (this.completeOnly) {
            pst.setBoolean(++i, true);
        }
        if (this.owner > -1) {
            pst.setInt(++i, this.owner);
        }
        if (!this.includeAllSites && this.siteId > -1) {
            pst.setInt(++i, this.siteId);
        }
        if (this.type > -1) {
            pst.setInt(++i, this.type);
        }
        if (this.userGroupUserId > -1) {
            pst.setInt(++i, this.getUserGroupUserId());
        }
        if (this.contactId > -1) {
            pst.setInt(++i, this.contactId);
        }
        if (this.activeRangeStart != null) {
            pst.setTimestamp(++i, this.activeRangeStart);
        }
        if (this.activeRangeEnd != null) {
            pst.setTimestamp(++i, this.activeRangeEnd);
        }
        if (this.runRangeStart != null) {
            pst.setTimestamp(++i, this.runRangeStart);
        }
        if (this.runRangeEnd != null) {
            pst.setTimestamp(++i, this.runRangeEnd);
        }
        if (!this.includeOnlyTrashed && this.trashedDate != null) {
            pst.setTimestamp(++i, this.trashedDate);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    private void buildResources(Connection db) throws SQLException {
        for (Campaign thisCampaign : this) {
            thisCampaign.buildRecipientCount(db);
            thisCampaign.buildHasAddressRequest(db);
            thisCampaign.buildHasSurvey(db);
            thisCampaign.setGroupList(db);
            thisCampaign.buildFileCount(db);
            thisCampaign.buildMessageAttachments(db);
        }
    }

    public int queryRecordCount(Connection db) throws SQLException {
        int recordCount = 0;
        StringBuffer sqlFilter = new StringBuffer();
        String sqlCount = "SELECT COUNT(*) AS recordcount FROM campaign c WHERE c.campaign_id > -1 ";
        this.createFilter(db, sqlFilter);
        PreparedStatement pst = db.prepareStatement(sqlCount + sqlFilter.toString());
        int items = this.prepareFilter(pst);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            recordCount = DatabaseUtils.getInt(rs, "recordcount", 0);
        }
        rs.close();
        pst.close();
        return recordCount;
    }

    public void delete(Connection db, String filePath) throws SQLException {
        for (Campaign thisCampaign : this) {
            thisCampaign.delete(db, filePath);
        }
    }

    public String getNameById(int id) {
        String result = null;
        for (Campaign thisCampaign : this) {
            if (thisCampaign.getId() != id) continue;
            result = thisCampaign.getName();
            break;
        }
        return result;
    }
}

