/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CampaignListGroup {
    int campaignId = -1;
    int groupId = -1;

    public CampaignListGroup() {
    }

    public CampaignListGroup(Connection db, String id) throws SQLException {
        this.queryRecord(db, Integer.parseInt(id));
    }

    public CampaignListGroup(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public int getCampaignId() {
        return this.campaignId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setCampaignId(int tmp) {
        this.campaignId = tmp;
    }

    public void setGroupId(int tmp) {
        this.groupId = tmp;
    }

    public void setCampaignId(String tmp) {
        this.campaignId = Integer.parseInt(tmp);
    }

    public void setGroupId(String tmp) {
        this.groupId = Integer.parseInt(tmp);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Campaign List Group not found.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT c.* FROM campaign_list_groups c WHERE c.campaign_id = ? and c.group_id = ? ");
        pst.setInt(1, this.campaignId);
        pst.setInt(2, this.groupId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("Campaign List Group not found.");
        }
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        try {
            db.setAutoCommit(false);
            sql.append("INSERT INTO campaign_list_groups (campaign_id, group_id) ");
            sql.append("VALUES (?, ?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            if (this.campaignId > -1) {
                pst.setInt(++i, this.getCampaignId());
            } else {
                pst.setNull(++i, 4);
            }
            if (this.groupId > -1) {
                pst.setInt(++i, this.getGroupId());
            } else {
                pst.setNull(++i, 4);
            }
            pst.execute();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.campaignId = rs.getInt("campaign_id");
        this.groupId = rs.getInt("group_id");
    }
}

