/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import com.zeroio.iteam.base.FileItem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.aspcfs.modules.communications.base.ActiveSurveyAnswerItemList;
import org.aspcfs.modules.communications.base.ActiveSurveyQuestion;
import org.aspcfs.modules.communications.base.ActiveSurveyQuestionItem;
import org.aspcfs.modules.communications.base.ActiveSurveyQuestionItemList;
import org.aspcfs.modules.communications.base.ActiveSurveyQuestionList;
import org.aspcfs.modules.communications.base.Campaign;
import org.aspcfs.modules.communications.base.SurveyAnswer;
import org.aspcfs.modules.communications.base.SurveyAnswerItem;
import org.aspcfs.modules.communications.base.SurveyAnswerList;
import org.aspcfs.modules.contacts.base.Contact;

public class CampaignReport {
    protected int campaignId = -1;
    protected int enteredBy = -1;
    protected int modifiedBy = -1;
    protected String subject = null;
    protected String filePath = null;
    protected String filenameToUse = null;
    protected FileItem thisItem = new FileItem();
    protected HSSFWorkbook workBook = null;
    public static final String[] OPEN_ENDED_HEADER = new String[]{"Item", "Name", "Comments", "Email Address", "Address", "Phone Number(s)", "Company", "Title"};
    public static final String[] QUANTITATIVE_HEADER = new String[]{"Item", "Name", "1", "2", "3", "4", "5", "6", "7", "Email Address", "Address", "Phone Number(s)", "Company", "Title"};
    public static final String[] QUANTITATIVE_COMMENTS_HEADER = new String[]{"Item", "Name", "1", "2", "3", "4", "5", "6", "7", "Comments", "Email Address", "Address", "Phone Number(s)", "Company", "Title"};
    public static final String[] ITEMLIST_HEADER = new String[]{"Item", "Name", "ItemList", "Email Address", "Address", "Phone Number(s)", "Company", "Title"};

    public void setCampaignId(int campaignId) {
        this.campaignId = campaignId;
    }

    public void setWorkBook(HSSFWorkbook workBook) {
        this.workBook = workBook;
    }

    public void setEnteredBy(int enteredBy) {
        this.enteredBy = enteredBy;
    }

    public void setModifiedBy(int modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setFilenameToUse(String filenameToUse) {
        this.filenameToUse = filenameToUse;
    }

    public void setThisItem(FileItem thisItem) {
        this.thisItem = thisItem;
    }

    public String getFilenameToUse() {
        return this.filenameToUse;
    }

    public FileItem getThisItem() {
        return this.thisItem;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public String getSubject() {
        return this.subject;
    }

    public HSSFWorkbook getWorkBook() {
        return this.workBook;
    }

    public int getCampaignId() {
        return this.campaignId;
    }

    private HSSFCellStyle getHeaderStyle() {
        HSSFCellStyle headerStyle = this.workBook.createCellStyle();
        headerStyle.setAlignment((short)1);
        HSSFFont font = this.workBook.createFont();
        font.setBoldweight((short)700);
        headerStyle.setFont(font);
        return headerStyle;
    }

    private String getCaption(int questionType) {
        String caption = null;
        if (questionType == 1) {
            caption = "The following is a Summary Report for a Open Ended question.";
        } else if (questionType == 2) {
            caption = "The following is a Summary Report for a Quantitative question.";
        } else if (questionType == 3) {
            caption = "The following is a Summary Report for a Quantitative question with Comments.";
        } else if (questionType == 4) {
            caption = "The following is a Summary Report for an ItemList.";
        }
        return caption;
    }

    public void build(Connection db) throws SQLException {
        if (this.campaignId == -1) {
            throw new SQLException("CampaignReport -- > CampaignId not found");
        }
        try {
            Campaign thisCampaign = new Campaign(db, this.campaignId);
            this.workBook = new HSSFWorkbook();
            int surveyId = thisCampaign.getSurveyId();
            ActiveSurveyQuestionList questionList = new ActiveSurveyQuestionList();
            if (surveyId != -1) {
                questionList.setActiveSurveyId(surveyId);
                questionList.buildList(db);
            }
            this.addSummaryReport(db, thisCampaign, questionList);
            Iterator i = questionList.iterator();
            while (i.hasNext()) {
                HSSFSheet sheet = this.workBook.createSheet();
                this.addCampaignHeader(sheet, thisCampaign);
                ActiveSurveyQuestion thisQuestion = (ActiveSurveyQuestion)i.next();
                this.addQuestionToReport(sheet, thisQuestion);
                this.addPossibleAnswersToReport(sheet, thisQuestion);
                this.addResponsesToReport(db, sheet, thisQuestion);
            }
        }
        catch (Exception e) {
            System.out.println("Exception " + e.toString());
        }
    }

    private void addCampaignHeader(HSSFSheet sheet, Campaign thisCampaign) {
        HSSFRow headerRow = sheet.createRow(0);
        HSSFCell headerCell = headerRow.createCell((short)0);
        headerCell.setCellStyle(this.getHeaderStyle());
        headerCell.setCellValue(thisCampaign.getName());
        headerRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 1)));
        headerCell = headerRow.createCell((short)0);
        SimpleDateFormat formatter = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 1);
        headerCell.setCellStyle(this.getHeaderStyle());
        headerCell.setCellValue(formatter.format(new Date()));
        headerRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 1)));
        headerCell = headerRow.createCell((short)0);
        headerCell.setCellStyle(this.getHeaderStyle());
        headerCell.setCellValue("Generated By Centric CRM");
    }

    public void addSummaryReport(Connection db, Campaign campaign, ActiveSurveyQuestionList questionList) throws SQLException {
        HSSFSheet sheet = this.workBook.createSheet();
        this.addCampaignHeader(sheet, campaign);
        HSSFRow thisRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 2)));
        HSSFCell thisCell = thisRow.createCell((short)0);
        thisCell.setCellValue("Total Recipients");
        thisCell = thisRow.createCell((short)1);
        thisCell.setCellType(0);
        thisCell.setCellValue((double)campaign.getRecipientCount());
        thisRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 1)));
        thisCell = thisRow.createCell((short)0);
        thisCell.setCellValue("Total Responses");
        thisCell = thisRow.createCell((short)1);
        thisCell.setCellType(0);
        thisCell.setCellValue((double)campaign.getResponseCount());
        thisRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 1)));
        thisCell = thisRow.createCell((short)0);
        thisCell.setCellValue("Last Response Received");
        thisCell = thisRow.createCell((short)1);
        thisCell.setCellValue(campaign.getLastResponseString());
        if (!questionList.isEmpty()) {
            thisRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 3)));
            thisCell = thisRow.createCell((short)0);
            HSSFCellStyle headerStyle = this.workBook.createCellStyle();
            HSSFFont font = this.workBook.createFont();
            font.setBoldweight((short)400);
            thisCell.setCellStyle(headerStyle);
            thisCell.setCellValue("Survey Details");
            this.addQuestionSummary(db, sheet, questionList);
            thisRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 3)));
            thisCell = thisRow.createCell((short)0);
            thisCell.setCellValue("Note: Detailed reports for each question are available in the corresponding sheets contained in this report.");
        }
    }

    public void addQuestionSummary(Connection db, HSSFSheet sheet, ActiveSurveyQuestionList questionList) throws SQLException {
        int count = 0;
        for (ActiveSurveyQuestion thisQuestion : questionList) {
            Statement pst = null;
            SurveyAnswerList answerList = new SurveyAnswerList();
            answerList.setQuestionId(thisQuestion.getId());
            ResultSet rs = answerList.queryList(db, (PreparedStatement)pst);
            while (rs.next()) {
                SurveyAnswer thisAnswer = this.buildResponseRecord(rs);
                answerList.add(thisAnswer);
            }
            rs.close();
            if (pst != null) {
                pst.close();
            }
            thisQuestion.setAnswerList(answerList);
            int spaceBtwQuestions = 3;
            if (count == 0) {
                spaceBtwQuestions = 1;
            }
            HSSFRow thisRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + spaceBtwQuestions)));
            HSSFCellStyle questionStyle = this.workBook.createCellStyle();
            HSSFFont font = this.workBook.createFont();
            font.setColor((short)10);
            questionStyle.setFont(font);
            HSSFCell thisCell = thisRow.createCell((short)0);
            thisCell.setCellStyle(questionStyle);
            thisCell.setCellValue(++count + ". " + thisQuestion.getDescription());
            HSSFRow typeRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 1)));
            thisCell = typeRow.createCell((short)0);
            thisCell.setCellValue("Type: " + thisQuestion.getTypeString());
            int type = thisQuestion.getType();
            if (type == 1) {
                thisRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 1)));
                thisCell = thisRow.createCell((short)0);
                thisCell.setCellValue("Response: " + answerList.size() + " comments");
                continue;
            }
            if (type == 2) {
                thisRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 1)));
                thisCell = thisRow.createCell((short)0);
                thisCell.setCellValue("Response: Avg " + thisQuestion.getAverageValue());
                continue;
            }
            if (type == 3) {
                thisRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 1)));
                thisCell = thisRow.createCell((short)0);
                thisCell.setCellValue("Response: Avg " + thisQuestion.getAverageValue());
                continue;
            }
            if (type != 4) continue;
            thisRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 1)));
            thisCell = thisRow.createCell((short)0);
            thisCell.setCellValue("Item");
            thisCell = typeRow.createCell((short)(thisRow.getLastCellNum() + 1));
            thisCell.setCellValue("Response");
            int itemCount = 0;
            for (ActiveSurveyQuestionItem tmp : thisQuestion.getItemList()) {
                thisRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 1)));
                thisCell = thisRow.createCell((short)0);
                thisCell.setCellValue(++itemCount + ". " + tmp.getDescription());
                int answerCount = ActiveSurveyAnswerItemList.getItemCount(db, tmp.getId());
                thisCell = thisRow.createCell((short)(thisRow.getLastCellNum() + 1));
                thisCell.setCellType(0);
                thisCell.setCellValue((double)answerCount);
            }
        }
    }

    public void addQuestionToReport(HSSFSheet sheet, ActiveSurveyQuestion question) {
        HSSFRow headerRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 2)));
        HSSFCell headerCell = headerRow.createCell((short)0);
        headerCell.setCellStyle(this.getHeaderStyle());
        headerCell.setCellValue(this.getCaption(question.getType()));
        HSSFRow questionRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 2)));
        HSSFCellStyle columnHeaderStyle = this.workBook.createCellStyle();
        columnHeaderStyle.setFillBackgroundColor((short)54);
        columnHeaderStyle.setFillForegroundColor((short)54);
        HSSFFont font = this.workBook.createFont();
        font.setColor((short)10);
        columnHeaderStyle.setFont(font);
        HSSFCell colHeading1 = questionRow.createCell((short)0);
        colHeading1.setCellStyle(columnHeaderStyle);
        colHeading1.setCellValue(question.getDescription());
    }

    public void addPossibleAnswersToReport(HSSFSheet sheet, ActiveSurveyQuestion question) {
        HSSFRow answerTypeRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 2)));
        HSSFCell colHeading1 = answerTypeRow.createCell((short)0);
        if (question.getType() == 4) {
            HSSFRow optionsRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 1)));
            HSSFCell options = optionsRow.createCell((short)0);
            options.setCellValue("Options");
            ActiveSurveyQuestionItemList itemList = question.getItemList();
            int index = 0;
            for (ActiveSurveyQuestionItem tmp : itemList) {
                HSSFRow itemListRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 1)));
                HSSFCell thisItem = itemListRow.createCell((short)0);
                thisItem.setCellValue(++index + ". " + tmp.getDescription());
            }
        }
        colHeading1.setCellValue(question.getTypeString());
    }

    public void addResponsesToReport(Connection db, HSSFSheet sheet, ActiveSurveyQuestion question) throws SQLException {
        int type;
        if (question.getAnswerList() == null) {
            Statement pst = null;
            SurveyAnswerList answerList = new SurveyAnswerList();
            answerList.setQuestionId(question.getId());
            ResultSet rs = answerList.queryList(db, (PreparedStatement)pst);
            while (rs.next()) {
                SurveyAnswer thisAnswer = this.buildResponseRecord(rs);
                answerList.add(thisAnswer);
            }
            rs.close();
            if (pst != null) {
                pst.close();
            }
            question.setAnswerList(answerList);
        }
        if ((type = question.getType()) == 1) {
            this.addOpenEndedResponse(db, sheet, question);
        } else if (type == 2) {
            this.addQuantResponse(db, sheet, question);
        } else if (type == 3) {
            this.addQuantWithCommentsResponse(db, sheet, question);
        } else if (type == 4) {
            this.addItemListResponse(db, sheet, question);
        }
    }

    public void addOpenEndedResponse(Connection db, HSSFSheet sheet, ActiveSurveyQuestion question) throws SQLException {
        this.addHeader(sheet, OPEN_ENDED_HEADER);
        Iterator i = question.getAnswerList().iterator();
        int itemNumber = 0;
        while (i.hasNext()) {
            SurveyAnswer thisAnswer = (SurveyAnswer)i.next();
            Contact thisContact = new Contact();
            thisContact.setBuildDetails(true);
            thisContact.queryRecord(db, thisAnswer.getContactId());
            HSSFRow dataRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 1)));
            HSSFCell thisCell = null;
            int startIndex = 0;
            thisCell = dataRow.createCell((short)startIndex);
            thisCell.setCellType(0);
            thisCell.setCellValue((double)(++itemNumber));
            thisCell = dataRow.createCell((short)(++startIndex));
            thisCell.setCellValue(thisContact.getNameLastFirst());
            thisCell = dataRow.createCell((short)(++startIndex));
            thisCell.setCellValue(thisAnswer.getComments());
            this.addContactDetails(dataRow, thisContact);
        }
    }

    public void addQuantResponse(Connection db, HSSFSheet sheet, ActiveSurveyQuestion question) throws SQLException {
        this.addHeader(sheet, QUANTITATIVE_HEADER);
        Iterator i = question.getAnswerList().iterator();
        int itemNumber = 0;
        while (i.hasNext()) {
            SurveyAnswer thisAnswer = (SurveyAnswer)i.next();
            Contact thisContact = new Contact();
            thisContact.setBuildDetails(true);
            thisContact.queryRecord(db, thisAnswer.getContactId());
            HSSFRow dataRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 1)));
            HSSFCell thisCell = null;
            int startIndex = 0;
            thisCell = dataRow.createCell((short)startIndex);
            thisCell.setCellType(0);
            thisCell.setCellValue((double)(++itemNumber));
            thisCell = dataRow.createCell((short)(++startIndex));
            thisCell.setCellValue(thisContact.getNameLastFirst());
            for (int j = 1; j <= 7; ++j) {
                thisCell = dataRow.createCell((short)(++startIndex));
                thisCell.setCellType(0);
                thisCell.setCellValue((double)(j == thisAnswer.getQuantAns() ? 1 : 0));
            }
            this.addContactDetails(dataRow, thisContact);
        }
    }

    public void addQuantWithCommentsResponse(Connection db, HSSFSheet sheet, ActiveSurveyQuestion question) throws SQLException {
        this.addHeader(sheet, QUANTITATIVE_COMMENTS_HEADER);
        Iterator i = question.getAnswerList().iterator();
        int itemNumber = 0;
        while (i.hasNext()) {
            SurveyAnswer thisAnswer = (SurveyAnswer)i.next();
            Contact thisContact = new Contact();
            thisContact.setBuildDetails(true);
            thisContact.queryRecord(db, thisAnswer.getContactId());
            HSSFRow dataRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 1)));
            HSSFCell thisCell = null;
            int startIndex = 0;
            thisCell = dataRow.createCell((short)startIndex);
            thisCell.setCellType(0);
            thisCell.setCellValue((double)(++itemNumber));
            thisCell = dataRow.createCell((short)(++startIndex));
            thisCell.setCellValue(thisContact.getNameLastFirst());
            for (int j = 1; j <= 7; ++j) {
                thisCell = dataRow.createCell((short)(++startIndex));
                thisCell.setCellType(0);
                thisCell.setCellValue((double)(j == thisAnswer.getQuantAns() ? 1 : 0));
            }
            thisCell = dataRow.createCell((short)(++startIndex));
            thisCell.setCellValue(thisAnswer.getComments());
            this.addContactDetails(dataRow, thisContact);
        }
    }

    public void addItemListResponse(Connection db, HSSFSheet sheet, ActiveSurveyQuestion question) throws SQLException {
        Statement pst = null;
        this.addItemListHeader(sheet, question);
        ActiveSurveyAnswerItemList answers = null;
        int itemNumber = 0;
        for (SurveyAnswer thisAnswer : question.getAnswerList()) {
            answers = new ActiveSurveyAnswerItemList();
            answers.setContactId(thisAnswer.getContactId());
            answers.setAnswerId(thisAnswer.getId());
            ResultSet rs = answers.queryList(db, (PreparedStatement)pst);
            while (rs.next()) {
                SurveyAnswerItem thisItem = this.buildItemRecord(rs);
                answers.add(thisItem);
            }
            if (pst != null) {
                pst.close();
            }
            rs.close();
            Contact thisContact = new Contact();
            thisContact.setBuildDetails(true);
            thisContact.queryRecord(db, thisAnswer.getContactId());
            HSSFRow dataRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 1)));
            HSSFCell thisCell = null;
            int startIndex = 0;
            thisCell = dataRow.createCell((short)startIndex);
            thisCell.setCellType(0);
            thisCell.setCellValue((double)(++itemNumber));
            thisCell = dataRow.createCell((short)(++startIndex));
            thisCell.setCellValue(thisContact.getNameLastFirst());
            for (ActiveSurveyQuestionItem tmp : question.getItemList()) {
                thisCell = dataRow.createCell((short)(++startIndex));
                thisCell.setCellType(0);
                if (answers.hasItem(tmp.getId())) {
                    thisCell.setCellValue("1");
                    continue;
                }
                thisCell.setCellValue("0");
            }
            this.addContactDetails(dataRow, thisContact);
        }
    }

    private void addContactDetails(HSSFRow dataRow, Contact thisContact) {
        int startIndex = dataRow.getLastCellNum() + 1;
        HSSFCell thisCell = dataRow.createCell((short)startIndex);
        thisCell.setCellValue(thisContact.getPrimaryEmailAddress());
        thisCell = dataRow.createCell((short)(++startIndex));
        if (thisContact.getPrimaryAddress() != null) {
            thisCell.setCellValue(thisContact.getPrimaryAddress().toString());
        } else {
            thisCell.setCellValue("");
        }
        thisCell = dataRow.createCell((short)(++startIndex));
        thisCell.setCellValue(thisContact.getPrimaryPhoneNumber());
        thisCell = dataRow.createCell((short)(++startIndex));
        thisCell.setCellValue(thisContact.getCompany());
        thisCell = dataRow.createCell((short)(++startIndex));
        thisCell.setCellValue(thisContact.getTitle());
    }

    public void addHeader(HSSFSheet sheet, String[] headerType) {
        HSSFRow headerRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 2)));
        HSSFCell headerValue = null;
        int columnIndex = 0;
        for (int i = 0; i < headerType.length; ++i) {
            headerValue = headerRow.createCell((short)columnIndex++);
            headerValue.setCellValue(headerType[i]);
        }
    }

    public void addItemListHeader(HSSFSheet sheet, ActiveSurveyQuestion question) {
        HSSFRow headerRow = sheet.createRow((int)((short)(sheet.getLastRowNum() + 2)));
        HSSFCell headerValue = null;
        int columnIndex = 0;
        for (int i = 0; i < ITEMLIST_HEADER.length; ++i) {
            headerValue = headerRow.createCell((short)columnIndex++);
            if ("ItemList".equals(ITEMLIST_HEADER[i])) {
                Iterator j = question.getItemList().iterator();
                while (j.hasNext()) {
                    ActiveSurveyQuestionItem thisItem = (ActiveSurveyQuestionItem)j.next();
                    headerValue.setCellValue(thisItem.getDescription());
                    if (!j.hasNext()) continue;
                    headerValue = headerRow.createCell((short)columnIndex++);
                }
                continue;
            }
            headerValue.setCellValue(ITEMLIST_HEADER[i]);
        }
    }

    public boolean saveAndInsert(Connection db) throws Exception {
        int fileSize = this.save();
        this.thisItem.setLinkModuleId(17);
        this.thisItem.setLinkItemId(this.campaignId);
        this.thisItem.setEnteredBy(this.enteredBy);
        this.thisItem.setModifiedBy(this.modifiedBy);
        this.thisItem.setSubject("Exported Campaign Report");
        this.thisItem.setClientFilename("campaignreports-" + this.filenameToUse + ".xls");
        this.thisItem.setFilename(this.filenameToUse + "-" + this.enteredBy);
        this.thisItem.setVersion(1.0);
        this.thisItem.setSize(fileSize);
        this.thisItem.insert(db);
        return true;
    }

    public int save() throws Exception {
        this.generateFilename();
        File f = new File(this.filePath);
        f.mkdirs();
        FileOutputStream stream = new FileOutputStream(this.filePath + this.filenameToUse + "-" + this.enteredBy);
        this.workBook.write((OutputStream)stream);
        File fileLink = new File(this.filePath + this.filenameToUse + "-" + this.enteredBy);
        return (int)fileLink.length();
    }

    public String generateFilename() throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        this.filenameToUse = formatter.format(new Date());
        return this.filenameToUse;
    }

    protected SurveyAnswer buildResponseRecord(ResultSet rs) throws SQLException {
        SurveyAnswer thisAnswer = new SurveyAnswer();
        thisAnswer.setId(rs.getInt("answer_id"));
        thisAnswer.setResponseId(rs.getInt("response_id"));
        thisAnswer.setComments(rs.getString("comments"));
        thisAnswer.setQuantAns(rs.getInt("quant_ans"));
        thisAnswer.setTextAns(rs.getString("text_ans"));
        thisAnswer.setEntered(rs.getTimestamp("entered"));
        thisAnswer.setContactId(rs.getInt("contactid"));
        return thisAnswer;
    }

    protected SurveyAnswerItem buildItemRecord(ResultSet rs) throws SQLException {
        SurveyAnswerItem thisAnswer = new SurveyAnswerItem();
        thisAnswer.setId(rs.getInt("item_id"));
        return thisAnswer;
    }
}

