/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class CampaignRun {
    private int id = -1;
    private int campaignId = -1;
    private int status = 0;
    private Timestamp runDate = null;
    private int totalContacts = 0;
    private int totalSent = 0;
    private int totalReplied = 0;
    private int totalBounced = 0;

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setCampaignId(int tmp) {
        this.campaignId = tmp;
    }

    public void setCampaignId(String tmp) {
        this.campaignId = Integer.parseInt(tmp);
    }

    public void setStatus(int tmp) {
        this.status = tmp;
    }

    public void setStatus(String tmp) {
        this.status = Integer.parseInt(tmp);
    }

    public void setRunDate(Timestamp tmp) {
        this.runDate = tmp;
    }

    public void setRunDate(String tmp) {
        this.runDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setTotalContacts(int tmp) {
        this.totalContacts = tmp;
    }

    public void setTotalContacts(String tmp) {
        this.totalContacts = Integer.parseInt(tmp);
    }

    public void setTotalSent(int tmp) {
        this.totalSent = tmp;
    }

    public void setTotalSent(String tmp) {
        this.totalSent = Integer.parseInt(tmp);
    }

    public void setTotalReplied(int tmp) {
        this.totalReplied = tmp;
    }

    public void setTotalReplied(String tmp) {
        this.totalReplied = Integer.parseInt(tmp);
    }

    public void setTotalBounced(int tmp) {
        this.totalBounced = tmp;
    }

    public void setTotalBounced(String tmp) {
        this.totalBounced = Integer.parseInt(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getCampaignId() {
        return this.campaignId;
    }

    public int getStatus() {
        return this.status;
    }

    public Timestamp getRunDate() {
        return this.runDate;
    }

    public int getTotalContacts() {
        return this.totalContacts;
    }

    public int getTotalSent() {
        return this.totalSent;
    }

    public int getTotalReplied() {
        return this.totalReplied;
    }

    public int getTotalBounced() {
        return this.totalBounced;
    }

    public CampaignRun() {
    }

    public CampaignRun(Connection db, int id) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT * FROM campaign_run WHERE id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("Campaign Run ID not found");
        }
    }

    public boolean insert(Connection db) throws SQLException {
        if (this.campaignId == -1) {
            throw new SQLException("Campaign ID not specified");
        }
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "campaign_run_id_seq");
        sql.append("INSERT INTO campaign_run (campaign_id, status, total_contacts, total_sent, total_replied, ");
        if (this.runDate != null) {
            sql.append("run_date, ");
        }
        if (this.id > -1) {
            sql.append("id, ");
        }
        sql.append("total_bounced) ");
        sql.append("VALUES ");
        sql.append("(?, ?, ?, ?, ?, ");
        if (this.runDate != null) {
            sql.append("?, ");
        }
        if (this.id > -1) {
            sql.append("?, ");
        }
        sql.append("?) ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setInt(++i, this.campaignId);
        pst.setInt(++i, this.status);
        pst.setInt(++i, this.totalContacts);
        pst.setInt(++i, this.totalSent);
        pst.setInt(++i, this.totalReplied);
        if (this.runDate != null) {
            pst.setTimestamp(++i, this.runDate);
        }
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.totalBounced);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "campaign_run_id_seq", this.id);
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.campaignId = rs.getInt("campaign_id");
        this.status = rs.getInt("status");
        this.runDate = rs.getTimestamp("run_date");
        this.totalContacts = rs.getInt("total_contacts");
        this.totalSent = rs.getInt("total_sent");
        this.totalReplied = rs.getInt("total_replied");
        this.totalBounced = rs.getInt("total_bounced");
    }
}

