/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class CampaignUserGroupMap
extends GenericBean {
    private int id = -1;
    private int campaignId = -1;
    private int userGroupId = -1;
    private String groupName = null;
    private boolean canDelete = false;

    public CampaignUserGroupMap() {
    }

    public CampaignUserGroupMap(Connection db, String tmpId) throws SQLException {
        this.queryRecord(db, Integer.parseInt(tmpId));
    }

    public CampaignUserGroupMap(Connection db, int campaignId, int userGroupId) throws SQLException {
        this.queryRecord(db, campaignId, userGroupId);
    }

    public CampaignUserGroupMap(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement("SELECT cgm.*, ug.group_name AS name FROM campaign_group_map cgm LEFT JOIN user_group ug ON (cgm.user_group_id = ug.group_id) WHERE cgm.map_id = ? ");
        pst.setInt(1, id);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
    }

    public void queryRecord(Connection db, int campaignId, int userGroupId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement("SELECT cgm.*, ug.group_name AS name FROM campaign_group_map cgm LEFT JOIN user_group ug ON (cgm.user_group_id = ug.group_id) WHERE cgm.campaign_id = ? AND cgm.user_group_id = ? ");
        pst.setInt(1, campaignId);
        pst.setInt(2, userGroupId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
    }

    void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("map_id");
        this.campaignId = rs.getInt("campaign_id");
        this.userGroupId = rs.getInt("user_group_id");
        this.groupName = rs.getString("name");
    }

    public boolean parse(Connection db) throws SQLException {
        if (this.canDelete && this.getId() > -1) {
            return this.delete(db);
        }
        PreparedStatement pst = null;
        Object rs = null;
        int i = 0;
        if (this.id == -1) {
            this.id = DatabaseUtils.getNextSeq(db, "campaign_group_map_map_id_seq");
            pst = db.prepareStatement("INSERT INTO campaign_group_map (" + (this.id > -1 ? "map_id," : "") + " campaign_id, user_group_id) " + " VALUES (" + (this.getId() > -1 ? "?," : "") + "?,?) ");
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.getCampaignId());
            pst.setInt(++i, this.getUserGroupId());
            pst.execute();
            this.id = DatabaseUtils.getCurrVal(db, "campaign_group_map_map_id_seq", this.id);
            pst.close();
        }
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM campaign_group_map WHERE map_id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        return true;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(int tmp) {
        this.campaignId = tmp;
    }

    public void setCampaignId(String tmp) {
        this.campaignId = Integer.parseInt(tmp);
    }

    public int getUserGroupId() {
        return this.userGroupId;
    }

    public void setUserGroupId(int tmp) {
        this.userGroupId = tmp;
    }

    public void setUserGroupId(String tmp) {
        this.userGroupId = Integer.parseInt(tmp);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String tmp) {
        this.groupName = tmp;
    }

    public boolean getCanDelete() {
        return this.canDelete;
    }

    public void setCanDelete(boolean tmp) {
        this.canDelete = tmp;
    }

    public void setCanDelete(String tmp) {
        this.canDelete = DatabaseUtils.parseBoolean(tmp);
    }
}

