/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.aspcfs.modules.admin.base.UserGroupList;
import org.aspcfs.modules.communications.base.CampaignUserGroupMap;
import org.aspcfs.utils.web.PagedListInfo;

public class CampaignUserGroupMapList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int campaignId = -1;
    private int userGroupId = -1;

    public CampaignUserGroupMapList() {
    }

    public CampaignUserGroupMapList(Connection db) throws SQLException {
        this.buildList(db);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM campaign_group_map cgm LEFT JOIN user_group ug ON (cgm.user_group_id = ug.group_id) WHERE map_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("cgm.map_id", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY cgm.map_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("cgm.*, ug.group_name AS name FROM campaign_group_map cgm LEFT JOIN user_group ug ON (cgm.user_group_id = ug.group_id) WHERE map_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            CampaignUserGroupMap thisCampaignUserGroupMap = new CampaignUserGroupMap(rs);
            this.add(thisCampaignUserGroupMap);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) throws SQLException {
        if (this.id > -1) {
            sqlFilter.append("AND cgm.map_id = ? ");
        }
        if (this.campaignId > -1) {
            sqlFilter.append("AND cgm.campaign_id = ? ");
        }
        if (this.userGroupId > -1) {
            sqlFilter.append("AND cgm.user_group_id = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.campaignId > -1) {
            pst.setInt(++i, this.campaignId);
        }
        if (this.userGroupId > -1) {
            pst.setInt(++i, this.userGroupId);
        }
        return i;
    }

    public void setElements(String groups) {
        StringTokenizer str = new StringTokenizer(groups, "|");
        while (str.hasMoreTokens()) {
            String[] elements;
            CampaignUserGroupMap groupMap = new CampaignUserGroupMap();
            groupMap.setCampaignId(this.getCampaignId());
            String temp = str.nextToken();
            if (temp == null || "".equals(temp) || (elements = temp.split(",")).length <= 0) continue;
            groupMap.setUserGroupId(elements[0]);
            groupMap.setGroupName(elements[1]);
            this.add(groupMap);
        }
    }

    public void updateElements(HashMap map) {
        HashMap mapOfElements = this.createMapOfElements();
        for (Integer key : map.keySet()) {
            if (mapOfElements.get(key) != null) continue;
            CampaignUserGroupMap groupMap = new CampaignUserGroupMap();
            groupMap.setCampaignId(this.getCampaignId());
            groupMap.setUserGroupId(key);
            groupMap.setGroupName((String)map.get(key));
            this.add(groupMap);
        }
    }

    public void insert(Connection db) throws SQLException {
        for (CampaignUserGroupMap groupMap : this) {
            if (groupMap.getCampaignId() == -1) {
                groupMap.setCampaignId(this.getCampaignId());
            }
            groupMap.parse(db);
        }
    }

    public void delete(Connection db) throws SQLException {
        for (CampaignUserGroupMap groupMap : this) {
            groupMap.delete(db);
        }
    }

    public HashMap createMapOfElements() {
        HashMap<Integer, CampaignUserGroupMap> map = new HashMap<Integer, CampaignUserGroupMap>();
        for (CampaignUserGroupMap groupMap : this) {
            map.put(new Integer(groupMap.getUserGroupId()), groupMap);
        }
        return map;
    }

    public boolean checkUserAccess(Connection db, int userId, int siteId) throws SQLException {
        UserGroupList userGroups = new UserGroupList();
        userGroups.setGetEnabledForUser(1, userId);
        userGroups.setCampaignId(this.getCampaignId());
        userGroups.setExclusiveToSite(true);
        userGroups.setSiteId(siteId);
        userGroups.buildList(db);
        return userGroups.size() > 0;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(int tmp) {
        this.campaignId = tmp;
    }

    public void setCampaignId(String tmp) {
        this.campaignId = Integer.parseInt(tmp);
    }

    public int getUserGroupId() {
        return this.userGroupId;
    }

    public void setUserGroupId(int tmp) {
        this.userGroupId = tmp;
    }

    public void setUserGroupId(String tmp) {
        this.userGroupId = Integer.parseInt(tmp);
    }
}

