/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;

public class CommunicationsPreference
extends GenericBean {
    private int id = -1;
    private int contactId = -1;
    private int typeId = -1;
    private int startDay = -1;
    private int endDay = -1;
    private int startTimeHour = -1;
    private int startTimeMinute = -1;
    private int endTimeHour = -1;
    private int endTimeMinute = -1;
    private int level = -1;
    private String timeZone = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private boolean enabled = false;
    private String type = null;
    private String startDayName = null;
    private String endDayName = null;

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public void setStartDay(int tmp) {
        this.startDay = tmp;
    }

    public void setStartDay(String tmp) {
        this.startDay = Integer.parseInt(tmp);
    }

    public void setEndDay(int tmp) {
        this.endDay = tmp;
    }

    public void setEndDay(String tmp) {
        this.endDay = Integer.parseInt(tmp);
    }

    public void setStartTimeHour(int tmp) {
        this.startTimeHour = tmp;
    }

    public void setStartTimeHour(String tmp) {
        this.startTimeHour = Integer.parseInt(tmp);
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public void setTimeZone(String tmp) {
        this.timeZone = tmp;
    }

    public String getTimeZone() {
        boolean counter = false;
        String result = null;
        if (this.timeZone != null) {
            SimpleDateFormat formatter = new SimpleDateFormat();
            formatter.applyPattern("z");
            Timestamp timestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
            TimeZone tz = TimeZone.getTimeZone(this.timeZone);
            formatter.setTimeZone(tz);
            result = formatter.format(timestamp);
        }
        return result;
    }

    public int getLevel() {
        return this.level;
    }

    public void setStartTimeHour(int hour, int tmp) {
        Calendar calendar = Calendar.getInstance();
        if (tmp == 0) {
            this.startTimeHour = hour;
        } else if (tmp == 1) {
            this.startTimeHour = hour + 12;
        }
    }

    public void setStartTimeHour(String hourString, String tmpString) {
        int hour = Integer.parseInt(hourString);
        int tmp = Integer.parseInt(tmpString);
        if (tmp == 0) {
            this.startTimeHour = hour;
        } else if (tmp == 1) {
            this.startTimeHour = hour + 12;
        }
    }

    public void setStartTimeMinute(int tmp) {
        this.startTimeMinute = tmp;
    }

    public void setStartTimeMinute(String tmp) {
        this.startTimeMinute = Integer.parseInt(tmp);
    }

    public void setEndTimeHour(int tmp) {
        this.endTimeHour = tmp;
    }

    public void setEndTimeHour(String tmp) {
        this.endTimeHour = Integer.parseInt(tmp);
    }

    public void setEndTimeHour(int hour, int tmp) {
        Calendar calendar = Calendar.getInstance();
        if (tmp == 0) {
            this.endTimeHour = hour;
        } else if (tmp == 1) {
            this.endTimeHour = hour + 12;
        }
    }

    public void setEndTimeHour(String hourString, String tmpString) {
        int hour = Integer.parseInt(hourString);
        int tmp = Integer.parseInt(tmpString);
        if (tmp == 0) {
            this.endTimeHour = hour;
        } else if (tmp == 1) {
            this.endTimeHour = hour + 12;
        }
    }

    public void setEndTimeMinute(int tmp) {
        this.endTimeMinute = tmp;
    }

    public void setEndTimeMinute(String tmp) {
        this.endTimeMinute = Integer.parseInt(tmp);
    }

    public void setType(String tmp) {
        this.type = tmp;
    }

    public void setStartDayName(String tmp) {
        this.startDayName = tmp;
    }

    public void setEndDayName(String tmp) {
        this.endDayName = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setTypeId(int tmp) {
        this.typeId = tmp;
    }

    public void setTypeId(String tmp) {
        this.typeId = Integer.parseInt(tmp);
    }

    public int getTypeId() {
        return this.typeId;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getId() {
        return this.id;
    }

    public int getContactId() {
        return this.contactId;
    }

    public int getStartDay() {
        return this.startDay;
    }

    public int getEndDay() {
        return this.endDay;
    }

    public int getStartTimeHour() {
        return this.startTimeHour;
    }

    public String getStartTimeHour(String str) {
        String result = "";
        String minute = "" + this.startTimeMinute;
        if (this.startTimeMinute / 10 % 10 == 0 && this.startTimeMinute / 10 <= 0) {
            minute = "0" + minute;
        }
        result = this.startTimeHour < 13 ? new String(this.startTimeHour + ":" + minute + " AM") : (this.startTimeHour == 12 ? new String(this.startTimeHour + ":" + minute + " PM") : (this.startTimeHour == 24 ? new String(this.startTimeHour + ":" + minute + " AM") : new String(this.startTimeHour - 12 + ":" + minute + " PM")));
        return result;
    }

    public int getStartTimeMinute() {
        return this.startTimeMinute;
    }

    public int getEndTimeHour() {
        return this.endTimeHour;
    }

    public String getEndTimeHour(String str) {
        String result = "";
        String minute = "" + this.endTimeMinute;
        if (this.endTimeMinute / 10 % 10 == 0 && this.endTimeMinute / 10 <= 0) {
            minute = "0" + minute;
        }
        result = this.endTimeHour < 12 ? new String(this.endTimeHour + ":0" + minute + " AM") : (this.endTimeHour == 12 ? new String(this.endTimeHour + ":" + minute + " PM") : (this.endTimeHour == 24 ? new String(this.endTimeHour + ":" + minute + " AM") : new String(this.endTimeHour - 12 + ":" + minute + " PM")));
        return result;
    }

    public int getEndTimeMinute() {
        return this.endTimeMinute;
    }

    public String getType() {
        return this.type;
    }

    public String getStartDayName() {
        return this.startDayName;
    }

    public String getEndDayName() {
        return this.endDayName;
    }

    public CommunicationsPreference() throws SQLException {
    }

    public CommunicationsPreference(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public CommunicationsPreference(Connection db, String id) throws SQLException {
        this.queryRecord(db, Integer.parseInt(id));
    }

    public CommunicationsPreference(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public void queryRecord(Connection db, int preferenceId) throws SQLException {
        if (preferenceId == -1) {
            throw new SQLException("Invalid Preference ID.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT cp.* FROM communication_preference cp LEFT JOIN contact ct ON (cp.contact_id = ct.contact_id) WHERE cp.preference_id = ? ");
        pst.setInt(1, preferenceId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Communications Preference not found.");
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("preference_id"));
        this.setContactId(DatabaseUtils.getInt(rs, "contact_id"));
        this.setTypeId(DatabaseUtils.getInt(rs, "type_id"));
        this.setStartDay(DatabaseUtils.getInt(rs, "start_day"));
        this.setEndDay(DatabaseUtils.getInt(rs, "end_day"));
        this.setStartTimeHour(DatabaseUtils.getInt(rs, "start_time_hr"));
        this.setStartTimeMinute(DatabaseUtils.getInt(rs, "start_time_min"));
        this.setEndTimeHour(DatabaseUtils.getInt(rs, "end_time_hr"));
        this.setEndTimeMinute(DatabaseUtils.getInt(rs, "end_time_min"));
        this.setEntered(rs.getTimestamp("entered"));
        this.setModified(rs.getTimestamp("modified"));
        this.setEnteredBy(rs.getInt("enteredBy"));
        this.setModifiedBy(rs.getInt("modifiedBy"));
        this.setEnabled(rs.getBoolean("enabled"));
        this.setLevel(rs.getInt("level"));
        this.setTimeZone(rs.getString("time_zone"));
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "communication_preference_preference_id_seq");
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO communication_preference (" + (this.id > -1 ? "preference_id, " : "") + "contact_id, type_id, " + DatabaseUtils.addQuotes(db, "level") + ", time_zone ");
        if (this.startDay != -1) {
            sql.append(", start_day ");
        }
        if (this.endDay != -1) {
            sql.append(", end_day ");
        }
        if (this.startTimeHour != -1) {
            sql.append(", start_time_hr ");
        }
        if (this.startTimeMinute != -1) {
            sql.append(", start_time_min ");
        }
        if (this.endTimeHour != -1) {
            sql.append(", end_time_hr ");
        }
        if (this.endTimeMinute != -1) {
            sql.append(", end_time_min ");
        }
        if (this.entered != null) {
            sql.append(", entered ");
        }
        sql.append(", enteredby ");
        if (this.modified != null) {
            sql.append(", modified ");
        }
        sql.append(", modifiedby , enabled ) VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ? ");
        if (this.startDay != -1) {
            sql.append(", ? ");
        }
        if (this.endDay != -1) {
            sql.append(", ? ");
        }
        if (this.startTimeHour != -1) {
            sql.append(", ? ");
        }
        if (this.startTimeMinute != -1) {
            sql.append(", ? ");
        }
        if (this.endTimeHour != -1) {
            sql.append(", ? ");
        }
        if (this.endTimeMinute != -1) {
            sql.append(", ? ");
        }
        if (this.entered != null) {
            sql.append(", ? ");
        }
        sql.append(", ? ");
        if (this.modified != null) {
            sql.append(", ? ");
        }
        sql.append(", ?, ?)");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        DatabaseUtils.setInt(pst, ++i, this.getContactId());
        pst.setInt(++i, this.getTypeId());
        DatabaseUtils.setInt(pst, ++i, this.getLevel());
        pst.setString(++i, this.timeZone);
        if (this.startDay != -1) {
            DatabaseUtils.setInt(pst, ++i, this.getStartDay());
        }
        if (this.endDay != -1) {
            DatabaseUtils.setInt(pst, ++i, this.getEndDay());
        }
        if (this.startTimeHour != -1) {
            DatabaseUtils.setInt(pst, ++i, this.getStartTimeHour());
        }
        if (this.startTimeMinute != -1) {
            DatabaseUtils.setInt(pst, ++i, this.getStartTimeMinute());
        }
        if (this.endTimeHour != -1) {
            DatabaseUtils.setInt(pst, ++i, this.getEndTimeHour());
        }
        if (this.endTimeMinute != -1) {
            DatabaseUtils.setInt(pst, ++i, this.getEndTimeMinute());
        }
        if (this.entered != null) {
            pst.setTimestamp(++i, this.getEntered());
        }
        pst.setInt(++i, this.getEnteredBy());
        if (this.modified != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        pst.setInt(++i, this.getModifiedBy());
        pst.setBoolean(++i, this.getEnabled());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "communication_preference_preference_id_seq", this.id);
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = db.prepareStatement("DELETE FROM communication_preference WHERE preference_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public static String getDayOfWeek(int day) {
        String result = "";
        switch (day) {
            case 2: {
                result = "Mon";
                break;
            }
            case 3: {
                result = "Tue";
                break;
            }
            case 4: {
                result = "Wed";
                break;
            }
            case 5: {
                result = "Thu";
                break;
            }
            case 6: {
                result = "Fri";
                break;
            }
            case 7: {
                result = "Sat";
                break;
            }
            case 1: {
                result = "Sun";
                break;
            }
            default: {
                result = "NONE";
            }
        }
        return result;
    }

    public static String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect currentList = new HtmlSelect();
        currentList.addItem(2, "Monday");
        currentList.addItem(3, "Tuesday");
        currentList.addItem(4, "Wednesday");
        currentList.addItem(5, "Thursday");
        currentList.addItem(6, "Friday");
        currentList.addItem(7, "Saturday");
        currentList.addItem(1, "Sunday");
        return currentList.getHtml(selectName, defaultKey);
    }

    public static String getHtmlSelectLevel(String selectName, int defaultKey, int lowestLevel) {
        HtmlSelect currentList = new HtmlSelect();
        for (int i = 1; i <= lowestLevel; ++i) {
            currentList.addItem(i, "preference " + i);
        }
        return currentList.getHtml(selectName, defaultKey);
    }
}

