/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.communications.base.CommunicationsPreference;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class CommunicationsPreferenceList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int contactId = -1;
    private int typeId = -1;
    private int startDay = -1;
    private int endDay = -1;
    private int startTimeHour = -1;
    private int startTimeMinute = -1;
    private int endTimeHour = -1;
    private int endTimeMinute = -1;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private int enabled = -1;
    private int level = -1;
    private String timeZone = null;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public void setTypeId(int tmp) {
        this.typeId = tmp;
    }

    public void setTypeId(String tmp) {
        this.typeId = Integer.parseInt(tmp);
    }

    public void setStartDay(int tmp) {
        this.startDay = tmp;
    }

    public void setStartDay(String tmp) {
        this.startDay = Integer.parseInt(tmp);
    }

    public void setEndDay(int tmp) {
        this.endDay = tmp;
    }

    public void setEndDay(String tmp) {
        this.endDay = Integer.parseInt(tmp);
    }

    public void setStartTimeHour(int tmp) {
        this.startTimeHour = tmp;
    }

    public void setStartTimeHour(String tmp) {
        this.startTimeHour = Integer.parseInt(tmp);
    }

    public void setStartTimeMinute(int tmp) {
        this.startTimeMinute = tmp;
    }

    public void setStartTimeMinute(String tmp) {
        this.startTimeMinute = Integer.parseInt(tmp);
    }

    public void setEndTimeHour(int tmp) {
        this.endTimeHour = tmp;
    }

    public void setEndTimeHour(String tmp) {
        this.endTimeHour = Integer.parseInt(tmp);
    }

    public void setEndTimeMinute(int tmp) {
        this.endTimeMinute = tmp;
    }

    public void setEndTimeMinute(String tmp) {
        this.endTimeMinute = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public void setTimeZone(String tmp) {
        this.timeZone = tmp;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public int getLevel() {
        return this.level;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getId() {
        return this.id;
    }

    public int getContactId() {
        return this.contactId;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public int getStartDay() {
        return this.startDay;
    }

    public int getEndDay() {
        return this.endDay;
    }

    public int getStartTimeHour() {
        return this.startTimeHour;
    }

    public int getStartTimeMinute() {
        return this.startTimeMinute;
    }

    public int getEndTimeHour() {
        return this.endTimeHour;
    }

    public int getEndTimeMinute() {
        return this.endTimeMinute;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM communication_preference cp  LEFT JOIN contact ct ON (cp.contact_id = ct.contact_id)  WHERE cp.preference_id > -1 ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
                items = this.prepareFilter(pst);
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("cp." + DatabaseUtils.addQuotes(db, "level") + "", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY cp." + DatabaseUtils.addQuotes(db, "level") + "");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append(" cp.*  FROM communication_preference cp  LEFT JOIN contact ct ON (cp.contact_id = ct.contact_id)  WHERE cp.preference_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            CommunicationsPreference thisPreference = new CommunicationsPreference(rs);
            this.add(thisPreference);
        }
        rs.close();
        pst.close();
    }

    protected void createFilter(Connection db, StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.contactId > -1) {
            sqlFilter.append("AND cp.contact_id = ? ");
        }
        if (this.typeId != -1) {
            sqlFilter.append("AND cp.type_id = ? ");
        }
        if (this.startDay != -1) {
            sqlFilter.append("AND cp.start_day = ? ");
        }
        if (this.endDay != -1) {
            sqlFilter.append("AND cp.end_day = ? ");
        }
        if (this.startTimeHour != -1) {
            sqlFilter.append("AND cp.start_time_hr = ? ");
        }
        if (this.startTimeMinute != -1) {
            sqlFilter.append("AND cp.start_time_min = ? ");
        }
        if (this.endTimeHour != -1) {
            sqlFilter.append("AND cp.end_time_hr = ? ");
        }
        if (this.endTimeMinute != -1) {
            sqlFilter.append("AND cp.end_time_min = ? ");
        }
        if (this.entered != null) {
            sqlFilter.append("AND cp.entered = ? ");
        }
        if (this.enteredBy != -1) {
            sqlFilter.append("AND cp.enteredby = ? ");
        }
        if (this.modified != null) {
            sqlFilter.append("AND cp.modified = ? ");
        }
        if (this.modifiedBy != -1) {
            sqlFilter.append("AND cp.modifiedby = ? ");
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND cp.enabled = ? ");
        }
        if (this.level != -1) {
            sqlFilter.append("AND cp." + DatabaseUtils.addQuotes(db, "level") + " = ? ");
        }
        if (this.timeZone != null) {
            sqlFilter.append("AND cp.time_zone = ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.contactId > -1) {
            pst.setInt(++i, this.contactId);
        }
        if (this.typeId != -1) {
            pst.setInt(++i, this.getTypeId());
        }
        if (this.startDay != -1) {
            pst.setInt(++i, this.getStartDay());
        }
        if (this.endDay != -1) {
            pst.setInt(++i, this.getEndDay());
        }
        if (this.startTimeHour != -1) {
            pst.setInt(++i, this.getStartTimeHour());
        }
        if (this.startTimeMinute != -1) {
            pst.setInt(++i, this.getStartTimeMinute());
        }
        if (this.endTimeHour != -1) {
            pst.setInt(++i, this.getEndTimeHour());
        }
        if (this.endTimeMinute != -1) {
            pst.setInt(++i, this.getEndTimeMinute());
        }
        if (this.entered != null) {
            pst.setTimestamp(++i, this.getEntered());
        }
        if (this.enteredBy != -1) {
            pst.setInt(++i, this.getEnteredBy());
        }
        if (this.modified != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        if (this.modifiedBy != -1) {
            pst.setInt(++i, this.getModifiedBy());
        }
        if (this.enabled == 1) {
            pst.setBoolean(++i, true);
        } else if (this.enabled == 0) {
            pst.setBoolean(++i, false);
        }
        if (this.level != -1) {
            pst.setInt(++i, this.getLevel());
        }
        if (this.timeZone != null) {
            pst.setString(++i, this.getTimeZone());
        }
        return i;
    }
}

