/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.communications.base.Message;
import org.aspcfs.utils.DatabaseUtils;

public class ContactMessage
extends GenericBean {
    private int id = -1;
    private int messageId = -1;
    private Timestamp receivedDate = null;
    private int receivedFrom = -1;
    private int receivedBy = -1;
    private Message contactMessage = null;
    private boolean buildMessage = false;

    public Message getContactMessage() {
        return this.contactMessage;
    }

    public void setContactMessage(Message tmp) {
        this.contactMessage = tmp;
    }

    public boolean getBuildMessage() {
        return this.buildMessage;
    }

    public void setBuildMessage(boolean tmp) {
        this.buildMessage = tmp;
    }

    public void setBuildMessage(String tmp) {
        this.buildMessage = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getMessageId() {
        return this.messageId;
    }

    public void setMessageId(int tmp) {
        this.messageId = tmp;
    }

    public void setMessageId(String tmp) {
        this.messageId = Integer.parseInt(tmp);
    }

    public Timestamp getReceivedDate() {
        return this.receivedDate;
    }

    public void setReceivedDate(Timestamp tmp) {
        this.receivedDate = tmp;
    }

    public void setReceivedDate(String tmp) {
        this.receivedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getReceivedFrom() {
        return this.receivedFrom;
    }

    public void setReceivedFrom(int tmp) {
        this.receivedFrom = tmp;
    }

    public void setReceivedFrom(String tmp) {
        this.receivedFrom = Integer.parseInt(tmp);
    }

    public int getReceivedBy() {
        return this.receivedBy;
    }

    public void setReceivedBy(int tmp) {
        this.receivedBy = tmp;
    }

    public void setReceivedBy(String tmp) {
        this.receivedBy = Integer.parseInt(tmp);
    }

    public ContactMessage() {
    }

    public ContactMessage(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public ContactMessage(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Contact Message ID.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT cm.* FROM contact_message cm LEFT JOIN " + DatabaseUtils.addQuotes(db, "message") + " m ON (cm.message_id = m.id) " + "LEFT JOIN contact ct_rf ON (cm.received_from = ct_rf.contact_id) " + "LEFT JOIN contact ct_rb ON (cm.received_by = ct_rb.user_id) " + "WHERE cm.id = ? ");
        pst.setInt(1, this.messageId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("Contact Message not found.");
        }
        if (this.buildMessage) {
            this.buildMessage(db);
        }
    }

    public static ArrayList getUserIdParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("receivedBy");
        return thisList;
    }

    public void buildMessage(Connection db) throws SQLException {
        if (this.messageId > -1) {
            this.contactMessage = new Message(db, this.messageId);
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("id"));
        this.messageId = rs.getInt("message_id");
        this.receivedDate = rs.getTimestamp("received_date");
        this.receivedFrom = rs.getInt("received_from");
        this.receivedBy = rs.getInt("received_by");
    }

    public boolean insert(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("INSERT INTO contact_message (message_id, received_date, received_from, received_by) VALUES (?, ?, ?, ? ) ");
        int i = 0;
        pst.setInt(++i, this.messageId);
        pst.setTimestamp(++i, this.receivedDate);
        pst.setInt(++i, this.receivedFrom);
        pst.setInt(++i, this.receivedBy);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "contact_message_id_seq", this.id);
        return true;
    }
}

