/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.modules.communications.base.ContactMessage;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class ContactMessageList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int receivedBy = -1;
    private int receivedFrom = -1;
    private String receivedByRange = null;
    private boolean buildMessage = false;

    public boolean getBuildMessage() {
        return this.buildMessage;
    }

    public void setBuildMessage(boolean tmp) {
        this.buildMessage = tmp;
    }

    public void setBuildMessage(String tmp) {
        this.buildMessage = DatabaseUtils.parseBoolean(tmp);
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public int getReceivedBy() {
        return this.receivedBy;
    }

    public void setReceivedBy(int tmp) {
        this.receivedBy = tmp;
    }

    public void setReceivedBy(String tmp) {
        this.receivedBy = Integer.parseInt(tmp);
    }

    public int getReceivedFrom() {
        return this.receivedFrom;
    }

    public void setReceivedFrom(int tmp) {
        this.receivedFrom = tmp;
    }

    public void setReceivedFrom(String tmp) {
        this.receivedFrom = Integer.parseInt(tmp);
    }

    public String getReceivedByRange() {
        return this.receivedByRange;
    }

    public void setReceivedByRange(String tmp) {
        this.receivedByRange = tmp;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM contact_message cm LEFT JOIN " + DatabaseUtils.addQuotes(db, "message") + " m ON (cm.message_id = m.id) " + "LEFT JOIN contact ct_rf ON (cm.received_from = ct_rf.contact_id) " + "LEFT JOIN contact ct_rb ON (cm.received_by = ct_rb.user_id) " + "WHERE cm.id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(name) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("name", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY name ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("cm.* FROM contact_message cm LEFT JOIN " + DatabaseUtils.addQuotes(db, "message") + " m ON (cm.message_id = m.id) " + "LEFT JOIN contact ct_rf ON (cm.received_from = ct_rf.contact_id) " + "LEFT JOIN contact ct_rb ON (cm.received_by = ct_rb.user_id) " + "WHERE cm.id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            ContactMessage thisMessage = new ContactMessage(rs);
            this.add(thisMessage);
        }
        rs.close();
        pst.close();
        if (this.buildMessage) {
            for (ContactMessage thisMessage : this) {
                thisMessage.buildMessage(db);
            }
        }
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.receivedBy != -1) {
            sqlFilter.append("AND cm.received_by = ? ");
        }
        if (this.receivedFrom != -1) {
            sqlFilter.append("AND cm.received_from = ? ");
        }
        if (this.receivedByRange != null) {
            sqlFilter.append("AND cm.received_by IN (" + this.receivedByRange + ") ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.receivedBy != -1) {
            pst.setInt(++i, this.receivedBy);
        }
        if (this.receivedFrom != -1) {
            pst.setInt(++i, this.receivedFrom);
        }
        return i;
    }
}

