/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import org.aspcfs.modules.communications.base.Campaign;
import org.aspcfs.modules.communications.base.Message;
import org.aspcfs.modules.communications.base.MessageAttachment;
import org.aspcfs.modules.communications.base.MessageAttachmentList;
import org.aspcfs.modules.communications.base.Recipient;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.Template;

public class InstantCampaign
extends Campaign {
    private Message instantMessage = null;
    private ContactList recipients = null;
    private MessageAttachmentList messageAttachments = null;

    public MessageAttachmentList getAttachmentList() {
        return this.messageAttachments;
    }

    public void setAttachmentList(MessageAttachmentList tmp) {
        this.messageAttachments = tmp;
    }

    public void setAttachmentList(String[] params) {
        if (params != null) {
            this.messageAttachments = new MessageAttachmentList();
            for (int i = 0; i < Arrays.asList(params).size(); ++i) {
                int fileId = Integer.parseInt(Arrays.asList(params).get(i));
                this.messageAttachments.addItem(fileId);
            }
        } else {
            this.messageAttachments = new MessageAttachmentList();
        }
    }

    public void setMessage(Message instantMessage) {
        this.instantMessage = instantMessage;
    }

    public void setRecipients(ContactList recipients) {
        this.recipients = recipients;
    }

    public ContactList getRecipients() {
        return this.recipients;
    }

    public Message getInstantMessage() {
        return this.instantMessage;
    }

    public void addRecipient(Connection db, int contactId) throws SQLException {
        if (this.recipients == null) {
            this.recipients = new ContactList();
        }
        this.recipients.add(new Contact(db, contactId));
    }

    public boolean activate(Connection db) throws SQLException {
        int resultCount = 0;
        PreparedStatement pst = null;
        try {
            db.setAutoCommit(false);
            Template template = new Template();
            template.setText(this.instantMessage.getMessageText());
            template.setParseElements(this.instantMessage.getParseElements());
            Date dtNow = new Date();
            Timestamp today = new Timestamp(dtNow.getTime());
            this.setMessageId(this.instantMessage.getId());
            this.setReplyTo(this.instantMessage.getReplyTo());
            this.setSubject(this.instantMessage.getMessageSubject());
            this.setMessage(template.getParsedText());
            this.setSendMethodId(1);
            this.setActiveDate(today);
            this.setType(2);
            this.insert(db);
            for (MessageAttachment thisAttachment : this.messageAttachments) {
                thisAttachment.setLinkModuleId(508200600);
                thisAttachment.setLinkItemId(this.getId());
                thisAttachment.buildFileItems(db, true);
                thisAttachment.insert(db);
            }
            pst = db.prepareStatement("UPDATE campaign SET status_id = ?, status = ?, modifiedby = ?, modified = CURRENT_TIMESTAMP WHERE campaign_id = ? ");
            int i = 0;
            pst.setInt(++i, 2);
            pst.setString(++i, "In Queue");
            pst.setInt(++i, this.getModifiedBy());
            pst.setInt(++i, this.getId());
            resultCount = pst.executeUpdate();
            pst.close();
            if (resultCount == 1) {
                this.setActive(true);
                for (Contact thisContact : this.recipients) {
                    Recipient thisRecipient = new Recipient();
                    thisRecipient.setCampaignId(this.getId());
                    thisRecipient.setContactId(thisContact.getId());
                    thisRecipient.insert(db);
                }
                pst = db.prepareStatement("UPDATE campaign SET " + DatabaseUtils.addQuotes(db, "active") + " = ?, " + "reply_addr = ?, " + "subject = ?, " + DatabaseUtils.addQuotes(db, "message") + " = ?, " + "modifiedby = ?, " + "modified = CURRENT_TIMESTAMP " + "WHERE campaign_id = ? ");
                i = 0;
                pst.setBoolean(++i, true);
                pst.setString(++i, this.instantMessage.getReplyTo());
                pst.setString(++i, this.instantMessage.getMessageSubject());
                pst.setString(++i, template.getParsedText());
                pst.setInt(++i, this.getModifiedBy());
                pst.setInt(++i, this.getId());
                resultCount = pst.executeUpdate();
                pst.close();
                db.commit();
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        catch (Exception ee) {
            db.rollback();
            throw new SQLException(ee.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
    }

    public int updateInstantCampaignMessage(Connection db, Message tmpMessage) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE campaign SET " + DatabaseUtils.addQuotes(db, "message") + " = ? " + "WHERE campaign_id = ? ");
        int i = 0;
        pst.setString(++i, tmpMessage.getMessageText());
        pst.setInt(++i, this.getId());
        int resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }
}

