/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class Item {
    private int id = -1;
    private String description = null;
    private int questionId = -1;
    private int type = -1;

    public Item() {
    }

    public Item(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setQuestionId(int tmp) {
        this.questionId = tmp;
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public int getQuestionId() {
        return this.questionId;
    }

    public int getType() {
        return this.type;
    }

    public void setQuestionId(String tmp) {
        this.questionId = Integer.parseInt(tmp);
    }

    public void setType(String tmp) {
        this.type = Integer.parseInt(tmp);
    }

    public void insert(Connection db) throws SQLException {
        this.insert(db, this.questionId);
    }

    public void insert(Connection db, int qid) throws SQLException {
        if (qid == -1) {
            throw new SQLException("Question ID not specified");
        }
        boolean doCommit = db.getAutoCommit();
        try {
            if (doCommit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "survey_items_item_id_seq");
            PreparedStatement pst = db.prepareStatement("INSERT INTO survey_items (" + (this.id > -1 ? "item_id, " : "") + "question_id, " + DatabaseUtils.addQuotes(db, "type") + ", description ) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?) ");
            int i = 0;
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, qid);
            pst.setInt(++i, this.getType());
            pst.setString(++i, this.getDescription());
            pst.execute();
            pst.close();
            this.setId(DatabaseUtils.getCurrVal(db, "survey_items_item_id_seq", this.id));
            if (doCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
    }

    public int update(Connection db, int qId) throws SQLException {
        int count = 0;
        boolean doCommit = db.getAutoCommit();
        try {
            if (doCommit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = db.prepareStatement("UPDATE survey_items SET description = ? WHERE question_id = ? ");
            int i = 0;
            pst.setString(++i, this.description);
            pst.setInt(++i, qId);
            count = pst.executeUpdate();
            pst.close();
            if (doCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return count;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("item_id");
        this.questionId = rs.getInt("question_id");
        this.type = rs.getInt("type");
        this.description = rs.getString("description");
    }
}

