/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.communications.base.MessageAttachment;
import org.aspcfs.modules.communications.base.MessageAttachmentList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;

public class Message
extends GenericBean {
    private int id = -1;
    private String name = "";
    private String description = "";
    private int templateId = -1;
    private String replyTo = "";
    private String messageSubject = "";
    private String messageText = "";
    private String url = "";
    private String image = "";
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private Timestamp modified = null;
    private Timestamp entered = null;
    private boolean enabled = true;
    private boolean formatLineFeeds = true;
    private int accessType = -1;
    private boolean disableNameValidation = false;
    private int inactiveCount = -1;
    private HashMap parseElements = new HashMap();
    private MessageAttachmentList messageAttachments = new MessageAttachmentList();
    private ArrayList attachmentList = new ArrayList();
    private boolean buildAttachments = true;
    public static final String tableName = "message";
    public static final String uniqueField = "id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;

    public HashMap getParseElements() {
        return this.parseElements;
    }

    public void setParseElements(HashMap tmp) {
        this.parseElements = tmp;
    }

    public Message() {
    }

    public Message(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public Message(Connection db, String messageId) throws SQLException {
        this.queryRecord(db, Integer.parseInt(messageId));
    }

    public Message(Connection db, int messageId) throws SQLException {
        this.queryRecord(db, messageId);
    }

    public void queryRecord(Connection db, int messageId) throws SQLException {
        if (messageId == -1) {
            throw new SQLException("Invalid Message ID.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT m.* FROM " + DatabaseUtils.addQuotes(db, tableName) + " m " + "LEFT JOIN contact ct_eb ON (m.enteredby = ct_eb.user_id) " + "LEFT JOIN contact ct_mb ON (m.modifiedby = ct_mb.user_id) " + "WHERE m.id = ? ");
        pst.setInt(1, messageId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Message not found.");
        }
        if (this.buildAttachments) {
            this.buildAttachments(db);
        }
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.setId(Integer.parseInt(tmp));
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setAccessType(int accessType) {
        this.accessType = accessType;
    }

    public void setAccessType(String accessType) {
        this.accessType = Integer.parseInt(accessType);
    }

    public void setDisableNameValidation(boolean tmp) {
        this.disableNameValidation = tmp;
    }

    public void setDisableNameValidation(String tmp) {
        this.disableNameValidation = DatabaseUtils.parseBoolean(tmp);
    }

    public void setInactiveCount(int tmp) {
        this.inactiveCount = tmp;
    }

    public void setInactiveCount(String tmp) {
        this.inactiveCount = Integer.parseInt(tmp);
    }

    public int getInactiveCount() {
        return this.inactiveCount;
    }

    public void setBuildAttachments(boolean tmp) {
        this.buildAttachments = tmp;
    }

    public void setBuildAttachments(String tmp) {
        this.buildAttachments = Boolean.getBoolean(tmp);
    }

    public boolean getBuildAttachments() {
        return this.buildAttachments;
    }

    public boolean getDisableNameValidation() {
        return this.disableNameValidation;
    }

    public int getAccessType() {
        return this.accessType;
    }

    public String getAccessTypeString() {
        return String.valueOf(this.accessType);
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setTemplateId(int tmp) {
        this.templateId = tmp;
    }

    public void setTemplateId(String tmp) {
        this.setTemplateId(Integer.parseInt(tmp));
    }

    public void setMessageSubject(String tmp) {
        this.messageSubject = tmp;
    }

    public void setMessageText(String tmp) {
        this.messageText = tmp;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public void setReplyTo(String tmp) {
        this.replyTo = tmp;
    }

    public void setUrl(String tmp) {
        this.url = tmp;
    }

    public void setImage(String tmp) {
        this.image = tmp;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public void setModified(String tmp) {
        this.modified = DateUtils.parseTimestampString(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setFormatLineFeeds(boolean tmp) {
        this.formatLineFeeds = tmp;
    }

    public void setFormatLineFeeds(String tmp) {
        this.formatLineFeeds = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getTemplateId() {
        return this.templateId;
    }

    public String getMessageSubject() {
        return this.messageSubject;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public String getUrl() {
        return this.url;
    }

    public String getImage() {
        return this.image;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public String getEnteredString() {
        try {
            return DateFormat.getDateInstance(3).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getEnteredDateTimeString() {
        try {
            return DateFormat.getDateTimeInstance(3, 3).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getModifiedString() {
        try {
            return DateFormat.getDateInstance(3).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getModifiedDateTimeString() {
        try {
            return DateFormat.getDateTimeInstance(3, 3).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public String getOwnerString() {
        return String.valueOf(this.enteredBy);
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean getFormatLineFeeds() {
        return this.formatLineFeeds;
    }

    public void addParseElement(String key, int value) {
        this.addParseElement(key, String.valueOf(value));
    }

    public void addParseElement(String key, String value) {
        if (this.parseElements == null) {
            this.parseElements = new HashMap();
        }
        if (value != null) {
            this.parseElements.put(key, value);
        }
    }

    public void setAttachmentList(ArrayList attachmentList) {
        this.attachmentList = attachmentList;
    }

    public ArrayList getAttachmentList() {
        return this.attachmentList;
    }

    public void setAttachmentList(String[] criteriaString) {
        if (criteriaString != null) {
            this.messageAttachments = new MessageAttachmentList();
            for (int i = 0; i < Arrays.asList(criteriaString).size(); ++i) {
                int fileId = Integer.parseInt(Arrays.asList(criteriaString).get(i));
                this.messageAttachments.addItem(fileId);
            }
        } else {
            this.messageAttachments = new MessageAttachmentList();
        }
    }

    public void setAttachmentsList(Connection db, String[] params) throws SQLException {
        if (params != null) {
            this.messageAttachments = new MessageAttachmentList();
            for (int i = 0; i < Arrays.asList(params).size(); ++i) {
                int fileId = Integer.parseInt(Arrays.asList(params).get(i));
                this.messageAttachments.addItem(fileId);
            }
        } else {
            this.messageAttachments = new MessageAttachmentList();
        }
    }

    public MessageAttachmentList getMessageAttachments() {
        return this.messageAttachments;
    }

    public void setMessageAttachments(MessageAttachmentList attachments) {
        this.messageAttachments = attachments;
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "message_id_seq");
            sql.append("INSERT INTO " + DatabaseUtils.addQuotes(db, tableName) + " " + "(name, access_type, ");
            if (this.id > -1) {
                sql.append("id, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            if (this.modified != null) {
                sql.append("modified, ");
            }
            sql.append("enteredBy, modifiedBy ) ");
            sql.append("VALUES (?, ?, ");
            if (this.id > -1) {
                sql.append("?,");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            if (this.modified != null) {
                sql.append("?, ");
            }
            sql.append("?, ?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            pst.setString(++i, this.getName());
            pst.setInt(++i, this.getAccessType());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            if (this.modified != null) {
                pst.setTimestamp(++i, this.modified);
            }
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "message_id_seq", this.id);
            this.update(db, true);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            resultCount = this.update(db, false);
            if (commit) {
                db.commit();
            }
        }
        catch (Exception e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return resultCount;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean commit = true;
        Statement st = null;
        ResultSet rs = null;
        try {
            commit = db.getAutoCommit();
            this.inactiveCount = 0;
            st = db.createStatement();
            rs = st.executeQuery("SELECT COUNT(*) AS message_count FROM campaign WHERE message_id = " + this.getId() + " " + "AND status_id <> " + 4);
            rs.next();
            this.inactiveCount = rs.getInt("message_count");
            rs.close();
            if (this.inactiveCount > 0) {
                st.close();
                boolean bl = false;
                return bl;
            }
            if (commit) {
                db.setAutoCommit(false);
            }
            st.executeUpdate("DELETE FROM contact_message WHERE message_id = " + this.getId());
            MessageAttachmentList attachmentList = new MessageAttachmentList();
            attachmentList.delete(db, 100120070, this.getId());
            st.executeUpdate("DELETE FROM " + DatabaseUtils.addQuotes(db, tableName) + " WHERE id = " + this.getId());
            st.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.toString());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        ResultSet rs = null;
        String sql = "";
        DependencyList dependencyList = new DependencyList();
        try {
            int msgcount;
            db.setAutoCommit(false);
            sql = "SELECT COUNT(*) AS message_count FROM campaign WHERE message_id = ? AND status_id <> 4 ";
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql);
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (msgcount = rs.getInt("message_count")) != 0) {
                Dependency thisDependency = new Dependency();
                thisDependency.setName("campaigns");
                thisDependency.setCount(msgcount);
                thisDependency.setCanDelete(true);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return dependencyList;
    }

    protected int update(Connection db, boolean override) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            throw new SQLException("Message ID was not specified");
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + DatabaseUtils.addQuotes(db, tableName) + " " + "SET name=?, description = ?, template_id = ?, subject = ?, " + "body = ?, reply_addr = ?, url = ?, img = ?, access_type = ?, " + "enabled = ?, ");
        if (!override) {
            sql.append("modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", ");
        }
        sql.append("modifiedby = ? WHERE id = ? ");
        if (!override) {
            sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        }
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.getName());
        pst.setString(++i, this.getDescription());
        pst.setInt(++i, this.getTemplateId());
        pst.setString(++i, this.getMessageSubject());
        pst.setString(++i, this.getMessageText());
        pst.setString(++i, this.getReplyTo());
        pst.setString(++i, this.getUrl());
        pst.setString(++i, this.getImage());
        pst.setInt(++i, this.getAccessType());
        pst.setBoolean(++i, this.getEnabled());
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getId());
        if (!override && this.getModified() != null) {
            pst.setTimestamp(++i, this.modified);
        }
        resultCount = pst.executeUpdate();
        pst.close();
        MessageAttachmentList oldAttachmentList = new MessageAttachmentList();
        oldAttachmentList.delete(db, 100120070, this.getId());
        for (MessageAttachment thisAttachment : this.messageAttachments) {
            thisAttachment.setLinkModuleId(100120070);
            thisAttachment.setLinkItemId(this.getId());
            thisAttachment.buildFileItems(db, true);
            thisAttachment.insert(db);
        }
        return resultCount;
    }

    public static ArrayList getUserIdParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("enteredBy");
        thisList.add("modifiedBy");
        return thisList;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt(uniqueField));
        this.name = rs.getString("name");
        this.description = rs.getString("description");
        this.templateId = rs.getInt("template_id");
        this.messageSubject = rs.getString("subject");
        if (rs.wasNull()) {
            this.messageSubject = "(no subject)";
        }
        this.messageText = rs.getString("body");
        this.replyTo = rs.getString("reply_addr");
        this.url = rs.getString("url");
        this.image = rs.getString("img");
        this.enabled = rs.getBoolean("enabled");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.accessType = rs.getInt("access_type");
    }

    public void buildAttachments(Connection db) throws SQLException {
        this.messageAttachments = new MessageAttachmentList(db, 100120070, this.getId());
        this.attachmentList = new ArrayList();
    }
}

