/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import com.darkhorseventures.framework.beans.GenericBean;
import com.zeroio.iteam.base.FileItem;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class MessageAttachment
extends GenericBean {
    private int id = -1;
    private int linkModuleId = -1;
    private int linkItemId = -1;
    private int fileItemId = -1;
    private String fileName = "";
    private int size = 0;
    private double version = 0.0;
    private FileItem fileItem = null;
    private boolean buildFileItem = true;

    public MessageAttachment() {
    }

    public MessageAttachment(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public MessageAttachment(Connection db, String messageAttachmentId) throws SQLException {
        this.queryRecord(db, Integer.parseInt(messageAttachmentId));
    }

    public MessageAttachment(Connection db, int messageAttachmentId) throws SQLException {
        this.queryRecord(db, messageAttachmentId);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.setId(Integer.parseInt(tmp));
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkModuleId(String tmp) {
        this.setLinkModuleId(Integer.parseInt(tmp));
    }

    public int getLinkItemId() {
        return this.linkItemId;
    }

    public void setLinkItemId(int tmp) {
        this.linkItemId = tmp;
    }

    public void setLinkItemId(String tmp) {
        this.setLinkItemId(Integer.parseInt(tmp));
    }

    public int getFileItemId() {
        return this.fileItemId;
    }

    public void setFileItemId(int tmp) {
        this.fileItemId = tmp;
    }

    public void setFileItemId(String tmp) {
        this.setFileItemId(Integer.parseInt(tmp));
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String tmp) {
        this.fileName = tmp;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int tmp) {
        this.size = tmp;
    }

    public int getRelativeSize() {
        int newSize = this.size / 1000;
        if (newSize == 0) {
            return 1;
        }
        return newSize;
    }

    public double getVersion() {
        return this.version;
    }

    public void setVersion(double tmp) {
        this.version = tmp;
    }

    public FileItem getFileItem() {
        return this.fileItem;
    }

    public void setFileItem(FileItem tmp) {
        this.fileItem = tmp;
    }

    public void setBuildFileItem(boolean tmp) {
        this.buildFileItem = tmp;
    }

    public boolean getFileExists() {
        boolean result = false;
        if (this.fileItem != null && this.fileItemId > 0) {
            result = true;
        }
        return result;
    }

    public void queryRecord(Connection db, int messageAttachmentId) throws SQLException {
        if (messageAttachmentId == -1) {
            throw new SQLException("Invalid MessageAttachment ID.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT mfa.* FROM message_file_attachment mfaWHERE mfa.id = ? ");
        pst.setInt(1, messageAttachmentId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("MessageAttachment not found.");
        }
        if (this.buildFileItem) {
            this.buildFileItems(db, false);
        }
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "message_file_attachment_attachment_id_seq");
            sql.append("INSERT INTO message_file_attachment (link_module_id, link_item_id, file_item_id, filename, " + (this.id > -1 ? "attachment_id, " : "") + DatabaseUtils.addQuotes(db, "size") + ", " + DatabaseUtils.addQuotes(db, "version") + ") ");
            sql.append("VALUES (?, ?, ?, ?, " + (this.id > -1 ? "?, " : "") + "?, ? )");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            pst.setInt(++i, this.getLinkModuleId());
            pst.setInt(++i, this.getLinkItemId());
            if (this.getFileItemId() != -1) {
                pst.setInt(++i, this.getFileItemId());
            } else {
                pst.setNull(++i, 4);
            }
            pst.setString(++i, this.getFileName());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.getSize());
            pst.setDouble(++i, this.getVersion());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "message_file_attachment_attachment_id_seq", this.id);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            resultCount = this.update(db, false);
            if (commit) {
                db.commit();
            }
        }
        catch (Exception e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return resultCount;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = db.prepareStatement("DELETE FROM message_file_attachment WHERE attachment_id  = ?");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.toString());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    protected int update(Connection db, boolean override) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            throw new SQLException("MessageAttachment ID was not specified");
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE message_file_attachment SET link_module_id=?, link_item_id = ?, file_item_id = ?, filename = ?, size = ?, version = ? ");
        sql.append("WHERE attachment_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.getLinkModuleId());
        pst.setInt(++i, this.getLinkItemId());
        if (this.getFileItemId() != -1) {
            pst.setInt(++i, this.getFileItemId());
        } else {
            pst.setNull(++i, 4);
        }
        pst.setString(++i, this.getFileName());
        pst.setInt(++i, this.getSize());
        pst.setDouble(++i, this.getVersion());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("attachment_id"));
        this.linkModuleId = rs.getInt("link_module_id");
        this.linkItemId = rs.getInt("link_item_id");
        this.fileItemId = rs.getInt("file_item_id");
        if (rs.wasNull()) {
            this.fileItemId = -1;
        }
        this.fileName = rs.getString("filename");
        this.size = rs.getInt("size");
        this.version = rs.getDouble("version");
    }

    protected void buildFileItems(Connection db, boolean resetData) throws SQLException {
        this.fileItem = new FileItem(db, this.fileItemId);
        if (resetData) {
            this.fileName = this.fileItem.getClientFilename();
            this.size = this.fileItem.getSize();
            this.version = this.fileItem.getVersion();
        }
    }
}

