/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.modules.communications.base.MessageAttachment;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class MessageAttachmentList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    public static final String tableName = "message_file_attachment";
    public static final String uniqueField = "attachment_id";
    private int linkModuleId = -1;
    private int linkItemId = -1;

    public MessageAttachmentList() {
    }

    public MessageAttachmentList(Connection db, int linkModuleId, int linkItemId) throws SQLException {
        this.linkModuleId = linkModuleId;
        this.linkItemId = linkItemId;
        this.buildList(db);
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkModuleId(String tmp) {
        this.setLinkModuleId(Integer.parseInt(tmp));
    }

    public int getLinkItemId() {
        return this.linkItemId;
    }

    public void setLinkItemId(int tmp) {
        this.linkItemId = tmp;
    }

    public void setLinkItemId(String tmp) {
        this.setLinkItemId(Integer.parseInt(tmp));
    }

    public void addItem(int fileId) {
        MessageAttachment thisMessageAttachment = new MessageAttachment();
        thisMessageAttachment.setFileItemId(fileId);
        if (this.size() == 0) {
            this.add(thisMessageAttachment);
        } else {
            this.add(0, thisMessageAttachment);
        }
    }

    private void createFilter(Connection db, StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.linkModuleId > -1) {
            sqlFilter.append("AND mfa.link_module_id = ? ");
        }
        if (this.linkItemId > -1) {
            sqlFilter.append("AND mfa.link_item_id = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.linkModuleId > -1) {
            pst.setInt(++i, this.linkModuleId);
        }
        if (this.linkItemId > -1) {
            pst.setInt(++i, this.linkItemId);
        }
        return i;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM message_file_attachment mfa WHERE mfa.attachment_id  > -1 ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(mfa.filename) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("mfa.filename", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY mfa.filename ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("mfa.* FROM message_file_attachment mfa WHERE mfa.attachment_id  > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            MessageAttachment thisAttachment = new MessageAttachment(rs);
            thisAttachment.buildFileItems(db, false);
            this.add(thisAttachment);
        }
        rs.close();
        pst.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Connection db, int linkModuleId, int linkItemId) throws SQLException {
        this.linkModuleId = linkModuleId;
        this.linkItemId = linkItemId;
        PreparedStatement pst = null;
        SQLException message = null;
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            pst = db.prepareStatement("DELETE FROM message_file_attachment WHERE link_module_id = ? and link_item_id = ? ");
            pst.setInt(1, this.getLinkModuleId());
            pst.setInt(2, this.getLinkItemId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            message = e;
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        if (message != null) {
            throw new SQLException(message.getMessage());
        }
        return true;
    }

    public boolean copyTo(Connection db, int toLinkModuleId, int toLinkItemId, boolean remuvOld) throws SQLException {
        SQLException message = null;
        try {
            MessageAttachmentList oldAttachmentList = new MessageAttachmentList();
            oldAttachmentList.delete(db, toLinkModuleId, toLinkItemId);
            for (MessageAttachment thisAttachment : this) {
                MessageAttachment newAttachment = new MessageAttachment();
                newAttachment.setLinkModuleId(toLinkModuleId);
                newAttachment.setLinkItemId(toLinkItemId);
                newAttachment.setFileItemId(thisAttachment.getFileItemId());
                newAttachment.setFileName(thisAttachment.getFileName());
                newAttachment.setSize(thisAttachment.getSize());
                newAttachment.setVersion(thisAttachment.getVersion());
                newAttachment.insert(db);
            }
        }
        catch (SQLException e) {
            message = e;
        }
        if (message != null) {
            throw new SQLException(message.getMessage());
        }
        return true;
    }
}

