/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.communications.base.Message;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class MessageList
extends ArrayList {
    public static final int EXCLUDE_PERSONAL = -1;
    public static final int IGNORE_PERSONAL = -2;
    public static final String tableName = "message";
    public static final String uniqueField = "id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private String name = "";
    private String description = "";
    private int owner = -1;
    private String ownerIdRange = null;
    private String jsEvent = null;
    private boolean allMessages = false;
    private boolean controlledHierarchyOnly = false;
    private int ruleId = -1;
    private int personalId = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setOwner(int tmp) {
        this.owner = tmp;
    }

    public void setOwnerIdRange(String tmp) {
        this.ownerIdRange = tmp;
    }

    public void setJsEvent(String tmp) {
        this.jsEvent = tmp;
    }

    public void setAllMessages(boolean allMessages) {
        this.allMessages = allMessages;
    }

    public void setAllMessages(boolean allMessages, int owner, String ownerIdRange) {
        this.ownerIdRange = ownerIdRange;
        this.allMessages = allMessages;
        this.personalId = owner;
    }

    public void setRuleId(int ruleId) {
        this.ruleId = ruleId;
    }

    public void setControlledHierarchyOnly(boolean controlledHierarchyOnly) {
        this.controlledHierarchyOnly = controlledHierarchyOnly;
    }

    public void setControlledHierarchyOnly(boolean controlledHierarchyOnly, String ownerIdRange) {
        this.controlledHierarchyOnly = controlledHierarchyOnly;
        this.ownerIdRange = ownerIdRange;
    }

    public void setPersonalId(int personalId) {
        this.personalId = personalId;
    }

    public int getPersonalId() {
        return this.personalId;
    }

    public boolean getControlledHierarchyOnly() {
        return this.controlledHierarchyOnly;
    }

    public int getRuleId() {
        return this.ruleId;
    }

    public boolean getAllMessages() {
        return this.allMessages;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHtmlSelect(String selectName) {
        return this.getHtmlSelect(selectName, -1);
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect messageListSelect = new HtmlSelect();
        messageListSelect.setJsEvent(this.jsEvent);
        for (Message thisMessage : this) {
            messageListSelect.addItem(thisMessage.getId(), thisMessage.getName() != null && !"".equals(thisMessage.getName()) ? thisMessage.getName() : "\"Unnamed Message\"");
        }
        return messageListSelect.getHtml(selectName, defaultKey);
    }

    public void addItem(int key, String name) {
        Message thisMessage = new Message();
        thisMessage.setId(key);
        thisMessage.setName(name);
        if (this.size() == 0) {
            this.add(thisMessage);
        } else {
            this.add(0, thisMessage);
        }
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM " + DatabaseUtils.addQuotes(db, tableName) + " m " + "WHERE m.id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(name) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("name", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY name ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("m.* FROM " + DatabaseUtils.addQuotes(db, tableName) + " m " + "LEFT JOIN contact ct_eb ON (m.enteredby = ct_eb.user_id) " + "LEFT JOIN contact ct_mb ON (m.modifiedby = ct_mb.user_id) " + "WHERE m.id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            Message thisMessage = new Message(rs);
            thisMessage.buildAttachments(db);
            this.add(thisMessage);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.owner != -1) {
            sqlFilter.append("AND m.enteredby = ? ");
        }
        if (this.controlledHierarchyOnly) {
            sqlFilter.append("AND m.enteredby IN (" + this.ownerIdRange + ") ");
        }
        if (this.ruleId != -1) {
            sqlFilter.append("AND m.access_type IN (SELECT code from lookup_access_types where rule_id = ? AND code = m.access_type) ");
        }
        if (this.allMessages) {
            sqlFilter.append("AND (m.enteredby IN (" + this.ownerIdRange + ") OR m.access_type IN (SELECT code from lookup_access_types WHERE rule_id = ? AND code = m.access_type)) ");
        }
        switch (this.personalId) {
            case -2: {
                break;
            }
            case -1: {
                sqlFilter.append("AND m.access_type NOT IN (SELECT code from lookup_access_types WHERE rule_id = ? AND code = m.access_type) ");
                break;
            }
            default: {
                sqlFilter.append("AND (m.access_type NOT IN (SELECT code from lookup_access_types WHERE rule_id = ? AND code = m.access_type)  OR (m.access_type IN (SELECT code from lookup_access_types WHERE rule_id = ? AND code = m.access_type) AND m.enteredby = ?)) ");
            }
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.owner != -1) {
            pst.setInt(++i, this.owner);
        }
        if (this.ruleId != -1) {
            pst.setInt(++i, this.ruleId);
        }
        if (this.allMessages) {
            pst.setInt(++i, 626030334);
        }
        switch (this.personalId) {
            case -2: {
                break;
            }
            case -1: {
                pst.setInt(++i, 626030333);
                break;
            }
            default: {
                pst.setInt(++i, 626030333);
                pst.setInt(++i, 626030333);
                pst.setInt(++i, this.personalId);
            }
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public boolean hasId(int messageId) {
        for (Message thisMessage : this) {
            if (thisMessage.getId() != messageId) continue;
            return true;
        }
        return false;
    }
}

