/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.DatabaseUtils;

public class Recipient
extends GenericBean {
    private int id = -1;
    private int campaignId = -1;
    private int contactId = -1;
    private int runId = -1;
    private int statusId = -1;
    private String status = null;
    private Timestamp statusDate = null;
    private Timestamp scheduledDate = null;
    private Timestamp sentDate = null;
    private Timestamp replyDate = null;
    private Timestamp bounceDate = null;
    private Contact contact = null;
    private boolean allowDuplicates = false;

    public Recipient() {
    }

    public Recipient(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public Recipient(Connection db, int recipientId) throws SQLException {
        if (recipientId == -1) {
            throw new SQLException("Recipient ID not specified.");
        }
        String sql = "SELECT * FROM scheduled_recipient r WHERE r.id = ? ";
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, recipientId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Recipient record not found.");
        }
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setCampaignId(int tmp) {
        this.campaignId = tmp;
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public void setRunId(int tmp) {
        this.runId = tmp;
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatus(String tmp) {
        this.status = tmp;
    }

    public void setStatusDate(Timestamp tmp) {
        this.statusDate = tmp;
    }

    public void setScheduledDate(Timestamp tmp) {
        this.scheduledDate = tmp;
    }

    public void setSentDate(Timestamp tmp) {
        this.sentDate = tmp;
    }

    public void setReplyDate(Timestamp tmp) {
        this.replyDate = tmp;
    }

    public void setBounceDate(Timestamp tmp) {
        this.bounceDate = tmp;
    }

    public void setContact(Contact tmp) {
        this.contact = tmp;
    }

    public int getId() {
        return this.id;
    }

    public int getCampaignId() {
        return this.campaignId;
    }

    public int getContactId() {
        return this.contactId;
    }

    public int getRunId() {
        return this.runId;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public String getStatus() {
        return this.status;
    }

    public Timestamp getStatusDate() {
        return this.statusDate;
    }

    public Timestamp getScheduledDate() {
        return this.scheduledDate;
    }

    public Timestamp getSentDate() {
        return this.sentDate;
    }

    public String getSentDateString() {
        try {
            return DateFormat.getDateInstance(3).format(this.sentDate);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public Timestamp getReplyDate() {
        return this.replyDate;
    }

    public String getReplyDateString() {
        try {
            return DateFormat.getDateInstance(3).format(this.replyDate);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public Timestamp getBounceDate() {
        return this.bounceDate;
    }

    public Contact getContact() {
        return this.contact;
    }

    public boolean getAllowDuplicates() {
        return this.allowDuplicates;
    }

    public void setAllowDuplicates(boolean tmp) {
        this.allowDuplicates = tmp;
    }

    public void setAllowDuplicates(String tmp) {
        this.allowDuplicates = DatabaseUtils.parseBoolean(tmp);
    }

    protected boolean isDuplicate(Connection db) throws SQLException {
        if (this.allowDuplicates) {
            return false;
        }
        boolean result = false;
        String sql = "SELECT * FROM scheduled_recipient WHERE campaign_id = ? AND contact_id = ? ";
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(++i, this.campaignId);
        pst.setInt(++i, this.contactId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            result = true;
        }
        rs.close();
        pst.close();
        return result;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.campaignId = rs.getInt("campaign_id");
        this.contactId = rs.getInt("contact_id");
        this.runId = rs.getInt("run_id");
        this.statusId = rs.getInt("status_id");
        this.status = rs.getString("status");
        this.scheduledDate = rs.getTimestamp("scheduled_date");
        this.sentDate = rs.getTimestamp("sent_date");
        this.replyDate = rs.getTimestamp("reply_date");
        this.bounceDate = rs.getTimestamp("bounce_date");
    }

    public boolean insert(Connection db) throws SQLException {
        if (this.isDuplicate(db)) {
            return false;
        }
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "scheduled_recipient_id_seq");
        sql.append("INSERT INTO scheduled_recipient (" + (this.id > -1 ? "id, " : "") + "campaign_id, contact_id) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.campaignId);
        pst.setInt(++i, this.contactId);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "scheduled_recipient_id_seq", this.id);
        return true;
    }

    public int update(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Recipient ID was not specified");
        }
        int resultCount = 0;
        PreparedStatement pst = null;
        String sql = "UPDATE scheduled_recipient SET run_id = ?, status_id = ?, status = ?, status_date = ?, scheduled_date = ?, sent_date = ?, reply_date = ?, bounce_date = ? WHERE id = ? ";
        int i = 0;
        pst = db.prepareStatement(sql);
        pst.setInt(++i, this.runId);
        pst.setInt(++i, this.statusId);
        pst.setString(++i, this.status);
        if (this.statusDate == null) {
            pst.setNull(++i, 91);
        } else {
            pst.setTimestamp(++i, this.statusDate);
        }
        if (this.scheduledDate == null) {
            pst.setNull(++i, 91);
        } else {
            pst.setTimestamp(++i, this.scheduledDate);
        }
        if (this.sentDate == null) {
            pst.setNull(++i, 91);
        } else {
            pst.setTimestamp(++i, this.sentDate);
        }
        if (this.replyDate == null) {
            pst.setNull(++i, 91);
        } else {
            pst.setTimestamp(++i, this.replyDate);
        }
        if (this.bounceDate == null) {
            pst.setNull(++i, 91);
        } else {
            pst.setTimestamp(++i, this.bounceDate);
        }
        pst.setInt(++i, this.id);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean delete(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM scheduled_recipient WHERE id = ?");
        pst.setInt(1, this.id);
        pst.executeUpdate();
        pst.close();
        return true;
    }

    public void buildContact(Connection db) throws SQLException {
        this.contact = new Contact();
        this.contact.setId(this.contactId);
        this.contact.setBuildDetails(true);
        this.contact.build(db);
    }
}

