/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import org.aspcfs.modules.communications.base.Recipient;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class RecipientList
extends Vector {
    private PagedListInfo pagedListInfo = null;
    private int campaignId = -1;
    private int runId = -1;
    private int statusId = -1;
    private Timestamp scheduledDate = null;
    private Timestamp sentDate = null;
    private boolean hasNullSentDate = false;
    private boolean buildContact = false;
    private Timestamp statusRangeStart = null;
    private Timestamp statusRangeEnd = null;
    private String status = null;
    private boolean onlyResponded = false;
    private int surveyId = -1;
    private int contactId = -1;
    private boolean allowDuplicates = false;

    public void setCampaignId(int tmp) {
        this.campaignId = tmp;
    }

    public void setRunId(int tmp) {
        this.runId = tmp;
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setScheduledDate(Timestamp tmp) {
        this.scheduledDate = tmp;
    }

    public void setSentDate(Timestamp tmp) {
        this.sentDate = tmp;
    }

    public void setHasNullSentDate(boolean tmp) {
        this.hasNullSentDate = tmp;
    }

    public void setBuildContact(boolean tmp) {
        this.buildContact = tmp;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setStatusRangeStart(Timestamp tmp) {
        this.statusRangeStart = tmp;
    }

    public void setStatusRangeEnd(Timestamp tmp) {
        this.statusRangeEnd = tmp;
    }

    public void setStatus(String tmp) {
        this.status = tmp;
    }

    public void setOnlyResponded(boolean tmp) {
        this.onlyResponded = tmp;
    }

    public void setOnlyResponded(String tmp) {
        this.onlyResponded = DatabaseUtils.parseBoolean(tmp);
    }

    public void setSurveyId(int tmp) {
        this.surveyId = tmp;
    }

    public void setSurveyId(String tmp) {
        this.surveyId = Integer.parseInt(tmp);
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public int getCampaignId() {
        return this.campaignId;
    }

    public int getRunId() {
        return this.runId;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public Timestamp getScheduledDate() {
        return this.scheduledDate;
    }

    public Timestamp getSentDate() {
        return this.sentDate;
    }

    public boolean getHasNullSentDate() {
        return this.hasNullSentDate;
    }

    public boolean getBuildContact() {
        return this.buildContact;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public boolean getAllowDuplicates() {
        return this.allowDuplicates;
    }

    public void setAllowDuplicates(boolean tmp) {
        this.allowDuplicates = tmp;
    }

    public void setAllowDuplicates(String tmp) {
        this.allowDuplicates = DatabaseUtils.parseBoolean(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM scheduled_recipient r LEFT JOIN contact c ON (r.contact_id = c.contact_id) WHERE r.id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(c.namelast) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("c.namelast", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY c.namelast ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("r.* FROM scheduled_recipient r LEFT JOIN contact c ON (r.contact_id = c.contact_id) WHERE r.id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            Recipient thisRecipient = new Recipient(rs);
            this.addElement(thisRecipient);
        }
        rs.close();
        pst.close();
        if (this.buildContact) {
            for (Recipient thisRecipient : this) {
                thisRecipient.buildContact(db);
            }
        }
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.campaignId > -1) {
            sqlFilter.append("AND campaign_id = ? ");
        }
        if (this.runId > -1) {
            sqlFilter.append("AND run_id = ? ");
        }
        if (this.statusId > -1) {
            sqlFilter.append("AND status_id = ? ");
        }
        if (this.scheduledDate != null) {
            sqlFilter.append("AND scheduled_date = ? ");
        }
        if (this.sentDate != null) {
            sqlFilter.append("AND sent_date = ? ");
        }
        if (this.hasNullSentDate) {
            sqlFilter.append("AND sent_date IS NULL ");
        }
        if (this.statusRangeStart != null) {
            sqlFilter.append("AND status_date >= ? ");
        }
        if (this.statusRangeEnd != null) {
            sqlFilter.append("AND status_date <= ? ");
        }
        if (this.status != null) {
            sqlFilter.append("AND status = ? ");
        }
        if (this.onlyResponded) {
            sqlFilter.append("AND r.contact_id NOT IN (SELECT contact_id FROM active_survey_responses WHERE active_survey_id = ?) ");
        }
        if (this.contactId != -1) {
            sqlFilter.append("AND r.contact_id = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.campaignId > -1) {
            pst.setInt(++i, this.campaignId);
        }
        if (this.runId > -1) {
            pst.setInt(++i, this.runId);
        }
        if (this.statusId > -1) {
            pst.setInt(++i, this.statusId);
        }
        if (this.scheduledDate != null) {
            pst.setTimestamp(++i, this.scheduledDate);
        }
        if (this.sentDate != null) {
            pst.setTimestamp(++i, this.sentDate);
        }
        if (this.statusRangeStart != null) {
            pst.setTimestamp(++i, this.statusRangeStart);
        }
        if (this.statusRangeEnd != null) {
            pst.setTimestamp(++i, this.statusRangeEnd);
        }
        if (this.status != null) {
            pst.setString(++i, this.status);
        }
        if (this.onlyResponded) {
            pst.setInt(++i, this.surveyId);
        }
        if (this.contactId != -1) {
            pst.setInt(++i, this.contactId);
        }
        return i;
    }

    public static int retrieveRecordCount(Connection db, int moduleId, int itemId) throws SQLException {
        ResultSet rs;
        int count = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(" + (moduleId == 2 ? "DISTINCT c.campaign_id" : "*") + ") as itemcount " + "FROM scheduled_recipient s " + (moduleId == 2 ? "LEFT JOIN campaign c ON (s.campaign_id = c.campaign_id) " : " ") + "WHERE id > 0 " + (moduleId == 2 ? "AND c.trashed_date IS NULL " : ""));
        if (moduleId == 2) {
            sql.append("AND s.contact_id = ? ");
        }
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (moduleId == 2) {
            pst.setInt(1, itemId);
        }
        if ((rs = pst.executeQuery()).next()) {
            count = rs.getInt("itemcount");
        }
        rs.close();
        pst.close();
        return count;
    }

    public boolean delete(Connection db) throws SQLException {
        for (Recipient recipient : this) {
            recipient.delete(db);
        }
        return true;
    }

    public int queryRecordCount(Connection db) throws SQLException {
        int recordCount = 0;
        StringBuffer sqlFilter = new StringBuffer();
        String sqlCount = "SELECT COUNT(*) AS recordcount FROM scheduled_recipient r LEFT JOIN contact c ON (r.contact_id = c.contact_id) WHERE r.id > -1 ";
        this.createFilter(sqlFilter);
        PreparedStatement pst = db.prepareStatement(sqlCount + sqlFilter.toString());
        int items = this.prepareFilter(pst);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            recordCount = DatabaseUtils.getInt(rs, "recordcount", 0);
        }
        pst.close();
        rs.close();
        return recordCount;
    }

    public boolean addRecipient(Connection db, String contactId) throws SQLException {
        if (!this.getAllowDuplicates()) {
            for (Recipient recipient : this) {
                if (recipient.getContact().getId() != Integer.parseInt(contactId.trim())) continue;
                return false;
            }
        }
        Recipient recipient = new Recipient();
        recipient.setContactId(contactId);
        recipient.setCampaignId(this.getCampaignId());
        recipient.setAllowDuplicates(this.getAllowDuplicates());
        recipient.insert(db);
        return recipient.getId() != -1;
    }
}

