/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;

public class ScheduledRecipient {
    int id = -1;
    int campaignId = -1;
    int contactId = -1;
    int runId = -1;
    int statusId = 0;
    String status = null;
    Timestamp statusDate = null;
    Timestamp scheduledDate = null;
    Timestamp sentDate = null;
    Timestamp replyDate = null;
    Timestamp bounceDate = null;

    public ScheduledRecipient() {
    }

    public ScheduledRecipient(Connection db, String id) throws SQLException {
        this.queryRecord(db, Integer.parseInt(id));
    }

    public ScheduledRecipient(Connection db, int campaignId, int contactId) throws SQLException {
        this.queryRecord(db, campaignId, contactId);
    }

    public ScheduledRecipient(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setCampaignId(int tmp) {
        this.campaignId = tmp;
    }

    public void setCampaignId(String tmp) {
        this.campaignId = Integer.parseInt(tmp);
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public void setRunId(int tmp) {
        this.runId = tmp;
    }

    public void setRunId(String tmp) {
        this.runId = Integer.parseInt(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setStatus(String tmp) {
        this.status = tmp;
    }

    public void setStatusDate(Timestamp tmp) {
        this.statusDate = tmp;
    }

    public void setStatusDate(String tmp) {
        this.statusDate = DateUtils.parseTimestampString(tmp);
    }

    public void setScheduledDate(Timestamp tmp) {
        this.scheduledDate = tmp;
    }

    public void setScheduledDate(String tmp) {
        this.scheduledDate = DateUtils.parseTimestampString(tmp);
    }

    public void setSentDate(Timestamp tmp) {
        this.sentDate = tmp;
    }

    public void setSentDate(String tmp) {
        this.sentDate = DateUtils.parseTimestampString(tmp);
    }

    public void setReplyDate(Timestamp tmp) {
        this.replyDate = tmp;
    }

    public void setReplyDate(String tmp) {
        this.replyDate = DateUtils.parseTimestampString(tmp);
    }

    public void setBounceDate(Timestamp tmp) {
        this.bounceDate = tmp;
    }

    public void setBounceDate(String tmp) {
        this.bounceDate = DateUtils.parseTimestampString(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getCampaignId() {
        return this.campaignId;
    }

    public int getContactId() {
        return this.contactId;
    }

    public int getRunId() {
        return this.runId;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public String getStatus() {
        return this.status;
    }

    public Timestamp getStatusDate() {
        return this.statusDate;
    }

    public Timestamp getScheduledDate() {
        return this.scheduledDate;
    }

    public Timestamp getSentDate() {
        return this.sentDate;
    }

    public Timestamp getReplyDate() {
        return this.replyDate;
    }

    public Timestamp getBounceDate() {
        return this.bounceDate;
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Scheduled Recipient not found.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT s.* FROM scheduled_recipient s WHERE s.id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("Scheduled Recipient not found.");
        }
    }

    public void queryRecord(Connection db, int campaignId, int contactId) throws SQLException {
        if (campaignId == -1) {
            throw new SQLException("Invalid Campaign ID specified");
        }
        if (contactId == -1) {
            throw new SQLException("Invalid Contact ID specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT s.* FROM scheduled_recipient s WHERE s.campaign_id = ? AND s.contact_id = ? ");
        pst.setInt(1, campaignId);
        pst.setInt(2, contactId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Scheduled Recipient not found.");
        }
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        try {
            db.setAutoCommit(false);
            this.id = DatabaseUtils.getNextSeq(db, "scheduled_recipient_id_seq");
            sql.append("INSERT INTO scheduled_recipient (" + (this.id > -1 ? "id, " : "") + "campaign_id, contact_id, run_id, status_id, status, status_date, scheduled_date, " + "sent_date, reply_date, bounce_date) ");
            sql.append("VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.getCampaignId());
            pst.setInt(++i, this.getContactId());
            DatabaseUtils.setInt(pst, ++i, this.runId);
            pst.setInt(++i, this.getStatusId());
            pst.setString(++i, this.getStatus());
            if (this.statusDate != null) {
                pst.setTimestamp(++i, this.statusDate);
            } else {
                pst.setNull(++i, 93);
            }
            if (this.scheduledDate != null) {
                pst.setTimestamp(++i, this.scheduledDate);
            } else {
                pst.setNull(++i, 93);
            }
            if (this.sentDate != null) {
                pst.setTimestamp(++i, this.sentDate);
            } else {
                pst.setNull(++i, 93);
            }
            if (this.replyDate != null) {
                pst.setTimestamp(++i, this.replyDate);
            } else {
                pst.setNull(++i, 93);
            }
            if (this.bounceDate != null) {
                pst.setTimestamp(++i, this.bounceDate);
            } else {
                pst.setNull(++i, 93);
            }
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "scheduled_recipient_id_seq", this.id);
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int records = -1;
        PreparedStatement pst = db.prepareStatement("UPDATE scheduled_recipient SET run_id = ?, status_id = ?, status = ?, status_date = ?, scheduled_date = ?, sent_date = ?, reply_date = ?, bounce_date = ? WHERE id = ? ");
        int i = 0;
        DatabaseUtils.setInt(pst, ++i, this.runId);
        pst.setInt(++i, this.getStatusId());
        pst.setString(++i, this.getStatus());
        if (this.statusDate != null) {
            pst.setTimestamp(++i, this.statusDate);
        } else {
            pst.setNull(++i, 93);
        }
        if (this.scheduledDate != null) {
            pst.setTimestamp(++i, this.scheduledDate);
        } else {
            pst.setNull(++i, 93);
        }
        if (this.sentDate != null) {
            pst.setTimestamp(++i, this.sentDate);
        } else {
            pst.setNull(++i, 93);
        }
        if (this.replyDate != null) {
            pst.setTimestamp(++i, this.replyDate);
        } else {
            pst.setNull(++i, 93);
        }
        if (this.bounceDate != null) {
            pst.setTimestamp(++i, this.bounceDate);
        } else {
            pst.setNull(++i, 93);
        }
        pst.setInt(++i, this.getId());
        records = pst.executeUpdate();
        pst.close();
        return records;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.campaignId = rs.getInt("campaign_id");
        if (rs.wasNull()) {
            this.campaignId = -1;
        }
        this.contactId = rs.getInt("contact_id");
        if (rs.wasNull()) {
            this.contactId = -1;
        }
        this.runId = rs.getInt("run_id");
        this.statusId = rs.getInt("status_id");
        this.status = rs.getString("status");
        this.statusDate = rs.getTimestamp("status_date");
        this.scheduledDate = rs.getTimestamp("scheduled_date");
        this.sentDate = rs.getTimestamp("sent_date");
        this.replyDate = rs.getTimestamp("reply_date");
        this.bounceDate = rs.getTimestamp("bounce_date");
    }
}

