/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.aspcfs.utils.DatabaseUtils;

public class SearchCriteriaElement {
    int fieldId = -1;
    int operatorId = -1;
    int sourceId = -1;
    int siteId = -1;
    String text = null;
    String operator = null;
    String dataType = null;
    String operatorDisplayText = null;
    String contactTypeName = null;
    String accountTypeName = null;
    String contactNameFirst = null;
    String contactNameLast = null;
    String contactCompany = null;
    protected HashMap errors = new HashMap();
    protected HashMap warnings = new HashMap();
    protected boolean onlyWarnings = false;

    public SearchCriteriaElement() {
    }

    public SearchCriteriaElement(String elementText) {
        StringTokenizer st = new StringTokenizer(elementText, "[*|]");
        if (st.hasMoreTokens()) {
            this.fieldId = Integer.parseInt(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            this.operatorId = Integer.parseInt(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            this.text = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            this.sourceId = Integer.parseInt(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            this.siteId = Integer.parseInt(st.nextToken());
        }
    }

    public SearchCriteriaElement(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setSourceId(int sourceId) {
        this.sourceId = sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = Integer.parseInt(sourceId);
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public void setAccountTypeName(String accountTypeName) {
        this.accountTypeName = accountTypeName;
    }

    public void setContactTypeName(String contactTypeName) {
        this.contactTypeName = contactTypeName;
    }

    public void setContactNameFirst(String tmp) {
        this.contactNameFirst = tmp;
    }

    public void setContactNameLast(String tmp) {
        this.contactNameLast = tmp;
    }

    public void setContactCompany(String tmp) {
        this.contactCompany = tmp;
    }

    public void setFieldId(int fieldId) {
        this.fieldId = fieldId;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setOperatorId(int operatorId) {
        this.operatorId = operatorId;
    }

    public void setOperatorDisplayText(String tmp) {
        this.operatorDisplayText = tmp;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public String getAccountTypeName() {
        return this.accountTypeName;
    }

    public String getContactTypeName() {
        return this.contactTypeName;
    }

    public String getContactNameFirst() {
        return this.contactNameFirst;
    }

    public String getContactNameLast() {
        return this.contactNameLast;
    }

    public String getContactCompany() {
        return this.contactCompany;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getOperatorDisplayText() {
        return this.operatorDisplayText;
    }

    public int getFieldId() {
        return this.fieldId;
    }

    public String getFieldIdAsString() {
        return String.valueOf(this.fieldId);
    }

    public int getOperatorId() {
        return this.operatorId;
    }

    public String getOperatorIdAsString() {
        return String.valueOf(this.operatorId);
    }

    public String getText() {
        return this.text;
    }

    public HashMap getErrors() {
        return this.errors;
    }

    public void setErrors(HashMap tmp) {
        this.errors = tmp;
    }

    public HashMap getWarnings() {
        return this.warnings;
    }

    public void setWarnings(HashMap tmp) {
        this.warnings = tmp;
    }

    public boolean getOnlyWarnings() {
        return this.onlyWarnings;
    }

    public void setOnlyWarnings(boolean tmp) {
        this.onlyWarnings = tmp;
    }

    public void setOnlyWarnings(String tmp) {
        this.onlyWarnings = DatabaseUtils.parseBoolean(tmp);
    }

    public void buildOperatorData(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT * FROM field_types WHERE id = ?");
        pst.setInt(1, this.getOperatorId());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.dataType = rs.getString("data_type");
            this.operator = rs.getString("operator");
            this.operatorDisplayText = rs.getString("display_text");
        }
        rs.close();
        pst.close();
    }

    public boolean insert(int listid, Connection db) throws SQLException {
        this.buildOperatorData(db);
        boolean doCommit = false;
        try {
            doCommit = db.getAutoCommit();
            if (doCommit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = db.prepareStatement("INSERT INTO saved_criteriaelement (id, field, operator, operatorid, " + DatabaseUtils.addQuotes(db, "value") + ", source, value_id, site_id) " + "VALUES (?, ?, ?, ?, ?, ?, ?, ?) ");
            int i = 0;
            pst.setInt(++i, listid);
            pst.setInt(++i, this.getFieldId());
            pst.setString(++i, this.getOperator());
            pst.setInt(++i, this.getOperatorId());
            pst.setString(++i, this.getText());
            pst.setInt(++i, this.getSourceId());
            int valueId = DatabaseUtils.parseInt(this.getText(), -1);
            DatabaseUtils.setInt(pst, ++i, valueId);
            DatabaseUtils.setInt(pst, ++i, this.siteId);
            pst.execute();
            pst.close();
            if (doCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("=[ SearchCriteriaElement ]=====================\r\n");
        tmp.append("FieldId: " + this.fieldId + "\r\n");
        tmp.append("Operator: " + this.operator + "\r\n");
        tmp.append("OperatorId: " + this.operatorId + "\r\n");
        tmp.append("Operator Text: " + this.operatorDisplayText + "\r\n");
        tmp.append("Text: " + this.text + "\r\n");
        tmp.append("Site: " + this.siteId + "\r\n");
        return tmp.toString();
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.fieldId = rs.getInt("field");
        this.operator = rs.getString("operator");
        this.operatorId = rs.getInt("operatorid");
        this.text = rs.getString("value");
        this.sourceId = rs.getInt("source");
        this.siteId = DatabaseUtils.getInt(rs, "site_id");
        this.contactTypeName = rs.getString("ctype");
        this.accountTypeName = rs.getString("atype");
        this.contactNameFirst = rs.getString("cnamefirst");
        this.contactNameLast = rs.getString("cnamelast");
        this.contactCompany = rs.getString("ccompany");
    }
}

