/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.communications.base.SearchCriteriaElement;
import org.aspcfs.modules.communications.base.SearchCriteriaGroup;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupList;

public class SearchCriteriaList
extends HashMap {
    protected HashMap errors = new HashMap();
    protected HashMap warnings = new HashMap();
    private int id = -1;
    private String groupName = "";
    private int contactSource = -1;
    private Timestamp modified = null;
    private Timestamp entered = null;
    private int modifiedBy = -1;
    private int enteredBy = -1;
    private int owner = -1;
    private boolean enabled = true;
    private String ownerIdRange = null;
    private String saveCriteria = "";
    private String htmlSelectIdName = null;
    private boolean onlyContactIds = true;
    public static final int SOURCE_MY_CONTACTS = 1;
    public static final int SOURCE_ALL_CONTACTS = 2;
    public static final int SOURCE_ALL_ACCOUNTS = 3;
    public static final int SOURCE_EMPLOYEES = 4;
    public static final int CONTACT_SOURCE_ELEMENTS = 4;
    private int inactiveCount = -1;
    private LookupList siteList = new LookupList();

    public SearchCriteriaList() {
    }

    public SearchCriteriaList(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public SearchCriteriaList(Connection db, String id) throws SQLException {
        this.queryRecord(db, Integer.parseInt(id));
    }

    public SearchCriteriaList(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public SearchCriteriaList(String searchCriteriaText) {
        SearchCriteriaGroup thisGroup = null;
        StringTokenizer st = new StringTokenizer(searchCriteriaText, "^");
        while (st.hasMoreTokens()) {
            String tmpCriteria = st.nextToken();
            SearchCriteriaElement thisElement = new SearchCriteriaElement(tmpCriteria);
            Integer thisKey = new Integer(thisElement.getFieldId());
            if (thisKey != 9) {
                this.onlyContactIds = false;
            }
            if (this.containsKey(thisKey)) {
                thisGroup = (SearchCriteriaGroup)this.get(thisKey);
            } else {
                thisGroup = new SearchCriteriaGroup();
                thisGroup.getGroupField().setId(thisElement.getFieldId());
                this.put(thisKey, thisGroup);
            }
            thisGroup.add(thisElement);
        }
    }

    public void setOnlyContactIds(boolean onlyContactIds) {
        this.onlyContactIds = onlyContactIds;
    }

    public void setErrors(HashMap errors) {
        this.errors = errors;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setSaveCriteria(String saveCriteria) {
        this.saveCriteria = saveCriteria;
    }

    public void setOwner(int tmp) {
        this.owner = tmp;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setHtmlSelectIdName(String htmlSelectIdName) {
        this.htmlSelectIdName = htmlSelectIdName;
    }

    public void setOwnerIdRange(String tmp) {
        this.ownerIdRange = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public void setModified(String tmp) {
        this.modified = DateUtils.parseTimestampString(tmp);
    }

    public void setOwner(String tmp) {
        this.owner = Integer.parseInt(tmp);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setGroupName(String tmp) {
        this.groupName = tmp;
    }

    public void setContactSource(int tmp) {
        this.contactSource = tmp;
    }

    public void setContactSource(String tmp) {
        this.contactSource = Integer.parseInt(tmp);
    }

    public void setWarnings(HashMap tmp) {
        this.warnings = tmp;
    }

    public void setInactiveCount(int tmp) {
        this.inactiveCount = tmp;
    }

    public void setInactiveCount(String tmp) {
        this.inactiveCount = Integer.parseInt(tmp);
    }

    public int getInactiveCount() {
        return this.inactiveCount;
    }

    public void setSiteList(LookupList tmp) {
        this.siteList = tmp;
    }

    public LookupList getSiteList() {
        return this.siteList;
    }

    public HashMap getWarnings() {
        return this.warnings;
    }

    public boolean getOnlyContactIds() {
        return this.onlyContactIds;
    }

    public String getHtmlSelectIdName() {
        return this.htmlSelectIdName;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public HashMap getErrors() {
        return this.errors;
    }

    public String getSaveCriteria() {
        return this.saveCriteria;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public String getEnteredString() {
        try {
            return DateFormat.getDateInstance(3).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getEnteredDateTimeString() {
        try {
            return DateFormat.getDateTimeInstance(3, 3).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getModifiedString() {
        try {
            return DateFormat.getDateInstance(3).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getModifiedDateTimeString() {
        try {
            return DateFormat.getDateTimeInstance(3, 3).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public int getOwner() {
        return this.owner;
    }

    public int getId() {
        return this.id;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public int getContactSource() {
        return this.contactSource;
    }

    public String getHtmlSelect(String selectName) {
        HtmlSelect selectList = new HtmlSelect();
        selectList.setSelectSize(10);
        if (this.getHtmlSelectIdName() != null) {
            selectList.setIdName(this.getHtmlSelectIdName());
        }
        LinkedHashMap criteriaList = this.getCriteriaTextArray();
        for (String key : criteriaList.keySet()) {
            selectList.addItem(key, (String)criteriaList.get(key));
        }
        return selectList.getHtml(selectName, -1);
    }

    public LinkedHashMap getCriteriaTextArray() {
        String fromString = "";
        LinkedHashMap<String, String> criteriaList = new LinkedHashMap<String, String>();
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            SearchCriteriaGroup thisGroup = (SearchCriteriaGroup)this.get(i.next());
            Iterator j = thisGroup.iterator();
            String valueString = "";
            while (j.hasNext()) {
                SearchCriteriaElement thisElt = (SearchCriteriaElement)j.next();
                String keyString = thisElt.getFieldIdAsString() + "*" + thisElt.getOperatorIdAsString() + "*" + thisElt.getText();
                if (thisElt.getSourceId() > -1) {
                    keyString = keyString + "*" + thisElt.getSourceId();
                    keyString = keyString + "*" + thisElt.getSiteId();
                }
                switch (thisElt.getSourceId()) {
                    case 1: {
                        fromString = "My Contacts";
                        break;
                    }
                    case 2: {
                        fromString = "All Contacts";
                        break;
                    }
                    case 3: {
                        fromString = "Account Contacts";
                        break;
                    }
                    case 4: {
                        fromString = "Employees";
                        break;
                    }
                }
                String site = "";
                if (this.siteList.size() > 0) {
                    site = ", " + this.siteList.getValueFromId(thisElt.getSiteId());
                }
                if (thisGroup.getGroupField().getDescription().equals("Contact Type") && thisElt.getContactTypeName() != null) {
                    valueString = thisGroup.getGroupField().getDescription() + " (" + thisElt.getOperatorDisplayText() + ") " + thisElt.getContactTypeName() + " [" + fromString + site + "]";
                } else if (thisGroup.getGroupField().getDescription().equals("Account Type") && thisElt.getAccountTypeName() != null) {
                    valueString = thisGroup.getGroupField().getDescription() + " (" + thisElt.getOperatorDisplayText() + ") " + thisElt.getAccountTypeName() + " [" + fromString + site + "]";
                } else if (thisGroup.getGroupField().getDescription().equals("Contact ID") && thisElt.getContactNameLast() != null) {
                    valueString = "Contact Name (" + thisElt.getOperatorDisplayText() + ") " + Contact.getNameFirstLastOrCompany(thisElt.getContactNameLast(), thisElt.getContactNameFirst(), thisElt.getContactCompany());
                } else if (thisGroup.getGroupField().getDescription().equals("Site")) {
                    String siteAsFieldValue = this.siteList.getValueFromId(Integer.parseInt(thisElt.getText()));
                    valueString = thisGroup.getGroupField().getDescription() + " (" + thisElt.getOperatorDisplayText() + ") " + siteAsFieldValue + " [" + fromString + "]";
                } else {
                    valueString = thisGroup.getGroupField().getDescription() + " (" + thisElt.getOperatorDisplayText() + ") " + thisElt.getText() + " [" + fromString + site + "]";
                }
                criteriaList.put(keyString, valueString);
            }
        }
        return criteriaList;
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid ID specified.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT scl.* FROM saved_criterialist scl WHERE scl.id > -1 AND scl.id = ?");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        this.buildResources(db);
    }

    public void buildResources(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT s.*, t.description as ctype, t2.description as atype, c.namefirst as cnamefirst, c.namelast as cnamelast, c.company as ccompany FROM saved_criteriaelement s LEFT JOIN lookup_contact_types t ON (s.value_id = t.code) LEFT JOIN lookup_account_types t2 ON (s.value_id = t2.code) LEFT JOIN contact c ON (s.value_id = c.contact_id) WHERE s.id = ? ");
        pst.setInt(1, this.id);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            SearchCriteriaGroup thisGroup = null;
            SearchCriteriaElement thisElement = new SearchCriteriaElement(rs);
            Integer thisKey = new Integer(thisElement.getFieldId());
            if (this.containsKey(thisKey)) {
                thisGroup = (SearchCriteriaGroup)this.get(thisKey);
            } else {
                thisGroup = new SearchCriteriaGroup();
                thisGroup.getGroupField().setId(thisElement.getFieldId());
                this.put(thisKey, thisGroup);
            }
            thisGroup.add(thisElement);
        }
        rs.close();
        pst.close();
        this.buildRelatedResources(db);
    }

    public void buildRelatedResources(Connection db) throws SQLException {
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            SearchCriteriaGroup thisGroup = (SearchCriteriaGroup)this.get(i.next());
            thisGroup.buildFieldData(db);
            for (SearchCriteriaElement thisElt : thisGroup) {
                thisElt.buildOperatorData(db);
            }
        }
    }

    public void clearElements(int listId, Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM saved_criteriaelement where id = ? ");
        pst.setInt(1, listId);
        pst.execute();
        pst.close();
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        boolean doCommit = false;
        try {
            doCommit = db.getAutoCommit();
            if (doCommit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "saved_criterialist_id_seq");
            sql.append("INSERT INTO saved_criterialist ( owner, name, contact_source, ");
            if (this.id > -1) {
                sql.append("id, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            if (this.modified != null) {
                sql.append("modified, ");
            }
            sql.append("enteredBy, modifiedBy ) ");
            sql.append("VALUES (?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?,");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            if (this.modified != null) {
                sql.append("?, ");
            }
            sql.append("?, ?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            pst.setInt(++i, this.getOwner());
            pst.setString(++i, this.getGroupName());
            DatabaseUtils.setInt(pst, ++i, this.getContactSource());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            if (this.modified != null) {
                pst.setTimestamp(++i, this.modified);
            }
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "saved_criterialist_id_seq", this.id);
            this.insertGroups(db);
            if (doCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        try {
            db.setAutoCommit(false);
            resultCount = this.update(db, false);
            db.commit();
        }
        catch (Exception e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return resultCount;
    }

    public int update(Connection db, boolean override) throws SQLException {
        int resultCount = 0;
        this.deleteGroups(db);
        this.insertGroups(db);
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE saved_criterialist SET ");
        if (!override) {
            sql.append("modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", ");
        }
        sql.append("name = ?, contact_source = ?, owner = ? WHERE id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.getGroupName());
        pst.setInt(++i, this.contactSource);
        pst.setInt(++i, this.getOwner());
        pst.setInt(++i, this.id);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        int groupcount;
        DependencyList dependencyList = new DependencyList();
        int i = 0;
        PreparedStatement pst = db.prepareStatement("SELECT COUNT(*) AS group_count FROM campaign WHERE status_id <> 4 AND campaign_id IN (SELECT campaign_id FROM campaign_list_groups WHERE group_id = ?)");
        pst.setInt(++i, this.getId());
        ResultSet rs = pst.executeQuery();
        if (rs.next() && (groupcount = rs.getInt("group_count")) != 0) {
            Dependency thisDependency = new Dependency();
            thisDependency.setName("campaigns");
            thisDependency.setCount(groupcount);
            thisDependency.setCanDelete(true);
            dependencyList.add(thisDependency);
        }
        rs.close();
        pst.close();
        return dependencyList;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean commit = true;
        if (this.getId() == -1) {
            throw new SQLException("GroupID not specified.");
        }
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            commit = db.getAutoCommit();
            this.inactiveCount = 0;
            pst = db.prepareStatement("SELECT COUNT(*) AS group_count FROM campaign WHERE status_id <> ? AND campaign_id IN (SELECT campaign_id FROM campaign_list_groups WHERE group_id = ?) ");
            pst.setInt(1, 4);
            pst.setInt(2, this.getId());
            rs = pst.executeQuery();
            rs.next();
            this.inactiveCount = rs.getInt("group_count");
            rs.close();
            pst.close();
            if (this.inactiveCount > 0) {
                boolean bl = false;
                return bl;
            }
            int activeCount = 0;
            pst = db.prepareStatement("SELECT COUNT(*) AS group_count FROM campaign WHERE " + DatabaseUtils.addQuotes(db, "active") + " = ? " + "AND campaign_id IN (SELECT campaign_id FROM campaign_list_groups WHERE group_id = ?) ");
            pst.setBoolean(1, true);
            pst.setInt(2, this.getId());
            rs = pst.executeQuery();
            rs.next();
            activeCount = rs.getInt("group_count");
            rs.close();
            pst.close();
            if (commit) {
                db.setAutoCommit(false);
            }
            if (activeCount > 0) {
                pst = db.prepareStatement("UPDATE saved_criterialist SET enabled = ? WHERE id = ? AND enabled = ? ");
                pst.setBoolean(1, false);
                pst.setInt(2, this.getId());
                pst.setBoolean(3, true);
                pst.executeUpdate();
                pst.close();
            } else {
                pst = db.prepareStatement("DELETE FROM saved_criteriaelement WHERE id = ? ");
                pst.setInt(1, this.getId());
                pst.execute();
                pst.close();
                pst = db.prepareStatement("DELETE FROM campaign_list_groups WHERE group_id = ? ");
                pst.setInt(1, this.getId());
                pst.execute();
                pst.close();
                pst = db.prepareStatement("DELETE FROM saved_criterialist WHERE id = ? ");
                pst.setInt(1, this.getId());
                pst.execute();
                pst.close();
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.toString());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    protected boolean insertGroups(Connection db) throws SQLException {
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            SearchCriteriaGroup thisGroup = (SearchCriteriaGroup)this.get(i.next());
            for (SearchCriteriaElement thisElt : thisGroup) {
                thisElt.insert(this.getId(), db);
            }
        }
        return true;
    }

    protected boolean deleteGroups(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM saved_criteriaelement WHERE id = ?");
        pst.setInt(1, this.id);
        pst.execute();
        pst.close();
        return true;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("id"));
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.owner = rs.getInt("owner");
        this.groupName = rs.getString("name");
        this.contactSource = DatabaseUtils.getInt(rs, "contact_source");
    }
}

