/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import org.aspcfs.modules.communications.base.SearchCriteriaList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class SearchCriteriaListList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int owner = -1;
    private String ownerIdRange = null;
    private int campaignId = -1;
    private int enabled = 1;
    private boolean buildCriteria = false;
    public static final String tableName = "saved_criterialist";
    public static final String uniqueField = "id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;

    public int getEnabled() {
        return this.enabled;
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setOwner(int tmp) {
        this.owner = tmp;
    }

    public void setOwner(String tmp) {
        this.owner = Integer.parseInt(tmp);
    }

    public void setOwnerIdRange(String tmp) {
        this.ownerIdRange = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setCampaignId(int tmp) {
        this.campaignId = tmp;
    }

    public void setCampaignId(String tmp) {
        this.campaignId = Integer.parseInt(tmp);
    }

    public void setBuildCriteria(boolean tmp) {
        this.buildCriteria = tmp;
    }

    public void setBuildCriteria(String tmp) {
        this.buildCriteria = DatabaseUtils.parseBoolean(tmp);
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getOwner() {
        return this.owner;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM saved_criterialist scl WHERE scl.id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(name) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("name", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY name ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("scl.* FROM saved_criterialist scl WHERE scl.id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            SearchCriteriaList thisList = new SearchCriteriaList(rs);
            this.add(thisList);
        }
        rs.close();
        pst.close();
        if (this.buildCriteria) {
            for (SearchCriteriaList thisList : this) {
                thisList.buildResources(db);
            }
        }
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND enabled = ? ");
        }
        if (this.owner != -1) {
            sqlFilter.append("AND scl.owner = ? ");
        }
        if (this.ownerIdRange != null) {
            sqlFilter.append("AND scl.owner IN (" + this.ownerIdRange + ") ");
        }
        if (this.campaignId != -1) {
            sqlFilter.append("AND id in (SELECT group_id FROM campaign_list_groups WHERE campaign_id = ?) ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.enabled != -1) {
            pst.setBoolean(++i, this.enabled == 1);
        }
        if (this.owner != -1) {
            pst.setInt(++i, this.owner);
        }
        if (this.campaignId != -1) {
            pst.setInt(++i, this.campaignId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public boolean containsItem(SearchCriteriaList listB) {
        for (SearchCriteriaList listA : this) {
            if (listA.getId() != listB.getId()) continue;
            return true;
        }
        return false;
    }

    public void removeItem(SearchCriteriaList listB) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            SearchCriteriaList listA = (SearchCriteriaList)i.next();
            if (listA.getId() != listB.getId()) continue;
            i.remove();
        }
    }
}

