/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class SearchField {
    private int id = -1;
    private String fieldName = "";
    private String description = "";
    private boolean searchable = true;
    private int fieldTypeId = -1;
    private String tableName = "";
    private String objectClass = "";

    public SearchField() {
    }

    public SearchField(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setFieldName(String tmp) {
        this.fieldName = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setSearchable(boolean tmp) {
        this.searchable = tmp;
    }

    public void setSearchable(String tmp) {
        this.searchable = DatabaseUtils.parseBoolean(tmp);
    }

    public void setFieldTypeId(int tmp) {
        this.fieldTypeId = tmp;
    }

    public void setTableName(String tmp) {
        this.tableName = tmp;
    }

    public void setObjectClass(String tmp) {
        this.objectClass = tmp;
    }

    public int getId() {
        return this.id;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getSearchable() {
        return this.searchable;
    }

    public int getFieldTypeId() {
        return this.fieldTypeId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("id"));
        this.fieldName = rs.getString("field");
        this.description = rs.getString("description");
        this.searchable = rs.getBoolean("searchable");
        this.fieldTypeId = rs.getInt("field_typeid");
        this.tableName = rs.getString("table_name");
        this.objectClass = rs.getString("object_class");
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "search_fields_id_seq");
            sql.append("INSERT INTO search_fields (" + (this.id > -1 ? "id, " : "") + "field, description, searchable, field_typeid, table_name, object_class) ");
            sql.append("VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setString(++i, this.fieldName);
            pst.setString(++i, this.description);
            pst.setBoolean(++i, this.searchable);
            pst.setInt(++i, this.fieldTypeId);
            pst.setString(++i, this.tableName);
            pst.setString(++i, this.objectClass);
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "search_fields_id_seq", this.id);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }
}

