/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.communications.base.SurveyBase;
import org.aspcfs.modules.communications.base.SurveyQuestion;
import org.aspcfs.modules.communications.base.SurveyQuestionList;
import org.aspcfs.utils.DatabaseUtils;

public class Survey
extends SurveyBase {
    public static final int INCOMPLETE = 1;
    public static final int COMPLETE = 2;
    protected int id = -1;
    protected SurveyQuestionList questions = new SurveyQuestionList();
    protected int enteredBy = -1;
    protected int modifiedBy = -1;
    protected Timestamp modified = null;
    protected Timestamp entered = null;
    protected boolean enabled = true;
    protected int status = 1;
    private int inactiveCount = -1;
    public HashMap errors = new HashMap();
    public HashMap warnings = new HashMap();

    public Survey() {
    }

    public Survey(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public Survey(Connection db, String surveyId) throws SQLException {
        this.queryRecord(db, Integer.parseInt(surveyId));
    }

    public Survey(Connection db, int surveyId) throws SQLException {
        this.queryRecord(db, surveyId);
    }

    public void queryRecord(Connection db, int surveyId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT s.* FROM survey s WHERE s.survey_id = ? ");
        pst.setInt(1, surveyId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Survey record not found.");
        }
        this.questions.setSurveyId(this.getId());
        this.questions.buildList(db);
    }

    public String getEnteredString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setStatus(String tmp) {
        this.status = Integer.parseInt(tmp);
    }

    public void setRequestItems(HttpServletRequest request) {
        this.questions = new SurveyQuestionList(request);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setInactiveCount(int tmp) {
        this.inactiveCount = tmp;
    }

    public void setInactiveCount(String tmp) {
        this.inactiveCount = Integer.parseInt(tmp);
    }

    public int getInactiveCount() {
        return this.inactiveCount;
    }

    public int getStatus() {
        return this.status;
    }

    public SurveyQuestionList getQuestions() {
        return this.questions;
    }

    public void setQuestions(SurveyQuestionList questions) {
        this.questions = questions;
    }

    public int getId() {
        return this.id;
    }

    public static int getId(Connection db, int campaignId, int surveyType) throws SQLException {
        int surveyId = -1;
        String sql = "SELECT csl.survey_id AS survey_Id FROM campaign_survey_link csl, survey s WHERE campaign_id = ? AND csl.survey_id = s.survey_id AND s." + DatabaseUtils.addQuotes(db, "type") + " = ? ";
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, campaignId);
        pst.setInt(2, surveyType);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            surveyId = rs.getInt("survey_Id");
        }
        rs.close();
        pst.close();
        return surveyId;
    }

    public static void removeLink(Connection db, int campaignId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM campaign_survey_link WHERE campaign_id = ? ");
        pst.setInt(1, campaignId);
        pst.execute();
        pst.close();
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        if (tmp != null) {
            this.modified = Timestamp.valueOf(tmp);
        }
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public String getEnteredDateTimeString() {
        try {
            return DateFormat.getDateTimeInstance(3, 3).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String printHidden(HttpServletRequest request) {
        StringBuffer result = new StringBuffer();
        if (request != null) {
            Enumeration e = request.getParameterNames();
            ArrayList<String> params = new ArrayList<String>();
            Field[] f = ((Object)((Object)this)).getClass().getFields();
            for (int i = 0; i < f.length; ++i) {
                params.add(f[i].getName());
            }
            while (e.hasMoreElements()) {
                String tempString = e.nextElement().toString();
                String[] parameterValues = request.getParameterValues(tempString);
                if (!params.contains(tempString)) continue;
                result.append("<input type=\"hidden\" name=\"" + tempString + "\" value=\"" + parameterValues[0] + "\">\n");
            }
        }
        return result.toString();
    }

    public String getModifiedString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getModifiedDateTimeString() {
        try {
            return DateFormat.getDateTimeInstance(3, 3).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public HashMap getErrors() {
        return this.errors;
    }

    public void setErrors(HashMap tmp) {
        this.errors = tmp;
    }

    public HashMap getWarnings() {
        return this.warnings;
    }

    public void setWarnings(HashMap tmp) {
        this.warnings = tmp;
    }

    public boolean insert(Connection db) throws SQLException {
        boolean doCommit = false;
        try {
            doCommit = db.getAutoCommit();
            if (doCommit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "survey_survey_id_seq");
            String sql = "INSERT INTO survey (" + (this.id > -1 ? "survey_id, " : "") + "name, description, intro, outro, itemLength, " + DatabaseUtils.addQuotes(db, "type") + ", status, enteredBy, modifiedBy) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?, ?, ?) ";
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql);
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setString(++i, this.name);
            pst.setString(++i, this.description);
            pst.setString(++i, this.intro);
            pst.setString(++i, this.outro);
            pst.setInt(++i, this.itemLength);
            pst.setInt(++i, 1);
            pst.setInt(++i, this.status);
            pst.setInt(++i, this.enteredBy);
            pst.setInt(++i, this.enteredBy);
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "survey_survey_id_seq", this.id);
            for (SurveyQuestion thisQuestion : this.questions) {
                thisQuestion.process(db, this.getId());
            }
            if (doCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean commit = true;
        Statement st = null;
        ResultSet rs = null;
        try {
            commit = db.getAutoCommit();
            this.inactiveCount = 0;
            st = db.createStatement();
            rs = st.executeQuery("SELECT COUNT(*) AS survey_count FROM campaign_survey_link WHERE survey_id = " + this.getId());
            rs.next();
            this.inactiveCount = rs.getInt("survey_count");
            rs.close();
            if (this.inactiveCount > 0) {
                st.close();
                boolean bl = false;
                return bl;
            }
            if (commit) {
                db.setAutoCommit(false);
            }
            for (SurveyQuestion thisQuestion : this.questions) {
                thisQuestion.delete(db, this.getId());
            }
            st.executeUpdate("DELETE FROM survey_questions WHERE survey_id = " + this.getId());
            st.executeUpdate("DELETE FROM survey WHERE survey_id = " + this.getId());
            st.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.toString());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            throw new SQLException("Survey ID was not specified");
        }
        boolean doCommit = db.getAutoCommit();
        try {
            if (doCommit) {
                db.setAutoCommit(false);
            }
            this.questions.process(db, this.getId());
            PreparedStatement pst = null;
            String sql = "UPDATE survey SET name = ?, description = ?, intro = ?, outro = ?, itemlength = ?, " + DatabaseUtils.addQuotes(db, "type") + " = ?, " + "enabled = ?, " + "modified = CURRENT_TIMESTAMP, modifiedby = ? " + "WHERE survey_id = ? AND modified " + (this.getModified() == null ? "IS NULL " : "= ? ");
            int i = 0;
            pst = db.prepareStatement(sql.toString());
            pst.setString(++i, this.getName());
            pst.setString(++i, this.getDescription());
            pst.setString(++i, this.getIntro());
            pst.setString(++i, this.getOutro());
            pst.setInt(++i, this.getItemLength());
            pst.setInt(++i, 1);
            pst.setBoolean(++i, this.getEnabled());
            pst.setInt(++i, this.getModifiedBy());
            pst.setInt(++i, this.getId());
            if (this.getModified() != null) {
                pst.setTimestamp(++i, this.modified);
            }
            resultCount = pst.executeUpdate();
            pst.close();
            if (doCommit) {
                db.commit();
            }
        }
        catch (Exception e) {
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return resultCount;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        ResultSet rs = null;
        String sql = null;
        DependencyList dependencyList = new DependencyList();
        try {
            int surveycount;
            db.setAutoCommit(false);
            sql = "SELECT COUNT(*) AS survey_count FROM campaign_survey_link WHERE survey_id = ? ";
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql);
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (surveycount = rs.getInt("survey_count")) != 0) {
                Dependency thisDependency = new Dependency();
                thisDependency.setName("campaigns");
                thisDependency.setCount(surveycount);
                thisDependency.setCanDelete(true);
                dependencyList.add(thisDependency);
            }
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return dependencyList;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("survey_id"));
        this.name = rs.getString("name");
        this.description = rs.getString("description");
        this.intro = rs.getString("intro");
        this.outro = rs.getString("outro");
        this.itemLength = rs.getInt("itemlength");
        this.type = rs.getInt("type");
        this.enabled = rs.getBoolean("enabled");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
    }

    public static int getAddressSurveyId(Connection db) throws SQLException {
        int addressSurveyId = -1;
        PreparedStatement pst = db.prepareStatement("SELECT survey_id FROM survey WHERE " + DatabaseUtils.addQuotes(db, "type") + " = ? ");
        pst.setInt(1, 2);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            addressSurveyId = rs.getInt("survey_id");
        }
        rs.close();
        pst.close();
        return addressSurveyId;
    }
}

