/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.communications.base.SurveyAnswerItem;
import org.aspcfs.utils.DatabaseUtils;

public class SurveyAnswer {
    private int id = -1;
    private int questionId = -1;
    private int quantAns = -1;
    private int responseId = -1;
    private int contactId = -1;
    private ArrayList itemList = null;
    private String comments = null;
    private String textAns = null;
    private Timestamp entered = null;

    public void setResponseId(String tmp) {
        this.responseId = Integer.parseInt(tmp);
    }

    public SurveyAnswer() {
    }

    public SurveyAnswer(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public SurveyAnswer(Connection db, int passedId) throws SQLException {
        if (passedId < 1) {
            throw new SQLException("Question ID not specified.");
        }
        PreparedStatement pst = null;
        ResultSet rs = null;
        String sql = "SELECT * FROM active_survey_answers s WHERE answer_id = ? ";
        pst = db.prepareStatement(sql);
        pst.setInt(1, passedId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Question Answer record not found.");
        }
        this.buildItems(db, passedId);
    }

    public void buildRecord(HttpServletRequest request, int parseItem) {
        String question = "quest" + parseItem;
        this.setQuestionId(request.getParameter(question + "id"));
        if (request.getParameter(question + "comments") != null) {
            this.setComments(request.getParameter(question + "comments"));
        }
        if (request.getParameter(question + "qans") != null) {
            this.setQuantAns(request.getParameter(question + "qans"));
        }
        if (request.getParameter(question + "text") != null) {
            this.setTextAns(request.getParameter(question + "text"));
        }
        if (request.getParameter(question + "itemCount") != null) {
            int i = 0;
            int itemCount = Integer.parseInt(request.getParameter(question + "itemCount"));
            for (int j = 0; j < itemCount; ++j) {
                if (request.getParameter(question + "item" + ++i) == null) continue;
                if (this.itemList == null) {
                    this.itemList = new ArrayList();
                }
                SurveyAnswerItem thisItem = new SurveyAnswerItem();
                thisItem.buildRecord(request, question + "item" + i);
                this.itemList.add(thisItem);
                if (System.getProperty("DEBUG") == null) continue;
                System.out.println("Added an item: " + thisItem.getId());
            }
        }
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setEntered(Timestamp entered) {
        this.entered = entered;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getId() {
        return this.id;
    }

    public int getResponseId() {
        return this.responseId;
    }

    public void setResponseId(int responseId) {
        this.responseId = responseId;
    }

    public void setContactId(int contactId) {
        this.contactId = contactId;
    }

    public void setItemList(ArrayList itemList) {
        this.itemList = itemList;
    }

    public ArrayList getItemList() {
        return this.itemList;
    }

    public int getContactId() {
        return this.contactId;
    }

    public void setId(String id) {
        this.id = Integer.parseInt(id);
    }

    public int getQuestionId() {
        return this.questionId;
    }

    public String getComments() {
        return this.comments;
    }

    public int getQuantAns() {
        return this.quantAns;
    }

    public String getTextAns() {
        return this.textAns;
    }

    public void setQuestionId(int tmp) {
        this.questionId = tmp;
    }

    public void setComments(String tmp) {
        this.comments = tmp;
    }

    public void setQuantAns(int tmp) {
        this.quantAns = tmp;
    }

    public void setTextAns(String tmp) {
        this.textAns = tmp;
    }

    public void setQuestionId(String tmp) {
        this.questionId = Integer.parseInt(tmp);
    }

    public void setQuantAns(String tmp) {
        this.quantAns = Integer.parseInt(tmp);
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("answer_id"));
        this.setResponseId(rs.getInt("response_id"));
        this.setQuestionId(rs.getInt("question_id"));
        this.setComments(rs.getString("comments"));
        this.setQuantAns(rs.getInt("quant_ans"));
        this.setTextAns(rs.getString("text_ans"));
        this.setEntered(rs.getTimestamp("entered"));
    }

    public void buildItems(Connection db, int thisAnswerId) throws SQLException {
        try {
            PreparedStatement pst = db.prepareStatement("SELECT * FROM active_survey_answer_items t WHERE t.answer_id = ? ");
            pst.setInt(1, thisAnswerId);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                if (this.itemList == null) {
                    this.itemList = new ArrayList();
                }
                SurveyAnswerItem thisAnswerItem = new SurveyAnswerItem();
                thisAnswerItem.buildRecord(rs);
                this.itemList.add(thisAnswerItem);
            }
            rs.close();
            pst.close();
            if (this.itemList != null) {
                for (SurveyAnswerItem thisItem : this.itemList) {
                    thisItem.buildItemDetails(db);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public void setContactId(Connection db) throws SQLException {
        try {
            PreparedStatement pst = db.prepareStatement("SELECT sr.contact_id as contactid FROM active_survey_answers sa, active_survey_responses sr WHERE sa.answer_id = ? AND (sa.response_id = sr.response_id) ");
            pst.setInt(1, this.getId());
            ResultSet rs = pst.executeQuery();
            if (rs.next()) {
                this.setContactId(rs.getInt("contactid"));
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public boolean insert(Connection db) throws SQLException {
        return this.insert(db, this.responseId);
    }

    public boolean insert(Connection db, int responseId) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "active_survey_ans_answer_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO active_survey_answers (" + (this.id > -1 ? "answer_id, " : "") + "response_id, question_id, comments, quant_ans, text_ans) " + "VALUES " + "(" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, responseId);
        pst.setInt(++i, this.questionId);
        pst.setString(++i, this.comments);
        pst.setInt(++i, this.quantAns);
        pst.setString(++i, this.textAns);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "active_survey_ans_answer_id_seq", this.id);
        if (this.itemList != null) {
            this.insertItemList(db, this.id);
        }
        if (this.quantAns > -1) {
            this.updateSurveyAverage(db);
            this.updateAnswerTotal(db);
        }
        return true;
    }

    private void insertItemList(Connection db, int thisId) throws SQLException {
        if (thisId == -1) {
            throw new SQLException("Answer ID not specified.");
        }
        for (SurveyAnswerItem thisItem : this.itemList) {
            thisItem.insert(db, thisId, this.getQuestionId());
        }
    }

    private int updateSurveyAverage(Connection db) throws SQLException {
        if (this.questionId == -1) {
            throw new SQLException("Question ID not specified.");
        }
        double thisAverage = 0.0;
        PreparedStatement pst = null;
        ResultSet rs = null;
        String sql = "SELECT avg(quant_ans) as av FROM active_survey_answers s WHERE question_id = ? AND quant_ans > 0";
        pst = db.prepareStatement(sql);
        pst.setInt(1, this.getQuestionId());
        rs = pst.executeQuery();
        if (rs.next()) {
            thisAverage = rs.getDouble("av");
        }
        rs.close();
        pst.close();
        pst = db.prepareStatement("UPDATE active_survey_questions SET average = ? WHERE question_id = ? ");
        int i = 0;
        pst.setDouble(++i, thisAverage);
        pst.setInt(++i, this.getQuestionId());
        pst.execute();
        pst.close();
        return 1;
    }

    private boolean updateAnswerTotal(Connection db) throws SQLException {
        PreparedStatement pst = null;
        String sql = "UPDATE active_survey_questions SET total" + this.getQuantAns() + " = total" + this.getQuantAns() + " + 1 " + "WHERE question_id = ? ";
        pst = db.prepareStatement(sql);
        pst.setInt(1, this.getQuestionId());
        pst.execute();
        pst.close();
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Answer ID not specified");
        }
        int i = 0;
        PreparedStatement pst = null;
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            pst = db.prepareStatement("DELETE FROM active_survey_answer_items WHERE answer_id = ? ");
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM active_survey_answers WHERE answer_id = ? ");
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }
}

