/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.communications.base.ActiveSurveyQuestionItem;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.DatabaseUtils;

public class SurveyAnswerItem {
    private int id = -1;
    private int answerId = -1;
    private int contactId = -1;
    private String comments = null;
    private Contact recipient = null;
    private Timestamp entered = null;
    private ActiveSurveyQuestionItem item = null;

    public SurveyAnswerItem() {
    }

    public SurveyAnswerItem(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void buildRecord(HttpServletRequest request, String parseItem) {
        if (request.getParameter(parseItem + "id") != null) {
            this.setId(request.getParameter(parseItem + "id"));
        }
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setAnswerId(int answerId) {
        this.answerId = answerId;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void setItem(ActiveSurveyQuestionItem item) {
        this.item = item;
    }

    public void setEntered(Timestamp entered) {
        this.entered = entered;
    }

    public void setRecipient(Contact recipient) {
        this.recipient = recipient;
    }

    public void setContactId(int contactId) {
        this.contactId = contactId;
    }

    public int getContactId() {
        return this.contactId;
    }

    public Contact getRecipient() {
        return this.recipient;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public ActiveSurveyQuestionItem getItem() {
        return this.item;
    }

    public String getComments() {
        return this.comments;
    }

    public int getAnswerId() {
        return this.answerId;
    }

    public int getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = Integer.parseInt(id);
    }

    public void buildItemDetails(Connection db) throws SQLException {
        if (this.id < 1) {
            throw new SQLException("Answer ID not specified.");
        }
        this.item = new ActiveSurveyQuestionItem(db, this.id);
    }

    public void buildContactDetails(Connection db) throws SQLException {
        if (this.contactId == -1) {
            throw new SQLException("Contact ID not specified");
        }
        this.recipient = new Contact(db, this.contactId);
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("item_id"));
        this.setAnswerId(rs.getInt("answer_id"));
        this.setComments(rs.getString("comments"));
    }

    public void buildDetailedRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("item_id"));
        this.setAnswerId(rs.getInt("answer_id"));
        this.setComments(rs.getString("comments"));
        this.setContactId(rs.getInt("contact_id"));
        this.setEntered(rs.getTimestamp("entered"));
    }

    public SurveyAnswerItem(Connection db, int passedId) throws SQLException {
        if (passedId < 1) {
            throw new SQLException("Answer ID not specified.");
        }
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement("SELECT * FROM active_survey_answer_items s WHERE answer_id = ? ");
        pst.setInt(1, passedId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Survey Answer Item record not found.");
        }
    }

    public boolean insert(Connection db, int thisAnswerId, int questionId) throws SQLException {
        if (thisAnswerId == -1) {
            throw new SQLException("Answer ID not specified");
        }
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            int seqId = DatabaseUtils.getNextSeq(db, "active_survey_answer_ite_id_seq");
            PreparedStatement pst = db.prepareStatement("INSERT INTO active_survey_answer_items (" + (seqId > -1 ? "id, " : "") + "item_id, answer_id, comments) " + "VALUES " + "(" + (seqId > -1 ? "?, " : "") + "?, ?, ?) ");
            int i = 0;
            if (seqId > -1) {
                pst.setInt(++i, seqId);
            }
            pst.setInt(++i, this.getId());
            pst.setInt(++i, thisAnswerId);
            pst.setString(++i, this.comments);
            pst.execute();
            pst.close();
            this.updateSurveyAverage(db, questionId);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    private int updateSurveyAverage(Connection db, int questionId) throws SQLException {
        if (questionId == -1) {
            throw new SQLException("Question ID not specified.");
        }
        int count = 0;
        int i = 0;
        PreparedStatement pst = null;
        i = 0;
        pst = db.prepareStatement("UPDATE active_survey_answer_avg SET total = total + 1 WHERE question_id = ? AND item_id =? ");
        pst.setInt(++i, questionId);
        pst.setInt(++i, this.getId());
        count = pst.executeUpdate();
        pst.close();
        return count;
    }
}

