/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.communications.base.SurveyAnswer;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.web.PagedListInfo;

public class SurveyAnswerList
extends Vector {
    public static final String tableName = "active_survey_answers";
    public static final String uniqueField = "answer_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private int questionId = -1;
    private int hasComments = -1;
    private int responseId = -1;
    private int contactId = -1;
    private boolean lastAnswers = false;
    private int itemsPerPage = 10;
    private HashMap contacts = null;
    protected PagedListInfo pagedListInfo = null;

    public SurveyAnswerList() {
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public SurveyAnswerList(Connection db, int questionId) throws SQLException {
        this.questionId = questionId;
        this.buildList(db);
    }

    public SurveyAnswerList(HttpServletRequest request) {
        int i = 0;
        while (request.getParameter("quest" + ++i + "id") != null) {
            SurveyAnswer thisAnswer = new SurveyAnswer();
            thisAnswer.buildRecord(request, i);
            this.addElement(thisAnswer);
            if (System.getProperty("DEBUG") == null) continue;
            System.out.println("Added an answer: " + thisAnswer.getQuestionId());
        }
    }

    public int getQuestionId() {
        return this.questionId;
    }

    public void setQuestionId(int questionId) {
        this.questionId = questionId;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setHasComments(int tmp) {
        this.hasComments = tmp;
    }

    public void setLastAnswers(boolean lastAnswers) {
        this.lastAnswers = lastAnswers;
    }

    public void setItemsPerPage(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    public void setContacts(HashMap contacts) {
        this.contacts = contacts;
    }

    public void setResponseId(int responseId) {
        this.responseId = responseId;
    }

    public void setContactId(int contactId) {
        this.contactId = contactId;
    }

    public int getContactId() {
        return this.contactId;
    }

    public int getResponseId() {
        return this.responseId;
    }

    public HashMap getContacts() {
        return this.contacts;
    }

    public int getHasComments() {
        return this.hasComments;
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            SurveyAnswer thisAnswer = new SurveyAnswer(rs);
            this.add(thisAnswer);
            if (this.contacts == null) {
                this.contacts = new HashMap();
            }
            String contactName = Contact.getNameLastFirst(rs.getString("lastname"), rs.getString("firstname"));
            this.contacts.put(new Integer(rs.getInt("contactid")), contactName);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
        for (SurveyAnswer thisAnswer : this) {
            thisAnswer.setContactId(db);
            thisAnswer.buildItems(db, thisAnswer.getId());
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM active_survey_answers sa, active_survey_responses sr WHERE sa.question_id > -1 AND sa.response_id = sr.response_id ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo == null && this.lastAnswers) {
            this.pagedListInfo = new PagedListInfo();
            this.pagedListInfo.setItemsPerPage(this.itemsPerPage);
        }
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            if (this.pagedListInfo != null) {
                this.pagedListInfo.doManualOffset(db, pst);
            }
            if ((rs = pst.executeQuery()).next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND sa.comments < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                if (this.pagedListInfo != null) {
                    this.pagedListInfo.doManualOffset(db, pst);
                }
                if ((rs = pst.executeQuery()).next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("sr.entered DESC", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY sa.response_id, sa.question_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("sa.*, c.namelast as lastname, c.namefirst as firstname, c.contact_id as contactid, sr.entered as entered FROM active_survey_answers sa, active_survey_responses sr LEFT JOIN contact c ON (c.contact_id = sr.contact_id) WHERE sa.question_id > -1 AND sa.response_id = sr.response_id ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        return rs;
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.questionId != -1) {
            sqlFilter.append("AND sa.question_id = ? ");
        }
        if (this.responseId != -1) {
            sqlFilter.append("AND sr.response_id = ? ");
        }
        if (this.contactId != -1) {
            sqlFilter.append("AND sr.contact_id = ? ");
        }
        if (this.hasComments > -1) {
            if (this.hasComments == 1) {
                sqlFilter.append("AND sa.comments NOT LIKE '' ");
            } else {
                sqlFilter.append("AND sa.comments LIKE '' ");
            }
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.questionId != -1) {
            pst.setInt(++i, this.questionId);
        }
        if (this.responseId != -1) {
            pst.setInt(++i, this.responseId);
        }
        if (this.contactId != -1) {
            pst.setInt(++i, this.contactId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public boolean insert(Connection db, int responseId) throws SQLException {
        for (SurveyAnswer thisAnswer : this) {
            thisAnswer.insert(db, responseId);
        }
        return true;
    }
}

