/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import org.aspcfs.modules.communications.base.Survey;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class SurveyList
extends Vector {
    public static final String tableName = "survey";
    public static final String uniqueField = "survey_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int itemLength = -1;
    private int type = -1;
    private int enteredBy = -1;
    private String enteredByIdRange = null;
    private String jsEvent = null;
    private int enabled = 1;

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM survey s WHERE s.survey_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(s.name) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("s.name", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY s.name ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("s.* FROM survey s WHERE s.survey_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            Survey thisSurvey = new Survey(rs);
            this.addElement(thisSurvey);
        }
        rs.close();
        pst.close();
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getItemLength() {
        return this.itemLength;
    }

    public int getType() {
        return this.type;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setItemLength(int tmp) {
        this.itemLength = tmp;
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredByIdRange(String tmp) {
        this.enteredByIdRange = tmp;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public String getEnteredByIdRange() {
        return this.enteredByIdRange;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public String getJsEvent() {
        return this.jsEvent;
    }

    public void setJsEvent(String jsEvent) {
        this.jsEvent = jsEvent;
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.enteredBy != -1) {
            sqlFilter.append("AND s.enteredby = ? ");
        }
        if (this.enteredByIdRange != null) {
            sqlFilter.append("AND s.enteredby IN (" + this.enteredByIdRange + ") ");
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND s.enabled = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.enteredBy != -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (this.enabled != -1) {
            if (this.enabled == 0) {
                pst.setBoolean(++i, false);
            } else {
                pst.setBoolean(++i, true);
            }
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect surveyListSelect = new HtmlSelect();
        surveyListSelect.setJsEvent(this.jsEvent);
        for (Survey thisSurvey : this) {
            surveyListSelect.addItem(thisSurvey.getId(), thisSurvey.getName());
        }
        return surveyListSelect.getHtml(selectName, defaultKey);
    }

    public void addItem(int key, String name) {
        Survey thisSurvey = new Survey();
        thisSurvey.setId(key);
        thisSurvey.setName(name);
        if (this.size() == 0) {
            this.add(thisSurvey);
        } else {
            this.add(0, thisSurvey);
        }
    }

    public boolean hasId(int surveyId) {
        for (Survey thisSurvey : this) {
            if (thisSurvey.getId() != surveyId) continue;
            return true;
        }
        return false;
    }
}

