/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.communications.base.Item;
import org.aspcfs.modules.communications.base.ItemList;
import org.aspcfs.utils.DatabaseUtils;

public class SurveyQuestion {
    public static final int OPEN_ENDED = 1;
    public static final int QUANT_NOCOMMENTS = 2;
    public static final int QUANT_COMMENTS = 3;
    public static final int QUANTITATIVE_SELECT_SIZE = 7;
    public static final int ITEMLIST = 4;
    private int id = -1;
    private int surveyId = -1;
    private int type = -1;
    private int position = 0;
    private String description = null;
    private boolean required = false;
    private ItemList itemList = null;
    public HashMap errors = new HashMap();
    public HashMap warnings = new HashMap();
    private boolean recordSurveyItems = true;

    public boolean getRecordSurveyItems() {
        return this.recordSurveyItems;
    }

    public void setRecordSurveyItems(boolean tmp) {
        this.recordSurveyItems = tmp;
    }

    public void setRecordSurveyItems(String tmp) {
        this.recordSurveyItems = DatabaseUtils.parseBoolean(tmp);
    }

    public SurveyQuestion() {
    }

    public SurveyQuestion(HttpServletRequest request) {
        this.setDescription(request.getParameter("questionText"));
        this.setType(Integer.parseInt(request.getParameter("type")));
        this.setPosition(Integer.parseInt(request.getParameter("position")));
        if (this.type == 4) {
            this.buildItems(request);
        }
        this.setRequired(request.getParameter("required") != null);
    }

    public SurveyQuestion(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setSurveyId(int tmp) {
        this.surveyId = tmp;
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public void buildItems(HttpServletRequest request) {
        this.itemList = new ItemList(request);
    }

    public void setItemList(ItemList itemList) {
        this.itemList = itemList;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setRequired(String required) {
        this.required = "yes".equalsIgnoreCase(required);
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setPosition(String tmp) {
        this.position = Integer.parseInt(tmp);
    }

    public int getPosition() {
        return this.position;
    }

    public int getQuestionId() {
        return this.id;
    }

    public boolean getRequired() {
        return this.required;
    }

    public ItemList getItemList() {
        return this.itemList;
    }

    public String getItems() {
        String token = "^|^";
        StringBuffer tmp = new StringBuffer();
        if (this.itemList != null) {
            for (Item thisItem : this.itemList) {
                tmp.append(thisItem.getDescription() + token);
            }
            if (tmp.length() > 0) {
                return tmp.substring(0, tmp.length() - token.length());
            }
        }
        return "";
    }

    public String getQuestionText() {
        return this.description;
    }

    public int getSurveyId() {
        return this.surveyId;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        if (this.type == 1) {
            return "Open Ended";
        }
        if (this.type == 2) {
            return "Quantitative";
        }
        if (this.type == 3) {
            return "Quantitative with Comments";
        }
        if (this.type == 4) {
            return "Item List";
        }
        return "-";
    }

    public void setSurveyId(String tmp) {
        this.surveyId = Integer.parseInt(tmp);
    }

    public void setType(String tmp) {
        this.type = Integer.parseInt(tmp);
    }

    public HashMap getErrors() {
        return this.errors;
    }

    public void setErrors(HashMap tmp) {
        this.errors = tmp;
    }

    public HashMap getWarnings() {
        return this.warnings;
    }

    public void setWarnings(HashMap tmp) {
        this.warnings = tmp;
    }

    public boolean insert(Connection db) throws SQLException {
        return this.insert(db, this.surveyId);
    }

    public boolean insert(Connection db, int surveyId) throws SQLException {
        if (surveyId == -1) {
            throw new SQLException("Survey ID not specified");
        }
        boolean doCommit = db.getAutoCommit();
        try {
            if (doCommit) {
                db.setAutoCommit(false);
            }
            int i = 0;
            PreparedStatement pst = db.prepareStatement("SELECT MAX(" + DatabaseUtils.addQuotes(db, "position") + ") AS maxposition " + "FROM survey_questions " + "WHERE survey_id = ? ");
            pst.setInt(++i, surveyId);
            ResultSet rs = pst.executeQuery();
            if (rs.next()) {
                this.position = rs.getInt("maxposition") + 1;
            }
            rs.close();
            pst.close();
            this.id = DatabaseUtils.getNextSeq(db, "survey_question_question_id_seq");
            pst = db.prepareStatement("INSERT INTO survey_questions (" + (this.id > -1 ? "question_id, " : "") + "survey_id, " + DatabaseUtils.addQuotes(db, "type") + ", description, required, " + DatabaseUtils.addQuotes(db, "position") + " ) " + "VALUES " + "(" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?) ");
            i = 0;
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, surveyId);
            pst.setInt(++i, this.type);
            pst.setString(++i, this.description);
            pst.setBoolean(++i, this.required);
            pst.setInt(++i, this.position);
            pst.execute();
            pst.close();
            this.setId(DatabaseUtils.getCurrVal(db, "survey_question_question_id_seq", this.id));
            if (this.recordSurveyItems && this.getType() == 4) {
                for (Item thisItem : this.getItemList()) {
                    thisItem.insert(db, this.getId());
                }
            }
            if (doCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void process(Connection db, int surveyId) throws SQLException {
        if (this.getId() == -1) {
            this.insert(db, surveyId);
        } else {
            this.update(db, surveyId);
        }
    }

    public void update(Connection db, int thisSurveyId) throws SQLException {
        boolean doCommit = db.getAutoCommit();
        try {
            if (doCommit) {
                db.setAutoCommit(false);
            }
            ItemList.delete(db, this.getId());
            PreparedStatement pst = db.prepareStatement("UPDATE survey_questions SET survey_id = ?, " + DatabaseUtils.addQuotes(db, "type") + " = ?, description = ?, required = ?, " + DatabaseUtils.addQuotes(db, "position") + " = ? " + "WHERE question_id = ? ");
            int i = 0;
            pst.setInt(++i, thisSurveyId);
            pst.setInt(++i, this.getType());
            pst.setString(++i, this.description);
            pst.setBoolean(++i, this.required);
            pst.setInt(++i, this.getPosition());
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            if (this.getType() == 4) {
                for (Item thisItem : this.getItemList()) {
                    thisItem.insert(db, this.getId());
                }
            }
            if (doCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
    }

    public boolean delete(Connection db, int thisSurveyId) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            int i = 0;
            if (commit) {
                db.setAutoCommit(false);
            }
            ItemList.delete(db, this.getId());
            PreparedStatement pst = db.prepareStatement("DELETE FROM survey_questions WHERE survey_id = ? AND question_id = ? ");
            pst.setInt(++i, thisSurveyId);
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.toString());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("question_id");
        this.surveyId = rs.getInt("survey_id");
        this.type = rs.getInt("type");
        this.description = rs.getString("description");
        this.required = rs.getBoolean("required");
        this.position = rs.getInt("position");
    }
}

