/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.communications.base.ItemList;
import org.aspcfs.modules.communications.base.SurveyQuestion;
import org.aspcfs.utils.DatabaseUtils;

public class SurveyQuestionList
extends ArrayList {
    public static final String tableName = "survey_questions";
    public static final String uniqueField = "question_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private int id = -1;
    private int surveyId = -1;
    private int questionId = -1;

    public SurveyQuestionList() {
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public SurveyQuestionList(HttpServletRequest request) {
        String question = null;
        String type = null;
        if (request.getParameter("questionId") != null) {
            this.questionId = Integer.parseInt(request.getParameter("questionId"));
        }
        if ((question = request.getParameter("questionText")) != null) {
            type = request.getParameter("type");
            if (!question.equals("") && type != null && Integer.parseInt(type) > 0) {
                SurveyQuestion thisItem = new SurveyQuestion(request);
                thisItem.setId(this.questionId);
                this.add(thisItem);
                if (System.getProperty("DEBUG") != null) {
                    System.out.println(" SurveyQuestionList -- > Added Question " + this.questionId + ":" + request.getParameter("questionText"));
                }
            }
        }
    }

    public SurveyQuestion getObject(ResultSet rs) throws SQLException {
        SurveyQuestion thisItem = new SurveyQuestion(rs);
        return thisItem;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setId(String id) {
        this.id = Integer.parseInt(id);
    }

    public void setQuestionId(int questionId) {
        this.questionId = questionId;
    }

    public int getQuestionId() {
        return this.questionId;
    }

    public int getSurveyId() {
        return this.surveyId;
    }

    public void setSurveyId(int surveyId) {
        this.surveyId = surveyId;
    }

    public void setSurveyId(String surveyId) {
        this.surveyId = Integer.parseInt(surveyId);
    }

    public SurveyQuestion getSurveyQuestion() {
        Iterator thisList = this.iterator();
        SurveyQuestion question = new SurveyQuestion();
        if (thisList.hasNext()) {
            while (thisList.hasNext()) {
                SurveyQuestion thisQuestion = (SurveyQuestion)thisList.next();
                if (thisQuestion.getId() != this.questionId) continue;
                question = thisQuestion;
            }
        }
        return question;
    }

    public static void delete(Connection db, int surveyId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM survey_questions WHERE survey_id = ?");
        pst.setInt(1, surveyId);
        pst.execute();
        pst.close();
    }

    public void process(Connection db, int surveyId) throws SQLException {
        SurveyQuestion question = this.getQuestion(this.questionId);
        if (question != null) {
            if (this.questionId == -1) {
                question.insert(db, surveyId);
            } else {
                question.update(db, surveyId);
            }
        }
    }

    public SurveyQuestion getQuestion(int questionId) {
        Iterator thisList = this.iterator();
        SurveyQuestion question = null;
        while (thisList.hasNext()) {
            SurveyQuestion thisQuestion = (SurveyQuestion)thisList.next();
            if (thisQuestion.getId() != questionId) continue;
            question = thisQuestion;
        }
        return question;
    }

    public boolean updateOrder(Connection db, int thisId, String direction) throws SQLException {
        SurveyQuestion thisQuestion = this.getQuestion(thisId);
        SurveyQuestion swapQuestion = null;
        if (direction.equalsIgnoreCase("U")) {
            if (this.indexOf(thisQuestion) > 0) {
                swapQuestion = (SurveyQuestion)this.get(this.indexOf(thisQuestion) - 1);
            }
        } else if (this.indexOf(thisQuestion) + 1 < this.size()) {
            swapQuestion = (SurveyQuestion)this.get(this.indexOf(thisQuestion) + 1);
        }
        if (swapQuestion != null) {
            int tmp = thisQuestion.getPosition();
            thisQuestion.setPosition(swapQuestion.getPosition());
            swapQuestion.setPosition(tmp);
            try {
                thisQuestion.update(db, this.surveyId);
                swapQuestion.update(db, this.surveyId);
            }
            catch (SQLException e) {
                throw new SQLException(e.getMessage());
            }
        }
        return true;
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            SurveyQuestion thisItem = this.getObject(rs);
            this.add(thisItem);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
        for (SurveyQuestion thisQuestion : this) {
            if (thisQuestion.getType() != 4) continue;
            ItemList itemList = new ItemList();
            itemList.setQuestionId(thisQuestion.getId());
            itemList.buildList(db);
            thisQuestion.setItemList(itemList);
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        String sql = "SELECT sq.* FROM survey_questions sq " + (this.surveyId > -1 ? "WHERE sq.survey_id = ? " : "") + "ORDER BY sq." + DatabaseUtils.addQuotes(db, "position") + " ";
        pst = db.prepareStatement(sql);
        int i = 0;
        if (this.surveyId > -1) {
            pst.setInt(++i, this.surveyId);
        }
        return pst.executeQuery();
    }
}

