/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import org.aspcfs.modules.communications.base.SurveyAnswerList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.DatabaseUtils;

public class SurveyResponse {
    public static int ADDRESS_UPDATED = 1;
    public static int ADDRESS_VALID = 0;
    public static int ADDRESS_NO_RESPONSE = 2;
    protected int id = -1;
    private int activeSurveyId = -1;
    private int contactId = -1;
    private String uniqueCode = null;
    private String ipAddress = null;
    private Timestamp entered = null;
    private SurveyAnswerList answers = new SurveyAnswerList();
    private Contact contact = null;
    private int addressUpdated = ADDRESS_NO_RESPONSE;

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setActiveSurveyId(String tmp) {
        this.activeSurveyId = Integer.parseInt(tmp);
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public SurveyResponse() {
    }

    public SurveyResponse(ResultSet rs) throws SQLException {
        this.id = rs.getInt("response_id");
        this.activeSurveyId = rs.getInt("active_survey_id");
        this.contactId = rs.getInt("contact_id");
        this.uniqueCode = rs.getString("unique_code");
        this.ipAddress = rs.getString("ip_address");
        this.entered = rs.getTimestamp("entered");
    }

    public SurveyResponse(ActionContext context) {
        this.setIpAddress(context.getIpAddress());
        this.answers = new SurveyAnswerList(context.getRequest());
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setActiveSurveyId(int tmp) {
        this.activeSurveyId = tmp;
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setUniqueCode(String tmp) {
        this.uniqueCode = tmp;
    }

    public void setIpAddress(String tmp) {
        this.ipAddress = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setAnswers(SurveyAnswerList tmp) {
        this.answers = tmp;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public void setAddressUpdated(int tmp) {
        this.addressUpdated = tmp;
    }

    public void setAddressUpdated(String tmp) {
        this.addressUpdated = Integer.parseInt(tmp);
    }

    public Contact getContact() {
        return this.contact;
    }

    public int getId() {
        return this.id;
    }

    public int getActiveSurveyId() {
        return this.activeSurveyId;
    }

    public int getContactId() {
        return this.contactId;
    }

    public String getUniqueCode() {
        return this.uniqueCode;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public String getEnteredString() {
        try {
            return DateFormat.getDateInstance(3).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getEnteredDateTimeString() {
        try {
            return DateFormat.getDateTimeInstance(3, 3).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public SurveyAnswerList getAnswers() {
        return this.answers;
    }

    public int getAddressUpdated() {
        return this.addressUpdated;
    }

    public boolean insert(Connection db) throws SQLException {
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "active_survey_r_response_id_seq");
            String sql = "INSERT INTO active_survey_responses (" + (this.id > -1 ? "response_id, " : "") + "active_survey_id, contact_id, unique_code, ip_address, address_updated) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?,?, ?, ?, ?) ";
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql);
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.activeSurveyId);
            pst.setInt(++i, this.contactId);
            pst.setString(++i, this.uniqueCode);
            pst.setString(++i, this.ipAddress);
            pst.setInt(++i, this.addressUpdated);
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "active_survey_r_response_id_seq", this.id);
            this.answers.insert(db, this.id);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM active_survey_responses WHERE response_id = ?");
        pst.setInt(1, this.id);
        pst.executeUpdate();
        pst.close();
        return true;
    }

    public void buildContact(Connection db) throws SQLException {
        if (this.contactId == -1) {
            throw new SQLException("Contact Id not specified");
        }
        this.setContact(new Contact(db, this.contactId));
    }
}

