/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.communications.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.communications.base.SurveyResponse;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class SurveyResponseList
extends ArrayList {
    public static final String tableName = "active_survey_responses";
    public static final String uniqueField = "response_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int surveyId = -1;
    private int addressUpdated = -1;
    private boolean onlyNotUpdated = false;
    private int contactId = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setSurveyId(int surveyId) {
        this.surveyId = surveyId;
    }

    public void setAddressUpdated(int tmp) {
        this.addressUpdated = tmp;
    }

    public void setAddressUpdated(String tmp) {
        this.addressUpdated = Integer.parseInt(tmp);
    }

    public void setOnlyNotUpdated(boolean tmp) {
        this.onlyNotUpdated = tmp;
    }

    public void setOnlyNotUpdated(String tmp) {
        this.onlyNotUpdated = DatabaseUtils.parseBoolean(tmp);
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public int getSurveyId() {
        return this.surveyId;
    }

    public int getAddressUpdated() {
        return this.addressUpdated;
    }

    public boolean getOnlyNotUpdated() {
        return this.onlyNotUpdated;
    }

    public int getContactId() {
        return this.contactId;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM active_survey_responses sr LEFT JOIN contact c ON (c.contact_id = sr.contact_id) WHERE sr.active_survey_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND (" + DatabaseUtils.toLowerCase(db) + "(c.namelast) < ? AND c.namelast IS NOT NULL) ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("c.namelast", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY c.namelast ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("sr.response_id, sr.active_survey_id, sr.contact_id, sr.unique_code, sr.ip_address, sr.entered FROM active_survey_responses sr LEFT JOIN contact c ON (c.contact_id = sr.contact_id) WHERE sr.active_survey_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            SurveyResponse thisResponse = new SurveyResponse(rs);
            this.add(thisResponse);
        }
        rs.close();
        pst.close();
        for (SurveyResponse thisResponse : this) {
            thisResponse.buildContact(db);
        }
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.surveyId != -1) {
            sqlFilter.append("AND sr.active_survey_id = ? ");
        }
        if (this.addressUpdated != -1) {
            sqlFilter.append("AND sr.address_updated = ? ");
        }
        if (this.onlyNotUpdated) {
            sqlFilter.append("AND sr.address_updated = ? AND sr.contact_id NOT IN (SELECT contact_id FROM active_survey_responses WHERE active_survey_id = ? AND address_updated = ?) ");
        }
        if (this.contactId != -1) {
            sqlFilter.append("AND sr.contact_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.surveyId != -1) {
            pst.setInt(++i, this.surveyId);
        }
        if (this.addressUpdated != -1) {
            pst.setInt(++i, this.addressUpdated);
        }
        if (this.onlyNotUpdated) {
            pst.setInt(++i, SurveyResponse.ADDRESS_VALID);
            pst.setInt(++i, this.getSurveyId());
            pst.setInt(++i, SurveyResponse.ADDRESS_UPDATED);
        }
        if (this.contactId != -1) {
            pst.setInt(++i, this.getContactId());
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public boolean delete(Connection db) throws SQLException {
        for (SurveyResponse surveyResponse : this) {
            surveyResponse.delete(db);
        }
        return true;
    }
}

