/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.components;

import java.sql.Connection;
import org.aspcfs.apps.workFlowManager.ComponentContext;
import org.aspcfs.apps.workFlowManager.ComponentInterface;
import org.aspcfs.controller.objectHookManager.ObjectHookComponent;
import org.aspcfs.modules.accounts.base.OrganizationHistory;

public class DeleteAccountHistory
extends ObjectHookComponent
implements ComponentInterface {
    public static final String ORG_ID = "history.orgId";
    public static final String LINK_OBJECT_ID = "history.linkObjectId";
    public static final String LINK_ITEM_ID = "history.linkItemId";
    public static final String PREVIOUS_ORG_ID = "history.previousOrgId";

    public String getDescription() {
        return "Delete the account's history entry";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ComponentContext context) {
        boolean result = false;
        OrganizationHistory history = new OrganizationHistory();
        Connection db = null;
        try {
            db = DeleteAccountHistory.getConnection(context);
            int currentOrgId = context.getParameterAsInt(ORG_ID);
            if (context.getParameter(PREVIOUS_ORG_ID) != null) {
                int previousContactId = context.getParameterAsInt(PREVIOUS_ORG_ID);
                if (previousContactId != currentOrgId) {
                    history.setContactId(previousContactId);
                } else {
                    history.setContactId(currentOrgId);
                }
            } else {
                history.setContactId(currentOrgId);
            }
            history.setLinkObjectId(context.getParameterAsInt(LINK_OBJECT_ID));
            history.setLinkItemId(context.getParameterAsInt(LINK_ITEM_ID));
            history.queryRecord(db);
            if (history.getId() != -1) {
                result = history.delete(db);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DeleteAccountHistory.freeConnection(context, db);
        }
        return result;
    }
}

