/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.components;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.aspcfs.apps.workFlowManager.ComponentContext;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.Notification;
import org.aspcfs.modules.contacts.base.Contact;

public class EmailDigestUtil {
    public static void appendEmailAddresses(HashMap mailList, String emails, String message, String prefix) {
        if (emails != null) {
            if (emails.indexOf(",") > -1) {
                StringTokenizer st = new StringTokenizer(emails, ",");
                while (st.hasMoreTokens()) {
                    String thisEmail = st.nextToken();
                    EmailDigestUtil.addMessage(mailList, thisEmail.trim(), message, prefix);
                }
            } else {
                EmailDigestUtil.addMessage(mailList, emails, message, prefix);
            }
        }
    }

    public static void appendEmailUsers(Connection db, HashMap mailList, String userIds, String message, String prefix) throws SQLException {
        if (userIds != null) {
            if (userIds.indexOf(",") > -1) {
                StringTokenizer st = new StringTokenizer(userIds, ",");
                while (st.hasMoreTokens()) {
                    String thisId = st.nextToken();
                    int id = -1;
                    try {
                        id = Integer.parseInt(thisId);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (id <= -1) continue;
                    User thisUser = new User(db, id);
                    thisUser.setBuildContact(true);
                    thisUser.setBuildContactDetails(true);
                    thisUser.buildResources(db);
                    EmailDigestUtil.addMessage(mailList, thisUser.getContact().getPrimaryEmailAddress(), message, prefix);
                }
            } else {
                int id = -1;
                try {
                    id = Integer.parseInt(userIds);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (id > -1) {
                    User thisUser = new User(db, id);
                    thisUser.setBuildContact(true);
                    thisUser.setBuildContactDetails(true);
                    thisUser.buildResources(db);
                    EmailDigestUtil.addMessage(mailList, thisUser.getContact().getPrimaryEmailAddress(), message, prefix);
                }
            }
        }
    }

    public static void appendEmailContacts(Connection db, HashMap mailList, String contactIds, String message, String prefix) throws SQLException {
        if (contactIds != null) {
            if (contactIds.indexOf(",") > -1) {
                StringTokenizer st = new StringTokenizer(contactIds, ",");
                while (st.hasMoreTokens()) {
                    String thisId = st.nextToken();
                    int id = -1;
                    try {
                        id = Integer.parseInt(thisId);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (id <= -1) continue;
                    Contact thisContact = new Contact(db, id);
                    EmailDigestUtil.addMessage(mailList, thisContact.getPrimaryEmailAddress(), message, prefix);
                }
            } else {
                int id = -1;
                try {
                    id = Integer.parseInt(contactIds);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (id > -1) {
                    Contact thisContact = new Contact(db, id);
                    EmailDigestUtil.addMessage(mailList, thisContact.getPrimaryEmailAddress(), message, prefix);
                }
            }
        }
    }

    public static void appendEmailDepartmentUsers(Connection db, HashMap mailList, String departmentId, String message, String prefix) throws SQLException {
        if (!(departmentId == null || "".equals(departmentId) || "-1".equals(departmentId) || "null".equals(departmentId))) {
            UserList users = new UserList();
            users.setDepartment(departmentId);
            users.setHidden(0);
            users.setBuildContact(true);
            users.setBuildContactDetails(true);
            users.setRoleType(0);
            users.buildList(db);
            for (User user : users) {
                EmailDigestUtil.addMessage(mailList, user.getContact().getPrimaryEmailAddress(), message, prefix);
            }
        }
    }

    public static void appendEmailRoleUsers(Connection db, HashMap mailList, String roleId, String message, String prefix) throws SQLException {
        if (!(roleId == null || "".equals(roleId) || "-1".equals(roleId) || "null".equals(roleId))) {
            UserList users = new UserList();
            users.setRoleId(Integer.parseInt(roleId));
            users.setHidden(0);
            users.setBuildContact(true);
            users.setBuildContactDetails(true);
            users.setRoleType(0);
            users.buildList(db);
            for (User user : users) {
                EmailDigestUtil.addMessage(mailList, user.getContact().getPrimaryEmailAddress(), message, prefix);
            }
        }
    }

    public static void appendEmailGroupUsers(Connection db, HashMap mailList, String groupId, String message, String prefix) throws SQLException {
        block7: {
            block8: {
                if (groupId == null || "".equals(groupId.trim())) break block7;
                if (groupId.indexOf(",") <= -1) break block8;
                StringTokenizer st = new StringTokenizer(groupId, ",");
                while (st.hasMoreTokens()) {
                    String thisId = st.nextToken();
                    int id = -1;
                    try {
                        id = Integer.parseInt(thisId);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (id <= -1) continue;
                    UserList users = new UserList();
                    users.setUserGroupId(id);
                    users.setHidden(0);
                    users.setBuildContact(true);
                    users.setBuildContactDetails(true);
                    users.setRoleType(0);
                    users.buildList(db);
                    for (User user : users) {
                        EmailDigestUtil.addMessage(mailList, user.getContact().getPrimaryEmailAddress(), message, prefix);
                    }
                }
                break block7;
            }
            int id = -1;
            try {
                id = Integer.parseInt(groupId);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (id <= -1) break block7;
            UserList users = new UserList();
            users.setUserGroupId(id);
            users.setHidden(0);
            users.setBuildContact(true);
            users.setBuildContactDetails(true);
            users.setRoleType(0);
            users.buildList(db);
            for (User user : users) {
                EmailDigestUtil.addMessage(mailList, user.getContact().getPrimaryEmailAddress(), message, prefix);
            }
        }
    }

    public static void skipEmailForUsers(Connection db, HashMap mailList, String userIds) throws SQLException {
        if (userIds != null) {
            if (userIds.indexOf(",") > -1) {
                StringTokenizer st = new StringTokenizer(userIds, ",");
                while (st.hasMoreTokens()) {
                    String thisId = st.nextToken();
                    int id = -1;
                    try {
                        id = Integer.parseInt(thisId);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (id <= -1) continue;
                    User thisUser = new User();
                    thisUser.setBuildContact(true);
                    thisUser.setBuildContactDetails(true);
                    thisUser.buildRecord(db, id);
                    EmailDigestUtil.removeMessage(mailList, thisUser.getContact().getPrimaryEmailAddress());
                }
            } else {
                int id = -1;
                try {
                    id = Integer.parseInt(userIds);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (id > -1) {
                    User thisUser = new User();
                    thisUser.setBuildContact(true);
                    thisUser.setBuildContactDetails(true);
                    thisUser.buildRecord(db, id);
                    EmailDigestUtil.removeMessage(mailList, thisUser.getContact().getPrimaryEmailAddress());
                }
            }
        }
    }

    public static void removeMessage(HashMap mailList, String emailAddress) {
        Map emailToList;
        if (emailAddress != null && (emailToList = (Map)mailList.get(emailAddress)) != null) {
            mailList.remove(emailAddress);
        }
    }

    public static void addMessage(HashMap mailList, String emailAddress, String thisMessage, String prefix) {
        if (emailAddress != null && thisMessage != null) {
            LinkedHashMap<String, String> emailToList = (LinkedHashMap<String, String>)mailList.get(emailAddress);
            if (emailToList == null) {
                emailToList = new LinkedHashMap<String, String>();
                mailList.put(emailAddress, emailToList);
            }
            emailToList.put(prefix, thisMessage);
        }
    }

    public static void setMessage(HashMap mailList, String emailAddress, String thisMessage, String prefix) {
        LinkedHashMap<String, String> emailToList;
        if (emailAddress != null && thisMessage != null && (emailToList = (LinkedHashMap<String, String>)mailList.get(emailAddress)) == null) {
            emailToList = new LinkedHashMap<String, String>();
            mailList.put(emailAddress, emailToList);
            emailToList.put(prefix, thisMessage);
        }
    }

    public static void sendMail(ComponentContext context, HashMap mailList) {
        Iterator toList = mailList.keySet().iterator();
        while (toList.hasNext()) {
            StringBuffer messageDigest = new StringBuffer();
            String emailAddressTo = (String)toList.next();
            Map emailToList = (Map)mailList.get(emailAddressTo);
            Iterator messages = emailToList.values().iterator();
            while (messages.hasNext()) {
                messageDigest.append((String)messages.next());
            }
            Notification thisNotification = new Notification();
            thisNotification.setSubject(context.getParameter("notification.subject"));
            String from = context.getParameter("notification.from");
            if (from != null && !"".equals(from)) {
                thisNotification.setFrom(from);
            } else {
                thisNotification.setFrom(context.getParameter("EMAILADDRESS"));
            }
            thisNotification.setType(1);
            thisNotification.setEmailToNotify(emailAddressTo);
            thisNotification.setMessageToSend(context.getParameter("notification.body") + messageDigest.toString());
            String host = context.getParameter("notification.host");
            if (host != null && !"".equals(host)) {
                thisNotification.setHost(host);
            } else {
                thisNotification.setHost(context.getParameter("MAILSERVER"));
            }
            thisNotification.notifyAddress();
        }
    }
}

