/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.components;

import java.sql.Connection;
import org.aspcfs.apps.workFlowManager.ComponentContext;
import org.aspcfs.apps.workFlowManager.ComponentInterface;
import org.aspcfs.controller.objectHookManager.ObjectHookComponent;
import org.aspcfs.modules.accounts.base.OrganizationHistory;

public class ResetAccountHistory
extends ObjectHookComponent
implements ComponentInterface {
    public static final String LEVEL = "history.level";
    public static final String ORG_ID = "history.orgId";
    public static final String LINK_OBJECT_ID = "history.linkObjectId";
    public static final String LINK_ITEM_ID = "history.linkItemId";
    public static final String DESCRIPTION = "history.description";
    public static final String ENABLED = "history.enabled";
    public static final String STATUS = "history.status";
    public static final String TYPE = "history.type";
    public static final String PREVIOUS_ORG_ID = "history.previousOrgId";
    public static final String MODIFIED_BY = "history.modifiedby";

    public String getDescription() {
        return "Reset the account's history entry";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ComponentContext context) {
        boolean result = false;
        OrganizationHistory history = new OrganizationHistory();
        int resultCount = -1;
        Connection db = null;
        try {
            db = ResetAccountHistory.getConnection(context);
            int previousOrgId = context.getParameterAsInt(PREVIOUS_ORG_ID);
            int currentOrgId = context.getParameterAsInt(ORG_ID);
            if (previousOrgId != currentOrgId && previousOrgId != -1) {
                history.setOrgId(previousOrgId);
            } else {
                history.setOrgId(currentOrgId);
            }
            history.setLinkObjectId(context.getParameterAsInt(LINK_OBJECT_ID));
            history.setLinkItemId(context.getParameterAsInt(LINK_ITEM_ID));
            history.queryRecord(db);
            history.setLevel(context.getParameterAsInt(LEVEL));
            history.setDescription(context.getParameter(DESCRIPTION));
            history.setStatus(context.getParameter(STATUS));
            history.setType(context.getParameter(TYPE));
            history.setModifiedBy(context.getParameter(MODIFIED_BY));
            history.setEnteredBy(context.getParameter(MODIFIED_BY));
            if (previousOrgId != currentOrgId) {
                history.setOrgId(currentOrgId);
            }
            if (history.getId() != -1) {
                resultCount = history.update(db);
                result = true;
            } else {
                result = history.insert(db);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ResetAccountHistory.freeConnection(context, db);
        }
        return resultCount > 0;
    }
}

