/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.components;

import java.sql.Connection;
import org.aspcfs.apps.workFlowManager.ComponentContext;
import org.aspcfs.apps.workFlowManager.ComponentInterface;
import org.aspcfs.controller.objectHookManager.ObjectHookComponent;
import org.aspcfs.modules.contacts.base.ContactHistory;

public class ResetContactHistory
extends ObjectHookComponent
implements ComponentInterface {
    public static final String LEVEL = "history.level";
    public static final String CONTACT_ID = "history.contactId";
    public static final String LINK_OBJECT_ID = "history.linkObjectId";
    public static final String LINK_ITEM_ID = "history.linkItemId";
    public static final String DESCRIPTION = "history.description";
    public static final String ENABLED = "history.enabled";
    public static final String STATUS = "history.status";
    public static final String TYPE = "history.type";
    public static final String PREVIOUS_CONTACT_ID = "history.previousContactId";
    public static final String MODIFIED_BY = "history.modifiedby";

    public String getDescription() {
        return "Reset the contact's history entry";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ComponentContext context) {
        boolean result = false;
        ContactHistory history = new ContactHistory();
        Connection db = null;
        try {
            db = ResetContactHistory.getConnection(context);
            int previousContactId = context.getParameterAsInt(PREVIOUS_CONTACT_ID);
            int currentContactId = context.getParameterAsInt(CONTACT_ID);
            if (previousContactId != currentContactId && previousContactId != -1) {
                history.setContactId(previousContactId);
            } else {
                history.setContactId(currentContactId);
            }
            history.setLinkObjectId(context.getParameterAsInt(LINK_OBJECT_ID));
            history.setLinkItemId(context.getParameterAsInt(LINK_ITEM_ID));
            history.queryRecord(db);
            history.setLevel(context.getParameterAsInt(LEVEL));
            history.setDescription(context.getParameter(DESCRIPTION));
            history.setStatus(context.getParameter(STATUS));
            history.setType(context.getParameter(TYPE));
            history.setModifiedBy(context.getParameter(MODIFIED_BY));
            history.setEnabled(context.getParameterAsBoolean(ENABLED));
            history.setEnteredBy(context.getParameter(MODIFIED_BY));
            if (previousContactId != currentContactId) {
                history.setContactId(currentContactId);
                history.setReset(true);
            }
            if (history.getId() != -1) {
                history.update(db);
                result = true;
            } else {
                history.insert(db);
                result = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ResetContactHistory.freeConnection(context, db);
        }
        return result;
    }
}

