/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.components;

import java.sql.Connection;
import org.aspcfs.apps.workFlowManager.ComponentContext;
import org.aspcfs.apps.workFlowManager.ComponentInterface;
import org.aspcfs.controller.objectHookManager.ObjectHookComponent;
import org.aspcfs.modules.accounts.base.OrganizationHistory;

public class ResetToContactHistory
extends ObjectHookComponent
implements ComponentInterface {
    public static final String LEVEL = "history.level";
    public static final String CONTACT_ID = "history.contactId";
    public static final String ORG_ID = "history.orgId";
    public static final String LINK_OBJECT_ID = "history.linkObjectId";
    public static final String LINK_ITEM_ID = "history.linkItemId";
    public static final String DESCRIPTION = "history.description";
    public static final String ENABLED = "history.enabled";
    public static final String STATUS = "history.status";
    public static final String TYPE = "history.type";
    public static final String PREVIOUS_CONTACT_ID = "history.previousContactId";
    public static final String MODIFIED_BY = "history.modifiedby";
    public static final String RESET = "history.reset";

    public String getDescription() {
        return "Reset the history for the entry";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ComponentContext context) {
        boolean result = false;
        OrganizationHistory history = null;
        String reset = null;
        Connection db = null;
        try {
            db = ResetToContactHistory.getConnection(context);
            reset = context.getParameter(RESET);
            int contactId = context.getParameterAsInt(CONTACT_ID);
            int orgId = context.getParameterAsInt(ORG_ID);
            history = new OrganizationHistory();
            if (reset.equals("contact")) {
                history.setContactId(contactId);
            } else if (reset.equals("account")) {
                history.setOrgId(orgId);
            }
            history.setLinkObjectId(context.getParameterAsInt(LINK_OBJECT_ID));
            history.setLinkItemId(context.getParameterAsInt(LINK_ITEM_ID));
            history.queryRecord(db);
            if (reset.equals("contact")) {
                history.setContactId(-1);
                history.setOrgId(orgId);
            } else if (reset.equals("account")) {
                history.setContactId(contactId);
                history.setOrgId(-1);
            }
            history.setLevel(context.getParameterAsInt(LEVEL));
            history.setDescription(context.getParameter(DESCRIPTION));
            history.setStatus(context.getParameter(STATUS));
            history.setType(context.getParameter(TYPE));
            history.setModifiedBy(context.getParameter(MODIFIED_BY));
            history.setEnteredBy(context.getParameter(MODIFIED_BY));
            history.setReset(true);
            if (history.getId() > -1) {
                history.update(db);
                result = true;
            } else {
                history.insert(db);
                result = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ResetToContactHistory.freeConnection(context, db);
        }
        return result;
    }
}

