/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.components;

import java.sql.Connection;
import java.util.HashMap;
import org.aspcfs.apps.workFlowManager.ComponentContext;
import org.aspcfs.apps.workFlowManager.ComponentInterface;
import org.aspcfs.controller.objectHookManager.ObjectHookComponent;
import org.aspcfs.modules.components.EmailDigestUtil;

public class SendEmailNotification
extends ObjectHookComponent
implements ComponentInterface {
    public static final String HOST = "notification.host";
    public static final String MODULE = "notification.module";
    public static final String ITEM_ID = "notification.itemId";
    public static final String ITEM_MODIFIED = "notification.itemModified";
    public static final String USER_TO_NOTIFY = "notification.userToNotify";
    public static final String SUBJECT = "notification.subject";
    public static final String FROM = "notification.from";
    public static final String REPLY_TO = "notification.replyTo";
    public static final String BODY = "notification.body";
    public static final String SKIP_USERS = "notification.skipUsers";
    public static final String EMAIL_TO = "notification.to";
    public static final String USER_TO = "notification.users.to";
    public static final String CONTACT_TO = "notification.contacts.to";
    public static final String DEPARTMENT_TO = "notification.departments.to";
    public static final String GROUP_TO = "notification.userGroupToNotify";
    public static final String ROLE_TO = "notification.roleTo";

    public String getDescription() {
        return "Sends notifications to specified users with the specified parameters";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ComponentContext context) {
        boolean result = false;
        Connection db = null;
        HashMap mailList = new HashMap();
        try {
            db = SendEmailNotification.getConnection(context);
            String thisMessage = "";
            String thisSubject = context.getParameter(SUBJECT);
            EmailDigestUtil.appendEmailAddresses(mailList, context.getParameter(EMAIL_TO), thisMessage, thisSubject);
            String usersTo = context.getParameter(USER_TO);
            if (usersTo == null || "".equals(usersTo.trim())) {
                usersTo = context.getParameter(USER_TO_NOTIFY);
            }
            EmailDigestUtil.appendEmailUsers(db, mailList, usersTo, thisMessage, thisSubject);
            EmailDigestUtil.appendEmailContacts(db, mailList, context.getParameter(CONTACT_TO), thisMessage, thisSubject);
            EmailDigestUtil.appendEmailDepartmentUsers(db, mailList, context.getParameter(DEPARTMENT_TO), thisMessage, thisSubject);
            EmailDigestUtil.appendEmailGroupUsers(db, mailList, context.getParameter(GROUP_TO), thisMessage, thisSubject);
            EmailDigestUtil.appendEmailRoleUsers(db, mailList, context.getParameter(ROLE_TO), thisMessage, thisSubject);
            EmailDigestUtil.skipEmailForUsers(db, mailList, context.getParameter(SKIP_USERS));
            EmailDigestUtil.sendMail(context, mailList);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            SendEmailNotification.freeConnection(context, db);
        }
        return result;
    }
}

