/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.components;

import java.sql.Connection;
import org.aspcfs.apps.workFlowManager.ComponentContext;
import org.aspcfs.apps.workFlowManager.ComponentInterface;
import org.aspcfs.controller.objectHookManager.ObjectHookComponent;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.Notification;
import org.aspcfs.utils.StringUtils;

public class SendUserNotification
extends ObjectHookComponent
implements ComponentInterface {
    public static final String HOST = "notification.host";
    public static final String MODULE = "notification.module";
    public static final String ITEM_ID = "notification.itemId";
    public static final String ITEM_MODIFIED = "notification.itemModified";
    public static final String USER_TO_NOTIFY = "notification.userToNotify";
    public static final String SUBJECT = "notification.subject";
    public static final String FROM = "notification.from";
    public static final String REPLY_TO = "notification.replyTo";
    public static final String BODY = "notification.body";
    public static final String SKIP_USERS = "notification.skipUsers";
    public static final String EMAIL_TO = "notification.to";
    public static final String USER_TO = "notification.users.to";
    public static final String CONTACT_TO = "notification.contacts.to";
    public static final String DEPARTMENT_TO = "notification.departments.to";
    public static final String GROUP_TO = "notification.userGroupToNotify";
    public static final String EMAIL_TO_USER_AND_GROUP = "notification.emailBothUserAndGroup";
    public static final String ROLE_TO = "notification.roleTo";

    public String getDescription() {
        return "Send an email notification to a user";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ComponentContext context) {
        boolean result = false;
        boolean both = false;
        Connection db = null;
        try {
            db = SendUserNotification.getConnection(context);
            String groupId = context.getParameter(GROUP_TO);
            String bothString = context.getParameter(EMAIL_TO_USER_AND_GROUP);
            if (bothString != null && "true".equals(bothString.trim())) {
                both = true;
            }
            String skipUser = context.getParameter(SKIP_USERS);
            Notification thisNotification = new Notification();
            thisNotification.setUserToNotify(context.getParameterAsInt(USER_TO_NOTIFY));
            thisNotification.setModule(context.getParameter(MODULE));
            thisNotification.setItemId(context.getParameterAsInt(ITEM_ID));
            thisNotification.setItemModified(null);
            thisNotification.setSubject(StringUtils.toHtml(context.getParameter(SUBJECT)));
            String from = StringUtils.toHtmlValue(context.getParameter(FROM));
            if (from != null && !"".equals(from)) {
                thisNotification.setFrom(from);
            } else {
                thisNotification.setFrom(context.getParameter("EMAILADDRESS"));
            }
            thisNotification.setMessageToSend(context.getParameter(BODY));
            thisNotification.setType(1);
            String host = context.getParameter(HOST);
            if (host != null && !"".equals(host)) {
                thisNotification.setHost(host);
            } else {
                thisNotification.setHost(context.getParameter("MAILSERVER"));
            }
            boolean userInGroup = false;
            if (groupId != null && !"".equals(groupId) && !"-1".equals(groupId)) {
                UserList users = new UserList();
                users.setUserGroupId(groupId);
                users.setEnabled(1);
                users.setExpired(0);
                users.setBuildContact(true);
                users.setBuildContactDetails(true);
                users.buildList(db);
                for (User user : users) {
                    if (user.getId() == context.getParameterAsInt(USER_TO_NOTIFY)) {
                        userInGroup = true;
                        continue;
                    }
                    if (!user.getEnabled()) continue;
                    thisNotification.setUserToNotify(user.getId());
                    thisNotification.notifyUser(db);
                }
            }
            if (!((userInGroup || groupId == null || "".equals(groupId) || "-1".equals(groupId)) && !both || skipUser != null && "true".equals(skipUser))) {
                thisNotification.notifyUser(db);
            }
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        finally {
            SendUserNotification.freeConnection(context, db);
        }
        return result;
    }
}

